/*
 * Decompiled with CFR 0.152.
 */
package org.mule.twitter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import twitter4j.GeoLocation;
import twitter4j.IDs;
import twitter4j.Paging;
import twitter4j.Query;
import twitter4j.QueryResult;
import twitter4j.ResponseList;
import twitter4j.Status;
import twitter4j.StatusUpdate;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.User;
import twitter4j.auth.AccessToken;
import twitter4j.auth.RequestToken;
import twitter4j.conf.ConfigurationBuilder;
import twitter4j.internal.http.alternative.HttpClientImpl;

public class TwitterConnector
implements Initialisable,
MuleContextAware {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private Twitter twitter;
    private String consumerKey;
    private String consumerSecret;
    private String accessToken;
    private String accessTokenSecret;
    private boolean useSSL;

    public void initialise() throws InitialisationException {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.setUseSSL(this.useSSL);
        this.twitter = new TwitterFactory(cb.build()).getInstance();
        this.twitter.setOAuthConsumer(this.consumerKey, this.consumerSecret);
        if (this.accessToken != null) {
            this.twitter.setOAuthAccessToken(new AccessToken(this.accessToken, this.accessTokenSecret));
        }
    }

    public QueryResult search(String query) throws TwitterException {
        return this.twitter.search(new Query(query));
    }

    public ResponseList<Status> getPublicTimeline() throws TwitterException {
        return this.twitter.getPublicTimeline();
    }

    public ResponseList<Status> getHomeTimeline(int page, int count, int sinceId) throws TwitterException {
        return this.twitter.getHomeTimeline(this.getPaging(page, count, sinceId));
    }

    public ResponseList<Status> getUserTimelineByScreenName(String screenName, int page, int count, int sinceId) throws TwitterException {
        return this.twitter.getUserTimeline(screenName, this.getPaging(page, count, sinceId));
    }

    public ResponseList<Status> getUserTimelineByUserId(long userId, int page, int count, int sinceId) throws TwitterException {
        return this.twitter.getUserTimeline(userId, this.getPaging(page, count, sinceId));
    }

    protected Paging getPaging(int page, int count, long sinceId) {
        Paging paging = new Paging(page, count);
        if (sinceId > 0L) {
            paging.setSinceId(sinceId);
        }
        return paging;
    }

    public ResponseList<Status> getUserTimeline(int page, int count, int sinceId) throws TwitterException {
        return this.twitter.getUserTimeline(this.getPaging(page, count, sinceId));
    }

    public ResponseList<Status> getMentions(int page, int count, int sinceId) throws TwitterException {
        return this.twitter.getMentions(this.getPaging(page, count, sinceId));
    }

    public ResponseList<Status> getRetweetedByMe(int page, int count, int sinceId) throws TwitterException {
        return this.twitter.getRetweetedByMe(this.getPaging(page, count, sinceId));
    }

    public ResponseList<Status> getRetweetedToMe(int page, int count, int sinceId) throws TwitterException {
        return this.twitter.getRetweetedToMe(this.getPaging(page, count, sinceId));
    }

    public ResponseList<Status> getRetweetsOfMe(int page, int count, int sinceId) throws TwitterException {
        return this.twitter.getRetweetsOfMe(this.getPaging(page, count, sinceId));
    }

    public ResponseList<Status> getRetweetedToUserByScreenName(String screenName, int page, int count, int sinceId) throws TwitterException {
        return this.twitter.getRetweetedToUser(screenName, this.getPaging(page, count, sinceId));
    }

    public ResponseList<Status> getRetweetedToUserByUserId(long userId, int page, int count, int sinceId) throws TwitterException {
        return this.twitter.getRetweetedToUser(userId, this.getPaging(page, count, sinceId));
    }

    public ResponseList<Status> getRetweetedByUserByScreenName(String screenName, int page, int count, int sinceId) throws TwitterException {
        return this.twitter.getRetweetedByUser(screenName, this.getPaging(page, count, sinceId));
    }

    public ResponseList<Status> getRetweetedByUserByUserId(long userId, int page, int count, int sinceId) throws TwitterException {
        return this.twitter.getRetweetedByUser(userId, this.getPaging(page, count, sinceId));
    }

    public Status showStatus(long id) throws TwitterException {
        return this.twitter.showStatus(id);
    }

    public Status updateStatus(String status, long inReplyTo, GeoLocation geoLocation) throws TwitterException {
        StatusUpdate update = new StatusUpdate(status);
        if (inReplyTo > 0L) {
            update.setInReplyToStatusId(inReplyTo);
        }
        if (geoLocation != null) {
            update.setLocation(geoLocation);
        }
        return this.twitter.updateStatus(status);
    }

    public Status destroyStatus(long statusId) throws TwitterException {
        return this.twitter.destroyStatus(statusId);
    }

    public Status retweetStatus(long statusId) throws TwitterException {
        return this.twitter.retweetStatus(statusId);
    }

    public ResponseList<Status> getRetweets(long statusId) throws TwitterException {
        return this.twitter.getRetweets(statusId);
    }

    public ResponseList<User> getRetweetedBy(long statusId, int page, int count, int sinceId) throws TwitterException {
        return this.twitter.getRetweetedBy(statusId, this.getPaging(page, count, sinceId));
    }

    public IDs getRetweetedByIDs(long statusId, int page, int count, int sinceId) throws TwitterException {
        return this.twitter.getRetweetedByIDs(statusId, this.getPaging(page, count, sinceId));
    }

    public void setOauthVerifier(String oauthVerifier) throws TwitterException {
        AccessToken accessToken = this.twitter.getOAuthAccessToken(oauthVerifier);
        this.logger.info((Object)("Got OAuth access tokens. Access token:" + accessToken.getToken() + " Access token secret:" + accessToken.getTokenSecret()));
    }

    public String requestAuthorization(String callbackUrl) throws TwitterException {
        RequestToken token = this.twitter.getOAuthRequestToken();
        return token.getAuthorizationURL();
    }

    public Twitter getTwitterClient() {
        return this.twitter;
    }

    public boolean getUseSSL() {
        return this.useSSL;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setAccessTokenSecret(String accessTokenSecret) {
        this.accessTokenSecret = accessTokenSecret;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public void setMuleContext(MuleContext context) {
        HttpClientImpl.setMuleContext(context);
    }
}

