/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.spring.security.config;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.security.SecurityManager;
import org.mule.runtime.core.api.security.SecurityProvider;
import org.mule.runtime.core.security.DefaultMuleSecurityManager;
import org.mule.runtime.dsl.api.component.ObjectFactory;

public class MuleSecurityManagerConfigurator
implements ObjectFactory<SecurityManager> {
    private List<SecurityProvider> providers = new ArrayList<SecurityProvider>();
    private MuleContext muleContext;
    private String name = "_muleSecurityManager";

    public void setName(String name) {
        this.name = name;
    }

    @Inject
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public void setProviders(List<SecurityProvider> providers) {
        this.providers = providers;
    }

    public SecurityManager getObject() throws Exception {
        ArrayList<SecurityManager> securityManagers = new ArrayList<SecurityManager>();
        securityManagers.add(this.muleContext.getSecurityManager());
        SecurityManager factorySecurityManager = this.muleContext.getSecurityManager();
        if (!this.name.equals("_muleSecurityManager")) {
            factorySecurityManager = new DefaultMuleSecurityManager();
            securityManagers.add(factorySecurityManager);
        }
        this.providers.stream().forEach(provider -> securityManagers.stream().forEach(securityManager -> securityManager.addProvider(provider)));
        return factorySecurityManager;
    }
}

