/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.spring.events;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArraySet;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import java.beans.ExceptionListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.DefaultMuleSession;
import org.mule.RegistryContext;
import org.mule.RequestContext;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.MuleSession;
import org.mule.api.context.MuleContextAware;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointFactory;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.MalformedEndpointException;
import org.mule.api.model.Model;
import org.mule.api.routing.InboundRouterCollection;
import org.mule.api.routing.filter.ObjectFilter;
import org.mule.api.service.Service;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.Connector;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.extras.spring.events.ApplicationEventException;
import org.mule.extras.spring.events.AsynchronousEventListener;
import org.mule.extras.spring.events.MuleApplicationEvent;
import org.mule.extras.spring.events.MuleEventListener;
import org.mule.extras.spring.events.MuleSubscriptionEventListener;
import org.mule.extras.spring.i18n.SpringMessages;
import org.mule.model.seda.SedaModel;
import org.mule.model.seda.SedaService;
import org.mule.routing.filters.WildcardFilter;
import org.mule.transport.AbstractConnector;
import org.mule.util.ClassUtils;
import org.mule.util.object.ObjectFactory;
import org.mule.util.object.PrototypeObjectFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;

public class MuleEventMulticaster
implements ApplicationEventMulticaster,
ApplicationContextAware,
MuleContextAware {
    public static final String EVENT_MULTICASTER_DESCRIPTOR_NAME = "muleEventMulticasterDescriptor";
    protected static final Log logger = LogFactory.getLog(MuleEventMulticaster.class);
    protected final Set listeners = new CopyOnWriteArraySet();
    protected boolean asynchronous = false;
    protected ExecutorService asyncPool = null;
    protected Map endpointMappings = null;
    protected String[] subscriptions = null;
    protected ApplicationContext applicationContext;
    protected Service service;
    protected Class subscriptionFilter = WildcardFilter.class;
    protected ExceptionListener exceptionListener = new LoggingExceptionListener();
    protected MuleContext muleContext;

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void addApplicationListener(ApplicationListener listener) {
        ApplicationListener listenerToAdd = listener;
        if (this.asynchronous) {
            listenerToAdd = new AsynchronousEventListener(this.asyncPool, listener);
        }
        this.listeners.add(listenerToAdd);
    }

    public void removeApplicationListener(ApplicationListener listener) {
        for (ApplicationListener applicationListener : this.listeners) {
            if (applicationListener instanceof AsynchronousEventListener) {
                if (!((AsynchronousEventListener)applicationListener).getListener().equals(listener)) continue;
                this.listeners.remove(applicationListener);
                return;
            }
            if (!applicationListener.equals(listener)) continue;
            this.listeners.remove(applicationListener);
            return;
        }
        this.listeners.remove(listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public void multicastEvent(ApplicationEvent e) {
        MuleApplicationEvent muleEvent = null;
        if (e instanceof ContextRefreshedEvent) {
            if (this.muleContext != null && !this.muleContext.isInitialised()) {
                try {
                    this.registerMulticasterComponent();
                }
                catch (MuleException ex) {
                    throw new MuleRuntimeException(SpringMessages.failedToReinitMule(), (Throwable)ex);
                }
            } else {
                this.initMule();
            }
        } else {
            if (e instanceof ContextClosedEvent) {
                this.muleContext.dispose();
                return;
            }
            if (e instanceof MuleApplicationEvent && (muleEvent = (MuleApplicationEvent)e).getMuleEventContext() == null) {
                try {
                    this.dispatchEvent(muleEvent);
                }
                catch (ApplicationEventException e1) {
                    this.exceptionListener.exceptionThrown(e1);
                }
                return;
            }
        }
        block4: for (ApplicationListener listener : this.listeners) {
            if (muleEvent != null) {
                if (listener instanceof AsynchronousEventListener) {
                    AsynchronousEventListener asyncListener = (AsynchronousEventListener)listener;
                    if (asyncListener.getListener() instanceof MuleSubscriptionEventListener) {
                        if (!this.isSubscriptionMatch(muleEvent.getEndpoint(), ((MuleSubscriptionEventListener)asyncListener.getListener()).getSubscriptions())) continue;
                        asyncListener.onApplicationEvent(muleEvent);
                        continue;
                    }
                    if (asyncListener.getListener() instanceof MuleEventListener) {
                        asyncListener.onApplicationEvent(muleEvent);
                        continue;
                    }
                    if (asyncListener.getListener() instanceof MuleEventListener) continue;
                    asyncListener.onApplicationEvent(e);
                    continue;
                }
                if (listener instanceof MuleSubscriptionEventListener) {
                    if (!this.isSubscriptionMatch(muleEvent.getEndpoint(), ((MuleSubscriptionEventListener)listener).getSubscriptions())) continue;
                    listener.onApplicationEvent((ApplicationEvent)muleEvent);
                    continue;
                }
                if (!(listener instanceof MuleEventListener)) continue;
                listener.onApplicationEvent((ApplicationEvent)muleEvent);
                continue;
            }
            if (listener instanceof AsynchronousEventListener && !(((AsynchronousEventListener)listener).getListener() instanceof MuleEventListener)) {
                listener.onApplicationEvent(e);
                continue;
            }
            if (!(listener instanceof MuleEventListener)) {
                listener.onApplicationEvent(e);
                continue;
            }
            for (int i = 0; i < listener.getClass().getInterfaces().length; ++i) {
                if (!listener.getClass().getInterfaces()[i].equals(ApplicationListener.class)) continue;
                listener.onApplicationEvent(e);
                continue block4;
            }
        }
    }

    private boolean isSubscriptionMatch(String endpoint, String[] subscriptions) {
        for (int i = 0; i < subscriptions.length; ++i) {
            String subscription = subscriptions[i];
            ObjectFilter filter = this.createFilter(subscription);
            if (!filter.accept((Object)endpoint)) continue;
            return true;
        }
        return false;
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public void setAsynchronous(boolean asynchronous) {
        this.asynchronous = asynchronous;
        if (asynchronous) {
            if (this.asyncPool == null) {
                this.asyncPool = RegistryContext.getConfiguration().getDefaultThreadingProfile().createPool("spring-events");
            }
        } else if (this.asyncPool != null) {
            this.asyncPool.shutdown();
            this.asyncPool = null;
        }
    }

    public void onMuleEvent(MuleEventContext context) throws TransformerException, MalformedEndpointException {
        this.multicastEvent(new MuleApplicationEvent(context.transformMessage(), context, this.applicationContext));
        context.setStopFurtherProcessing(true);
    }

    protected void dispatchEvent(MuleApplicationEvent applicationEvent) throws ApplicationEventException {
        ImmutableEndpoint endpoint;
        try {
            endpoint = this.muleContext.getRegistry().lookupEndpointFactory().getOutboundEndpoint(applicationEvent.getEndpoint());
        }
        catch (MuleException e) {
            throw new ApplicationEventException("Failed to get endpoint for endpointUri: " + applicationEvent.getEndpoint(), e);
        }
        if (endpoint != null) {
            try {
                DefaultMuleMessage message = new DefaultMuleMessage(applicationEvent.getSource(), applicationEvent.getProperties());
                if (applicationEvent.getMuleEventContext() != null) {
                    applicationEvent.getMuleEventContext().setStopFurtherProcessing(true);
                    applicationEvent.getMuleEventContext().dispatchEvent((MuleMessage)message, endpoint);
                }
                DefaultMuleSession session = new DefaultMuleSession((MuleMessage)message, ((AbstractConnector)endpoint.getConnector()).getSessionHandler(), this.service);
                RequestContext.setEvent((MuleEvent)new DefaultMuleEvent((MuleMessage)message, endpoint, (MuleSession)session, false));
                if (endpoint.getTransformers() != null) {
                    message = new DefaultMuleMessage(applicationEvent.getSource(), applicationEvent.getProperties());
                    message.applyTransformers(endpoint.getTransformers());
                }
                endpoint.dispatch((MuleEvent)new DefaultMuleEvent((MuleMessage)message, endpoint, (MuleSession)session, false));
            }
            catch (Exception e1) {
                throw new ApplicationEventException("Failed to dispatch event: " + e1.getMessage(), e1);
            }
        } else {
            throw new ApplicationEventException("Failed endpoint using name: " + applicationEvent.getEndpoint());
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected void initMule() {
        try {
            if (this.applicationContext.containsBean(EVENT_MULTICASTER_DESCRIPTOR_NAME)) {
                this.service = (Service)this.applicationContext.getBean(EVENT_MULTICASTER_DESCRIPTOR_NAME);
            }
            if (this.applicationContext.containsBean("muleManager")) {
                this.registerMulticasterComponent();
                return;
            }
            if (!this.muleContext.isStarted()) {
                RegistryContext.getConfiguration().setDefaultSynchronousEndpoints(!this.asynchronous);
            }
            this.registerConnectors();
            this.registerTransformers();
            this.registerMulticasterComponent();
            if (!this.muleContext.isStarted()) {
                this.muleContext.start();
            }
        }
        catch (MuleException e) {
            throw new MuleRuntimeException(SpringMessages.failedToReinitMule(), (Throwable)e);
        }
    }

    protected void registerMulticasterComponent() throws MuleException {
        if (this.service == null) {
            this.service = this.getDefaultService();
            this.setSubscriptionsOnService(this.service);
            this.muleContext.getRegistry().registerService(this.service);
            this.service = this.muleContext.getRegistry().lookupService(this.service.getName());
        }
    }

    protected void setSubscriptionsOnService(Service service) throws MuleException {
        ArrayList<String> endpoints = new ArrayList<String>();
        for (ApplicationListener listener : this.listeners) {
            if (listener instanceof AsynchronousEventListener) {
                listener = ((AsynchronousEventListener)listener).getListener();
            }
            if (!(listener instanceof MuleSubscriptionEventListener)) continue;
            String[] subscriptions = ((MuleSubscriptionEventListener)listener).getSubscriptions();
            for (int i = 0; i < subscriptions.length; ++i) {
                boolean isSoap;
                if (subscriptions[i].indexOf("*") != -1 || !MuleEndpointURI.isMuleUri((String)subscriptions[i]) || (isSoap = this.registerAsSoap(subscriptions[i], listener))) continue;
                endpoints.add(subscriptions[i]);
            }
        }
        if (endpoints.size() > 0) {
            for (String endpoint : endpoints) {
                ImmutableEndpoint ep = this.muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint(endpoint);
                if (service.getInboundRouter().getEndpoint(ep.getName()) != null) continue;
                service.getInboundRouter().addEndpoint(ep);
            }
        }
    }

    private boolean registerAsSoap(String endpoint, Object listener) throws MuleException {
        throw new DefaultMuleException("Need to reimplement this method without using the QuickConfigurationBuilder.");
    }

    protected void registerConnectors() throws MuleException {
        Map connectors;
        if (!this.muleContext.isInitialised() && (connectors = this.applicationContext.getBeansOfType(Connector.class, true, true)).size() > 0) {
            for (Map.Entry entry : connectors.entrySet()) {
                Connector c = (Connector)entry.getValue();
                if (c.getName() == null) {
                    c.setName(entry.getKey().toString());
                }
                this.muleContext.getRegistry().registerConnector(c);
            }
        }
    }

    protected void registerTransformers() throws MuleException {
        Map transformers;
        if (!this.muleContext.isInitialised() && (transformers = this.applicationContext.getBeansOfType(Transformer.class, true, true)).size() > 0) {
            for (Map.Entry entry : transformers.entrySet()) {
                Transformer t = (Transformer)entry.getValue();
                if (t.getName() == null) {
                    t.setName(entry.getKey().toString());
                }
                this.muleContext.getRegistry().registerTransformer(t);
            }
        }
    }

    protected Service getDefaultService() throws MuleException {
        Service service;
        Model model = this.muleContext.getRegistry().lookupModel("_muleSystemModel");
        if (model == null) {
            model = new SedaModel();
            model.setName("_muleSystemModel");
            this.muleContext.getRegistry().registerModel(model);
        }
        if ((service = this.muleContext.getRegistry().lookupService(EVENT_MULTICASTER_DESCRIPTOR_NAME)) != null) {
            this.muleContext.getRegistry().unregisterComponent(service.getName());
        }
        service = new SedaService();
        service.setName(EVENT_MULTICASTER_DESCRIPTOR_NAME);
        if (this.subscriptions == null) {
            logger.info((Object)"No receive endpoints have been set, using default '*'");
            service.getInboundRouter().addEndpoint(this.muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("vm://*"));
        } else {
            InboundRouterCollection messageRouter = service.getInboundRouter();
            for (int i = 0; i < this.subscriptions.length; ++i) {
                String subscription = this.subscriptions[i];
                EndpointFactory endpointFactory = this.muleContext.getRegistry().lookupEndpointFactory();
                EndpointBuilder endpointBuilder = endpointFactory.getEndpointBuilder(subscription);
                endpointBuilder.setSynchronous(!this.asynchronous);
                ImmutableEndpoint endpoint = endpointFactory.getInboundEndpoint(endpointBuilder);
                messageRouter.addEndpoint(endpoint);
            }
        }
        service.setServiceFactory((ObjectFactory)new PrototypeObjectFactory(MuleEventMulticaster.class));
        return service;
    }

    protected ObjectFilter createFilter(String pattern) {
        try {
            if (this.getSubscriptionFilter() == null) {
                this.setSubscriptionFilter(WildcardFilter.class);
            }
            ObjectFilter filter = (ObjectFilter)ClassUtils.instanciateClass((Class)this.getSubscriptionFilter(), (Object[])new Object[]{pattern});
            return filter;
        }
        catch (Exception e) {
            this.exceptionListener.exceptionThrown(e);
            return new WildcardFilter(pattern);
        }
    }

    public Class getSubscriptionFilter() {
        return this.subscriptionFilter;
    }

    public void setSubscriptionFilter(Class subscriptionFilter) {
        this.subscriptionFilter = subscriptionFilter;
    }

    public Map getEndpointMappings() {
        return this.endpointMappings;
    }

    public void setEndpointMappings(Map endpointMappings) {
        this.endpointMappings = endpointMappings;
    }

    public String[] getSubscriptions() {
        return this.subscriptions;
    }

    public void setSubscriptions(String[] subscriptions) {
        this.subscriptions = subscriptions;
    }

    protected void setExceptionListener(ExceptionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("exceptionListener may not be null");
        }
        this.exceptionListener = listener;
    }

    private class LoggingExceptionListener
    implements ExceptionListener {
        private LoggingExceptionListener() {
        }

        public void exceptionThrown(Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

