/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.spring.config;

import java.io.IOException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.xml.DefaultBeanDefinitionDocumentReader;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.SystemPropertyUtils;
import org.w3c.dom.Element;

public class MuleBeanDefinitionDocumentReader
extends DefaultBeanDefinitionDocumentReader {
    protected void importBeanDefinitionResource(Element ele) {
        String location;
        block13: {
            location = ele.getAttribute("resource");
            if (!StringUtils.hasText((String)location)) {
                this.getReaderContext().error("Resource location must not be empty", (Object)ele);
                return;
            }
            if (ResourcePatternUtils.isUrl((String)(location = SystemPropertyUtils.resolvePlaceholders((String)location)))) {
                try {
                    int importCount = this.getReaderContext().getReader().loadBeanDefinitions(location);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Imported " + importCount + " bean definitions from URL location [" + location + "]"));
                    }
                }
                catch (BeanDefinitionStoreException ex) {
                    this.getReaderContext().error("Failed to import bean definitions from URL location [" + location + "]", (Object)ele, (Throwable)ex);
                }
            } else {
                try {
                    Resource relativeResource = this.getReaderContext().getResource().createRelative(location);
                    int importCount = this.getReaderContext().getReader().loadBeanDefinitions(relativeResource);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Imported " + importCount + " bean definitions from relative location [" + location + "]"));
                    }
                }
                catch (IOException ex) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Invalid relative resource location [" + location + "] to import bean definitions from, will try loading from classpath"));
                    }
                    ClassPathResource classpathResource = new ClassPathResource(location);
                    int importCount = this.getReaderContext().getReader().loadBeanDefinitions((Resource)classpathResource);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Imported " + importCount + " bean definitions from classpath resource [" + location + "]"));
                    }
                }
                catch (BeanDefinitionStoreException ex) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Failed to import bean definitions from relative location [" + location + "], will try loading from classpath"));
                    }
                    ClassPathResource classpathResource = new ClassPathResource(location);
                    int importCount = this.getReaderContext().getReader().loadBeanDefinitions((Resource)classpathResource);
                    if (!this.logger.isDebugEnabled()) break block13;
                    this.logger.debug((Object)("Imported " + importCount + " bean definitions from classpath resource [" + location + "]"));
                }
            }
        }
        this.getReaderContext().fireImportProcessed(location, this.extractSource(ele));
    }
}

