/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.dsl.model;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.app.declaration.ArtifactDeclaration;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.config.spring.dsl.model.ComponentBuildingDefinitionRegistry;
import org.mule.runtime.config.spring.dsl.model.ComponentModel;
import org.mule.runtime.config.spring.dsl.model.ComponentModelReader;
import org.mule.runtime.config.spring.dsl.model.DslElementModel;
import org.mule.runtime.config.spring.dsl.model.DslElementModelFactory;
import org.mule.runtime.config.spring.dsl.model.extension.xml.MacroExpansionModuleModel;
import org.mule.runtime.config.spring.dsl.processor.ArtifactConfig;
import org.mule.runtime.config.spring.dsl.processor.ConfigFile;
import org.mule.runtime.config.spring.dsl.processor.ObjectTypeVisitor;
import org.mule.runtime.config.spring.dsl.processor.xml.XmlCustomAttributeHandler;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinitionProvider;
import org.mule.runtime.dsl.api.component.TypeDefinitionVisitor;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;
import org.mule.runtime.dsl.api.component.config.ComponentIdentifier;
import org.mule.runtime.extension.api.util.NameUtils;
import org.springframework.util.PropertyPlaceholderHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ApplicationModel {
    public static final String MULE_ROOT_ELEMENT = "mule";
    public static final String MULE_DOMAIN_ROOT_ELEMENT = "mule-domain";
    public static final String POLICY_ROOT_ELEMENT = "policy";
    public static final String ANNOTATIONS = "annotations";
    public static final String ERROR_HANDLER = "error-handler";
    public static final String ERROR_MAPPING = "error-mapping";
    public static final String DEFAULT_EXCEPTION_STRATEGY = "default-exception-strategy";
    public static final String MAX_REDELIVERY_ATTEMPTS_ROLLBACK_ES_ATTRIBUTE = "maxRedeliveryAttempts";
    public static final String WHEN_CHOICE_ES_ATTRIBUTE = "when";
    public static final String TYPE_ES_ATTRIBUTE = "type";
    public static final String EXCEPTION_STRATEGY_REFERENCE_ELEMENT = "exception-strategy";
    public static final String SPRING_NAMESPACE = "spring";
    public static final String SPRING_CONTEXT_NAMESPACE = "context";
    public static final String PROPERTY_ELEMENT = "property";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String REFERENCE_ATTRIBUTE = "ref";
    public static final String VALUE_ATTRIBUTE = "value";
    public static final String PROCESSOR_REFERENCE_ELEMENT = "processor";
    public static final String TRANSFORMER_REFERENCE_ELEMENT = "transformer";
    public static final String FILTER_REFERENCE_ELEMENT = "filter";
    public static final String MESSAGE_FILTER_ELEMENT = "message-filter";
    public static final String ANNOTATION_ELEMENT = "annotations";
    public static final String FILTER_ELEMENT_SUFFIX = "-filter";
    public static final String PROCESSING_STRATEGY_ATTRIBUTE = "processingStrategy";
    public static final String PROCESSING_STRATEGY_FACTORY_ATTRIBUTE = "processingStrategyFactory";
    public static final String QUEUE_STORE = "queue-store";
    public static final String CONFIGURATION_ELEMENT = "configuration";
    public static final String DATA_WEAVE = "weave";
    public static final String CUSTOM_TRANSFORMER = "custom-transformer";
    public static final String DESCRIPTION_ELEMENT = "description";
    public static final String PROPERTIES_ELEMENT = "properties";
    public static final String FLOW_ELEMENT = "flow";
    public static final String REDELIVERY_POLICY_ELEMENT = "redelivery-policy";
    public static final String TEST_NAMESPACE = "test";
    public static final String DOC_NAMESPACE = "doc";
    public static final String SPRING_SECURITY_NAMESPACE = "ss";
    public static final String MULE_SECURITY_NAMESPACE = "mule-ss";
    public static final String MULE_XML_NAMESPACE = "mulexml";
    public static final String PGP_NAMESPACE = "pgp";
    public static final String XSL_NAMESPACE = "xsl";
    public static final String TRANSPORT_NAMESPACE = "transports";
    public static final String JMS_NAMESPACE = "jms";
    public static final String VM_NAMESPACE = "vm";
    public static final String HTTP_NAMESPACE = "http";
    public static final String BATCH_NAMESPACE = "batch";
    public static final String PARSER_TEST_NAMESPACE = "parsers-test";
    public static final String PROPERTY_PLACEHOLDER_ELEMENT = "property-placeholder";
    public static final String GLOBAL_PROPERTY = "global-property";
    public static final String SPRING_ENTRY_ELEMENT = "entry";
    public static final String SPRING_LIST_ELEMENT = "list";
    public static final String SPRING_MAP_ELEMENT = "map";
    public static final String SPRING_VALUE_ELEMENT = "value";
    public static final String PROTOTYPE_OBJECT_ELEMENT = "prototype-object";
    public static final String SINGLETON_OBJECT_ELEMENT = "singleton-object";
    public static final String INTERCEPTOR_STACK_ELEMENT = "interceptor-stack";
    public static final ComponentIdentifier ERROR_HANDLER_IDENTIFIER = new ComponentIdentifier.Builder().withNamespace("mule").withName("error-handler").build();
    public static final ComponentIdentifier EXCEPTION_STRATEGY_REFERENCE_IDENTIFIER = new ComponentIdentifier.Builder().withNamespace("mule").withName("exception-strategy").build();
    public static final ComponentIdentifier ERROR_MAPPING_IDENTIFIER = new ComponentIdentifier.Builder().withNamespace("mule").withName("error-mapping").build();
    public static final ComponentIdentifier MULE_IDENTIFIER = new ComponentIdentifier.Builder().withNamespace("mule").withName("mule").build();
    public static final ComponentIdentifier MULE_DOMAIN_IDENTIFIER = new ComponentIdentifier.Builder().withNamespace("mule").withName("mule-domain").build();
    public static final ComponentIdentifier POLICY_IDENTIFIER = new ComponentIdentifier.Builder().withNamespace("policy").withName("policy").build();
    public static final ComponentIdentifier SPRING_PROPERTY_IDENTIFIER = new ComponentIdentifier.Builder().withNamespace("spring").withName("property").build();
    public static final ComponentIdentifier MULE_PROPERTY_IDENTIFIER = new ComponentIdentifier.Builder().withNamespace("mule").withName("property").build();
    public static final ComponentIdentifier MULE_PROPERTIES_IDENTIFIER = new ComponentIdentifier.Builder().withNamespace("mule").withName("properties").build();
    public static final ComponentIdentifier ANNOTATIONS_ELEMENT_IDENTIFIER = new ComponentIdentifier.Builder().withNamespace("mule").withName("annotations").build();
    public static final ComponentIdentifier MESSAGE_FILTER_ELEMENT_IDENTIFIER = new ComponentIdentifier.Builder().withNamespace("mule").withName("message-filter").build();
    public static final ComponentIdentifier DEFAULT_ES_ELEMENT_IDENTIFIER = new ComponentIdentifier.Builder().withNamespace("mule").withName("default-exception-strategy").build();
    public static final ComponentIdentifier PROCESSOR_IDENTIFIER = new ComponentIdentifier.Builder().withNamespace("mule").withName("processor").build();
    public static final ComponentIdentifier TRANSFORMER_IDENTIFIER = new ComponentIdentifier.Builder().withNamespace("mule").withName("transformer").build();
    public static final ComponentIdentifier QUEUE_STORE_IDENTIFIER = new ComponentIdentifier.Builder().withNamespace("mule").withName("queue-store").build();
    public static final ComponentIdentifier CONFIGURATION_IDENTIFIER = new ComponentIdentifier.Builder().withNamespace("mule").withName("configuration").build();
    public static final ComponentIdentifier CUSTOM_TRANSFORMER_IDENTIFIER = new ComponentIdentifier.Builder().withNamespace("mule").withName("custom-transformer").build();
    public static final ComponentIdentifier SPRING_PROPERTY_PLACEHOLDER_IDENTIFIER = new ComponentIdentifier.Builder().withNamespace("context").withName("property-placeholder").build();
    public static final ComponentIdentifier DOC_DESCRIPTION_IDENTIFIER = new ComponentIdentifier.Builder().withNamespace("doc").withName("description").build();
    public static final ComponentIdentifier DESCRIPTION_IDENTIFIER = new ComponentIdentifier.Builder().withNamespace("mule").withName("description").build();
    public static final ComponentIdentifier ANNOTATIONS_IDENTIFIER = new ComponentIdentifier.Builder().withNamespace("mule").withName("annotations").build();
    public static final ComponentIdentifier SPRING_ENTRY_IDENTIFIER = new ComponentIdentifier.Builder().withNamespace("spring").withName("entry").build();
    public static final ComponentIdentifier SPRING_LIST_IDENTIFIER = new ComponentIdentifier.Builder().withNamespace("spring").withName("list").build();
    public static final ComponentIdentifier SPRING_MAP_IDENTIFIER = new ComponentIdentifier.Builder().withNamespace("spring").withName("map").build();
    public static final ComponentIdentifier SPRING_VALUE_IDENTIFIER = new ComponentIdentifier.Builder().withNamespace("spring").withName("value").build();
    public static final ComponentIdentifier PROTOTYPE_OBJECT_IDENTIFIER = new ComponentIdentifier.Builder().withNamespace("mule").withName("prototype-object").build();
    public static final ComponentIdentifier SINGLETON_OBJECT_IDENTIFIER = new ComponentIdentifier.Builder().withNamespace("mule").withName("singleton-object").build();
    public static final ComponentIdentifier INTERCEPTOR_STACK_IDENTIFIER = new ComponentIdentifier.Builder().withNamespace("mule").withName("interceptor-stack").build();
    public static final ComponentIdentifier FLOW_IDENTIFIER = new ComponentIdentifier.Builder().withNamespace("mule").withName("flow").build();
    public static final ComponentIdentifier REDELIVERY_POLICY_IDENTIFIER = new ComponentIdentifier.Builder().withNamespace("mule").withName("redelivery-policy").build();
    private static ImmutableSet<ComponentIdentifier> ignoredNameValidationComponentList = ImmutableSet.builder().add((Object)new ComponentIdentifier.Builder().withNamespace("mule").withName("flow-ref").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("mule").withName("alias").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("mule").withName("in-memory-store").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("mule").withName("password-encryption-strategy").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("mule").withName("custom-security-provider").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("mule").withName("custom-encryption-strategy").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("mule").withName("secret-key-encryption-strategy").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("mule").withName("import").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("mule").withName("string-to-byte-array-transformer").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("mule").withName("append-string-transformer").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("mule").withName("security-manager").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("test").withName("queue").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("test").withName("invocation-counter").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("spring").withName("property").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("spring").withName("bean").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("ss").withName("user").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("mule-ss").withName("delegate-security-provider").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("mule-ss").withName("security-manager").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("mulexml").withName("xslt-transformer").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("mulexml").withName("alias").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("pgp").withName("security-provider").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("pgp").withName("keybased-encryption-strategy").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("xsl").withName("param").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("xsl").withName("attribute").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("xsl").withName("element").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("transports").withName("inbound-endpoint").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("transports").withName("outbound-endpoint").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("jms").withName("inbound-endpoint").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("vm").withName("inbound-endpoint").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("http").withName("inbound-endpoint").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("http").withName("set-cookie").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("http").withName("header").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("http").withName("http-response-to-object-transformer").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("http").withName("http-response-to-string-transformer").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("http").withName("message-to-http-response-transformer").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("http").withName("object-to-http-request-transformer").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("batch").withName("step").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("batch").withName("execute").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("parsers-test").withName("child").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("parsers-test").withName("kid").build()).add((Object)new ComponentIdentifier.Builder().withNamespace("weave").withName("reader-property").build()).build();
    private final Optional<ComponentBuildingDefinitionRegistry> componentBuildingDefinitionRegistry;
    private List<ComponentModel> muleComponentModels = new LinkedList<ComponentModel>();
    private List<ComponentModel> springComponentModels = new LinkedList<ComponentModel>();
    private PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("${", "}");
    private Properties applicationProperties;

    public ApplicationModel(ArtifactConfig artifactConfig, ArtifactDeclaration artifactDeclaration) throws Exception {
        this(artifactConfig, artifactDeclaration, Optional.empty(), Optional.empty());
    }

    public ApplicationModel(ArtifactConfig artifactConfig, ArtifactDeclaration artifactDeclaration, Optional<ExtensionManager> extensionManager, Optional<ComponentBuildingDefinitionRegistry> componentBuildingDefinitionRegistry) throws Exception {
        this.componentBuildingDefinitionRegistry = componentBuildingDefinitionRegistry;
        this.configurePropertyPlaceholderResolver(artifactConfig);
        this.convertConfigFileToComponentModel(artifactConfig);
        this.convertArtifactConfigurationToComponentModel(extensionManager, artifactDeclaration);
        this.validateModel(componentBuildingDefinitionRegistry);
        this.createEffectiveModel();
        this.expandModules(extensionManager);
    }

    public void resolveComponentTypes() {
        Preconditions.checkState((boolean)this.componentBuildingDefinitionRegistry.isPresent(), (String)("ApplicationModel was created without a " + ComponentBuildingDefinitionProvider.class.getName()));
        this.executeOnEveryComponentTree(componentModel -> {
            Optional<ComponentBuildingDefinition> buildingDefinition = this.componentBuildingDefinitionRegistry.get().getBuildingDefinition(componentModel.getIdentifier());
            buildingDefinition.ifPresent(definition -> {
                ObjectTypeVisitor typeDefinitionVisitor = new ObjectTypeVisitor((ComponentModel)componentModel);
                definition.getTypeDefinition().visit((TypeDefinitionVisitor)typeDefinitionVisitor);
                componentModel.setType(typeDefinitionVisitor.getType());
            });
        });
    }

    private void createEffectiveModel() {
        this.processSourcesRedeliveryPolicy();
    }

    private void processSourcesRedeliveryPolicy() {
        this.executeOnEveryFlow(flowComponentModel -> {
            if (!flowComponentModel.getInnerComponents().isEmpty()) {
                ComponentModel possibleSourceComponent = flowComponentModel.getInnerComponents().get(0);
                possibleSourceComponent.getInnerComponents().stream().filter(childComponent -> childComponent.getIdentifier().equals((Object)REDELIVERY_POLICY_IDENTIFIER)).findAny().ifPresent(redeliveryPolicyComponentModel -> {
                    possibleSourceComponent.getInnerComponents().remove(redeliveryPolicyComponentModel);
                    flowComponentModel.getInnerComponents().add(1, (ComponentModel)redeliveryPolicyComponentModel);
                });
            }
        });
    }

    private void convertArtifactConfigurationToComponentModel(Optional<ExtensionManager> extensionManager, ArtifactDeclaration artifactDeclaration) {
        if (artifactDeclaration != null && extensionManager.isPresent()) {
            DslElementModelFactory elementFactory = DslElementModelFactory.getDefault(DslResolvingContext.getDefault((Set)extensionManager.get().getExtensions()));
            artifactDeclaration.getConfigs().stream().map(elementFactory::create).filter(Optional::isPresent).map(e -> ((DslElementModel)e.get()).getConfiguration()).forEach(config -> config.ifPresent(c -> this.muleComponentModels.add(this.convertComponentConfiguration((ComponentConfiguration)c, true))));
        }
    }

    private ComponentModel convertComponentConfiguration(ComponentConfiguration componentConfiguration, boolean isRoot) {
        ComponentModel.Builder builder = new ComponentModel.Builder().setIdentifier(ComponentIdentifier.builder().withName(componentConfiguration.getIdentifier().getName()).withNamespace(this.getPrefix(componentConfiguration)).build());
        if (isRoot) {
            builder.markAsRootComponent();
        }
        for (Map.Entry parameter : componentConfiguration.getParameters().entrySet()) {
            builder.addParameter((String)parameter.getKey(), (String)parameter.getValue(), false);
        }
        for (ComponentConfiguration childComponentConfiguration : componentConfiguration.getNestedComponents()) {
            builder.addChildComponentModel(this.convertComponentConfiguration(childComponentConfiguration, false));
        }
        componentConfiguration.getValue().ifPresent(builder::setTextContent);
        return builder.build();
    }

    private String getPrefix(ComponentConfiguration componentConfiguration) {
        String namespaceUri = componentConfiguration.getIdentifier().getNamespace();
        return namespaceUri.substring(namespaceUri.lastIndexOf("/") + 1);
    }

    private void configurePropertyPlaceholderResolver(ArtifactConfig artifactConfig) {
        ArrayList locations = new ArrayList();
        HashMap globalProperties = new HashMap();
        artifactConfig.getConfigFiles().stream().forEach(configFile -> configFile.getConfigLines().get(0).getChildren().stream().forEach(configLine -> {
            if (GLOBAL_PROPERTY.equals(configLine.getIdentifier())) {
                globalProperties.put(configLine.getConfigAttributes().get(NAME_ATTRIBUTE).getValue(), configLine.getConfigAttributes().get("value").getValue());
            } else if (PROPERTY_PLACEHOLDER_ELEMENT.equals(configLine.getIdentifier())) {
                String locationValue = configLine.getConfigAttributes().get("location").getValue();
                locationValue = this.propertyPlaceholderHelper.replacePlaceholders(locationValue, System.getProperties());
                locationValue = locationValue.replace("classpath:/", "");
                locations.add(locationValue);
            }
        }));
        this.applicationProperties = new Properties();
        this.applicationProperties.putAll(System.getenv());
        this.applicationProperties.putAll((Map<?, ?>)System.getProperties());
        if (artifactConfig.getApplicationProperties() != null) {
            this.applicationProperties.putAll(artifactConfig.getApplicationProperties());
        }
        this.applicationProperties.putAll((Map<?, ?>)globalProperties);
        for (String propertyFileLocation : locations) {
            Properties properties = new Properties();
            try {
                InputStream propertiesFileInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(propertyFileLocation);
                Throwable throwable = null;
                try {
                    properties.load(propertiesFileInputStream);
                    this.applicationProperties.putAll((Map<?, ?>)properties);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (propertiesFileInputStream == null) continue;
                    if (throwable != null) {
                        try {
                            propertiesFileInputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    propertiesFileInputStream.close();
                }
            }
            catch (IOException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
    }

    public ComponentModel findComponentDefinitionModel(Element element) {
        return this.innerFindComponentDefinitionModel(element, this.muleComponentModels);
    }

    public Optional<ComponentModel> findComponentDefinitionModel(ComponentIdentifier componentIdentifier) {
        if (this.muleComponentModels.isEmpty()) {
            return Optional.empty();
        }
        return this.muleComponentModels.get(0).getInnerComponents().stream().filter(ComponentModel::isRoot).filter(componentModel -> componentModel.getIdentifier().equals((Object)componentIdentifier)).findFirst();
    }

    private void convertConfigFileToComponentModel(ArtifactConfig artifactConfig) {
        List<ConfigFile> configFiles = artifactConfig.getConfigFiles();
        ComponentModelReader componentModelReader = new ComponentModelReader(this.applicationProperties);
        configFiles.stream().forEach(configFile -> {
            ComponentModel componentModel = componentModelReader.extractComponentDefinitionModel(configFile.getConfigLines().get(0), configFile.getFilename());
            if (this.isMuleConfigFile((ConfigFile)configFile)) {
                this.muleComponentModels.add(componentModel);
            } else {
                this.springComponentModels.add(componentModel);
            }
        });
    }

    private boolean isMuleConfigFile(ConfigFile configFile) {
        if (configFile.getConfigLines().isEmpty()) {
            return false;
        }
        return !this.isSpringFile(configFile);
    }

    private boolean isSpringFile(ConfigFile configFile) {
        return SPRING_NAMESPACE.equals(configFile.getConfigLines().get(0).getNamespace());
    }

    public boolean hasSpringConfig() {
        return !this.springComponentModels.isEmpty();
    }

    private void validateModel(Optional<ComponentBuildingDefinitionRegistry> componentBuildingDefinitionRegistry) throws ConfigurationException {
        if (this.muleComponentModels.isEmpty() || !this.isMuleConfigurationFile()) {
            return;
        }
        this.validateNameIsNotRepeated();
        this.validateNameIsOnlyOnTopLevelElements();
        this.validateErrorMappings();
        this.validateExceptionStrategyWhenAttributeIsOnlyPresentInsideChoice();
        this.validateChoiceExceptionStrategyStructure();
        this.validateNoDefaultExceptionStrategyAsGlobal();
        this.validateParameterAndChildForSameAttributeAreNotDefinedTogether();
        if (componentBuildingDefinitionRegistry.isPresent()) {
            this.validateNamedTopLevelElementsHaveName(componentBuildingDefinitionRegistry.get());
        }
    }

    private void validateParameterAndChildForSameAttributeAreNotDefinedTogether() {
        this.executeOnEveryMuleComponentTree(componentModel -> {
            for (String parameterName : componentModel.getParameters().keySet()) {
                if (componentModel.isParameterValueProvidedBySchema(parameterName)) continue;
                String mapChildName = NameUtils.hyphenize((String)NameUtils.pluralize((String)parameterName));
                String listOrPojoChildName = NameUtils.hyphenize((String)parameterName);
                Optional<ComponentModel> childOptional = this.findRelatedChildForParameter(componentModel.getInnerComponents(), mapChildName, listOrPojoChildName);
                if (!childOptional.isPresent() || childOptional.get().getIdentifier().equals((Object)SPRING_PROPERTY_IDENTIFIER)) continue;
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Component %s has a child element %s which is used for the same purpose of the configuration parameter %s. Only one must be used.", componentModel.getIdentifier(), childOptional.get().getIdentifier(), parameterName)));
            }
        });
    }

    private Optional<ComponentModel> findRelatedChildForParameter(List<ComponentModel> chilrenComponents, String ... possibleNames) {
        HashSet<String> possibleNamesSet = new HashSet<String>(Arrays.asList(possibleNames));
        for (ComponentModel childrenComponent : chilrenComponents) {
            if (!possibleNamesSet.contains(childrenComponent.getIdentifier().getName())) continue;
            return Optional.of(childrenComponent);
        }
        return Optional.empty();
    }

    private void validateNoDefaultExceptionStrategyAsGlobal() {
        this.executeOnEveryMuleComponentTree(componentModel -> {
            if (componentModel.isRoot() && DEFAULT_ES_ELEMENT_IDENTIFIER.equals((Object)componentModel.getIdentifier()) && componentModel.getNameAttribute() != null) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Component %s is not supported as global", DEFAULT_ES_ELEMENT_IDENTIFIER.getName())));
            }
        });
    }

    private void validateNameIsNotRepeated() {
        HashMap existingObjectsWithName = new HashMap();
        this.executeOnEveryMuleComponentTree(componentModel -> {
            String nameAttributeValue = componentModel.getNameAttribute();
            if (nameAttributeValue != null && !ignoredNameValidationComponentList.contains((Object)componentModel.getIdentifier())) {
                if (existingObjectsWithName.containsKey(nameAttributeValue)) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Two configuration elements have been defined with the same global name. Global name [%s] must be unique. Clashing components are %s and %s", (Object[])new Object[]{nameAttributeValue, ((ComponentModel)existingObjectsWithName.get(nameAttributeValue)).getIdentifier(), componentModel.getIdentifier()}));
                }
                existingObjectsWithName.put(nameAttributeValue, componentModel);
            }
        });
    }

    private boolean isMuleConfigurationFile() {
        return this.muleComponentModels.get(0).getIdentifier().equals((Object)MULE_IDENTIFIER);
    }

    private void validateErrorMappings() {
        this.executeOnEveryComponentTree(componentModel -> {
            List errorMappings = componentModel.getInnerComponents().stream().filter(c -> c.getIdentifier().equals((Object)ERROR_MAPPING_IDENTIFIER)).collect(Collectors.toList());
            if (!errorMappings.isEmpty()) {
                List anyMappings = errorMappings.stream().filter(this::isErrorMappingWithSourceAny).collect(Collectors.toList());
                if (anyMappings.size() > 1) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Only one mapping for ANY or an empty source type is allowed."));
                }
                if (anyMappings.size() == 1 && !this.isErrorMappingWithSourceAny((ComponentModel)errorMappings.get(errorMappings.size() - 1))) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Only the last error mapping can have ANY or an empty source type."));
                }
                List sources = errorMappings.stream().map(model -> model.getParameters().get("sourceType")).collect(Collectors.toList());
                List distinctSources = sources.stream().distinct().collect(Collectors.toList());
                if (sources.size() != distinctSources.size()) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Repeated source types are not allowed. Offending types are %s.", Joiner.on((String)", ").join((Iterable)CollectionUtils.disjunction(sources, distinctSources)))));
                }
            }
        });
    }

    private boolean isErrorMappingWithSourceAny(ComponentModel model) {
        String sourceType = model.getParameters().get("sourceType");
        return sourceType == null || sourceType.equals("ANY");
    }

    private void validateChoiceExceptionStrategyStructure() {
        this.executeOnEveryMuleComponentTree(component -> {
            if (component.getIdentifier().equals((Object)ERROR_HANDLER_IDENTIFIER)) {
                this.validateExceptionStrategiesHaveWhenAttribute((ComponentModel)component);
                this.validateNoMoreThanOneRollbackExceptionStrategyWithRedelivery((ComponentModel)component);
            }
        });
    }

    private void validateNoMoreThanOneRollbackExceptionStrategyWithRedelivery(ComponentModel component) {
        if (component.getInnerComponents().stream().filter(exceptionStrategyComponent -> exceptionStrategyComponent.getParameters().get(MAX_REDELIVERY_ATTEMPTS_ROLLBACK_ES_ATTRIBUTE) != null).count() > 1L) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Only one on-error-propagate within a error-handler can handle message redelivery. Remove one of the maxRedeliveryAttempts attributes"));
        }
    }

    private void validateExceptionStrategiesHaveWhenAttribute(ComponentModel component) {
        List<ComponentModel> innerComponents = component.getInnerComponents();
        for (int i = 0; i < innerComponents.size() - 1; ++i) {
            Map<String, String> parameters = innerComponents.get(i).getParameters();
            if (parameters.get(WHEN_CHOICE_ES_ATTRIBUTE) != null || parameters.get(TYPE_ES_ATTRIBUTE) != null) continue;
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Every handler (except for the last one) within an error-handler must specify the when or type attribute"));
        }
    }

    private void validateExceptionStrategyWhenAttributeIsOnlyPresentInsideChoice() {
        this.executeOnEveryMuleComponentTree(component -> {
            if (component.getIdentifier().getName().endsWith(EXCEPTION_STRATEGY_REFERENCE_ELEMENT)) {
                Node componentNode = XmlCustomAttributeHandler.from(component).getNode();
                if (component.getParameters().get(WHEN_CHOICE_ES_ATTRIBUTE) != null && !componentNode.getParentNode().getLocalName().equals(ERROR_HANDLER) && !componentNode.getParentNode().getLocalName().equals(MULE_ROOT_ELEMENT)) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Only handlers within an error-handler can have when attribute specified"));
                }
            }
        });
    }

    private void validateNameIsOnlyOnTopLevelElements() throws ConfigurationException {
        try {
            List<ComponentModel> topLevelComponents = this.muleComponentModels.get(0).getInnerComponents();
            topLevelComponents.stream().filter(this::isMuleComponent).forEach(topLevelComponent -> topLevelComponent.getInnerComponents().stream().filter(this::isMuleComponent).forEach(topLevelComponentChild -> this.executeOnComponentTree((ComponentModel)topLevelComponentChild, component -> {
                if (component.getNameAttribute() != null && !ignoredNameValidationComponentList.contains((Object)component.getIdentifier())) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Only top level elements can have a name attribute. Component %s has attribute name with value %s", (Object[])new Object[]{component.getIdentifier(), component.getNameAttribute()}));
                }
            }, true)));
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    private void validateNamedTopLevelElementsHaveName(ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry) throws ConfigurationException {
        try {
            List<ComponentModel> topLevelComponents = this.muleComponentModels.get(0).getInnerComponents();
            topLevelComponents.stream().filter(this::isMuleComponent).forEach(topLevelComponent -> {
                ComponentIdentifier identifier = topLevelComponent.getIdentifier();
                componentBuildingDefinitionRegistry.getBuildingDefinition(identifier).filter(ComponentBuildingDefinition::isNamed).ifPresent(buildingDefinition -> {
                    if (StringUtils.isBlank((CharSequence)topLevelComponent.getNameAttribute())) {
                        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Global element %s:%s does not provide a name attribute.", identifier.getNamespace(), identifier.getName())));
                    }
                });
            });
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    private boolean isMuleComponent(ComponentModel componentModel) {
        return !componentModel.getIdentifier().getNamespace().equals(SPRING_NAMESPACE);
    }

    public void executeOnEveryComponentTree(Consumer<ComponentModel> task) {
        for (ComponentModel componentModel : this.muleComponentModels) {
            this.executeOnComponentTree(componentModel, task, false);
        }
    }

    public void executeOnEveryMuleComponentTree(Consumer<ComponentModel> task) {
        for (ComponentModel componentModel : this.muleComponentModels) {
            this.executeOnComponentTree(componentModel, task, true);
        }
    }

    private void executeOnEveryFlow(Consumer<ComponentModel> task) {
        for (ComponentModel muleComponentModel : this.muleComponentModels) {
            for (ComponentModel componentModel : muleComponentModel.getInnerComponents()) {
                if (!FLOW_IDENTIFIER.equals((Object)componentModel.getIdentifier())) continue;
                task.accept(componentModel);
            }
        }
    }

    private void executeOnComponentTree(ComponentModel component, Consumer<ComponentModel> task, boolean avoidSpringElements) throws MuleRuntimeException {
        if (component.getIdentifier().getNamespace().equals(SPRING_NAMESPACE) && avoidSpringElements) {
            return;
        }
        component.getInnerComponents().forEach(innerComponent -> this.executeOnComponentTree((ComponentModel)innerComponent, task, avoidSpringElements));
        task.accept(component);
    }

    private ComponentModel innerFindComponentDefinitionModel(Element element, List<ComponentModel> componentModels) {
        for (ComponentModel componentModel : componentModels) {
            if (XmlCustomAttributeHandler.from(componentModel).getNode().equals(element)) {
                return componentModel;
            }
            ComponentModel childComponentModel = this.innerFindComponentDefinitionModel(element, componentModel.getInnerComponents());
            if (childComponentModel == null) continue;
            return childComponentModel;
        }
        return null;
    }

    public ComponentModel getRootComponentModel() {
        return this.muleComponentModels.get(0);
    }

    public Optional<ComponentModel> findNamedComponent(String name) {
        ComponentModel muleComponentModel;
        Optional<ComponentModel> requestedComponentModelOptional = Optional.empty();
        Iterator<ComponentModel> iterator = this.muleComponentModels.iterator();
        while (iterator.hasNext() && !(requestedComponentModelOptional = (muleComponentModel = iterator.next()).getInnerComponents().stream().filter(componentModel -> name.equals(componentModel.getNameAttribute())).findAny()).isPresent()) {
        }
        return requestedComponentModelOptional;
    }

    public Optional<ComponentConfiguration> findNamedElement(String name) {
        ComponentModel muleComponentModel;
        Optional<ComponentConfiguration> requestedElement = Optional.empty();
        Iterator<ComponentModel> iterator = this.muleComponentModels.iterator();
        while (iterator.hasNext() && !(requestedElement = (muleComponentModel = iterator.next()).getInnerComponents().stream().filter(componentModel -> name.equals(componentModel.getNameAttribute())).map(ComponentModel::getConfiguration).findAny()).isPresent()) {
        }
        return requestedElement;
    }

    private void expandModules(Optional<ExtensionManager> extensionManager) {
        extensionManager.ifPresent(manager -> new MacroExpansionModuleModel(this, manager.getExtensions()).expand());
    }
}

