/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.parsers.delegate;

import java.util.Map;
import org.mule.runtime.config.spring.parsers.MuleDefinitionParser;
import org.mule.runtime.config.spring.parsers.MuleDefinitionParserConfiguration;
import org.mule.runtime.config.spring.parsers.PostProcessor;
import org.mule.runtime.config.spring.parsers.PreProcessor;
import org.mule.runtime.config.spring.parsers.assembly.configuration.PropertyConfiguration;
import org.mule.runtime.config.spring.parsers.assembly.configuration.SimplePropertyConfiguration;
import org.mule.runtime.config.spring.parsers.assembly.configuration.ValueMap;
import org.mule.runtime.config.spring.parsers.collection.DynamicAttributeDefinitionParser;
import org.mule.runtime.config.spring.parsers.generic.AutoIdUtils;
import org.mule.runtime.config.spring.util.SpringXMLUtils;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class AllAttributeChildDefinitionParser
extends AbstractBeanDefinitionParser
implements MuleDefinitionParser {
    private DynamicAttributeDefinitionParser delegate;
    private PropertyConfiguration configuration = new SimplePropertyConfiguration();

    public AllAttributeChildDefinitionParser(DynamicAttributeDefinitionParser delegate) {
        this.addIgnored("id");
        this.addIgnored("name");
        this.delegate = delegate;
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = SpringXMLUtils.attributeName((Attr)((Attr)attributes.item(i)));
            if (this.isIgnored(name)) continue;
            this.delegate.setAttributeName(name);
            this.delegate.muleParse(element, parserContext);
        }
        return null;
    }

    @Override
    public AbstractBeanDefinition muleParse(Element element, ParserContext parserContext) {
        return this.parseInternal(element, parserContext);
    }

    @Override
    public MuleDefinitionParserConfiguration registerPreProcessor(PreProcessor preProcessor) {
        this.delegate.registerPreProcessor(preProcessor);
        return this;
    }

    @Override
    public MuleDefinitionParserConfiguration registerPostProcessor(PostProcessor postProcessor) {
        this.delegate.registerPostProcessor(postProcessor);
        return this;
    }

    @Override
    public MuleDefinitionParserConfiguration addReference(String propertyName) {
        this.configuration.addReference(propertyName);
        return this;
    }

    @Override
    public MuleDefinitionParserConfiguration addMapping(String propertyName, Map mappings) {
        this.configuration.addMapping(propertyName, mappings);
        return this;
    }

    @Override
    public MuleDefinitionParserConfiguration addMapping(String propertyName, String mappings) {
        this.configuration.addMapping(propertyName, mappings);
        return this;
    }

    @Override
    public MuleDefinitionParserConfiguration addMapping(String propertyName, ValueMap mappings) {
        this.configuration.addMapping(propertyName, mappings);
        return this;
    }

    @Override
    public MuleDefinitionParserConfiguration addAlias(String alias, String propertyName) {
        this.configuration.addAlias(alias, propertyName);
        return this;
    }

    @Override
    public MuleDefinitionParserConfiguration addCollection(String propertyName) {
        this.configuration.addCollection(propertyName);
        return this;
    }

    @Override
    public MuleDefinitionParserConfiguration addIgnored(String propertyName) {
        this.configuration.addIgnored(propertyName);
        return this;
    }

    @Override
    public MuleDefinitionParserConfiguration removeIgnored(String propertyName) {
        this.configuration.removeIgnored(propertyName);
        return this;
    }

    @Override
    public MuleDefinitionParserConfiguration setIgnoredDefault(boolean ignoreAll) {
        this.configuration.setIgnoredDefault(ignoreAll);
        return this;
    }

    public String getAttributeMapping(String alias) {
        return this.configuration.getAttributeMapping(alias);
    }

    public boolean isCollection(String propertyName) {
        return this.configuration.isCollection(propertyName);
    }

    public boolean isIgnored(String propertyName) {
        return this.configuration.isIgnored(propertyName);
    }

    public boolean isBeanReference(String attributeName) {
        return this.configuration.isReference(attributeName);
    }

    public String translateName(String oldName) {
        return this.configuration.translateName(oldName);
    }

    public Object translateValue(String name, String value) {
        return this.configuration.translateValue(name, value);
    }

    @Override
    public String getBeanName(Element element) {
        return AutoIdUtils.getUniqueName(element, "all-attribute");
    }

    @Override
    public MuleDefinitionParserConfiguration addBeanFlag(String flag) {
        this.delegate.addBeanFlag(flag);
        return this;
    }
}

