/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.parsers.delegate;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.mule.runtime.config.spring.parsers.MuleDefinitionParser;
import org.mule.runtime.config.spring.parsers.MuleDefinitionParserConfiguration;
import org.mule.runtime.config.spring.parsers.PreProcessor;
import org.mule.runtime.config.spring.parsers.assembly.configuration.PropertyConfiguration;
import org.mule.runtime.config.spring.parsers.delegate.AbstractDelegatingDefinitionParser;
import org.mule.runtime.core.util.StringUtils;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class AbstractSerialDelegatingDefinitionParser
extends AbstractDelegatingDefinitionParser {
    private int index = 0;
    private boolean first;
    private boolean doReset;
    private String originalId;
    private String originalName;
    private Set handledExceptions = new HashSet();

    public AbstractSerialDelegatingDefinitionParser() {
        this(true);
    }

    public AbstractSerialDelegatingDefinitionParser(boolean doReset) {
        this.doReset = doReset;
    }

    @Override
    public AbstractBeanDefinition muleParse(Element element, ParserContext parserContext) {
        if (this.index == 0 || this.index >= this.size()) {
            this.first = true;
            this.index = 0;
        } else {
            this.first = false;
        }
        AbstractBeanDefinition bean = null;
        while (null == bean && this.index < this.size()) {
            try {
                MuleDefinitionParser parser = this.getDelegate(this.index);
                bean = this.doSingleBean(this.index++, parser, element, parserContext);
            }
            catch (RuntimeException e) {
                if (this.isExceptionHandled(e)) {
                    bean = null;
                    continue;
                }
                throw e;
            }
        }
        if (null != bean) {
            if (this.index == this.size()) {
                bean.removeAttribute("org.mule.runtime.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_REPEAT_PARSE");
            } else {
                bean.setAttribute("org.mule.runtime.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_REPEAT_PARSE", (Object)Boolean.TRUE);
            }
        }
        return bean;
    }

    protected boolean isExceptionHandled(Exception e) {
        return this.handledExceptions.contains(e.getClass());
    }

    protected AbstractBeanDefinition doSingleBean(int index, MuleDefinitionParser parser, Element element, ParserContext parserContext) {
        return parser.muleParse(element, parserContext);
    }

    @Override
    protected MuleDefinitionParserConfiguration addDelegate(MuleDefinitionParser delegate) {
        delegate.registerPreProcessor(new PreProcessor(){

            @Override
            public void preProcess(PropertyConfiguration config, Element element) {
                if (AbstractSerialDelegatingDefinitionParser.this.first) {
                    AbstractSerialDelegatingDefinitionParser.this.originalId = element.getAttribute("id");
                    AbstractSerialDelegatingDefinitionParser.this.originalName = element.getAttribute("name");
                } else if (AbstractSerialDelegatingDefinitionParser.this.doReset) {
                    AbstractSerialDelegatingDefinitionParser.this.resetNameAndId(element);
                }
            }
        });
        return super.addDelegate(delegate);
    }

    protected void resetNameAndId(Element element) {
        this.resetAttribute(element, "id", this.originalId);
        this.resetAttribute(element, "name", this.originalName);
    }

    protected void resetAttribute(Element element, String name, String value) {
        if (StringUtils.isEmpty((String)value)) {
            if (element.hasAttribute(name)) {
                element.removeAttribute(name);
            }
        } else {
            element.setAttribute(name, value);
        }
    }

    protected void addHandledException(Class exception) {
        this.handledExceptions.add(exception);
    }

    public static void enableAttributes(MuleDefinitionParser delegate, String[] attributes, boolean enable) {
        delegate.setIgnoredDefault(enable);
        for (String name : Arrays.asList(attributes)) {
            if (enable) {
                delegate.removeIgnored(name);
                continue;
            }
            delegate.addIgnored(name);
        }
    }

    public static void enableAttributes(MuleDefinitionParser delegate, String[][] attributes) {
        for (int i = 0; i < attributes.length; ++i) {
            AbstractSerialDelegatingDefinitionParser.enableAttributes(delegate, attributes[i], true);
        }
    }

    public static void enableAttributes(MuleDefinitionParser delegate, String[] attributes) {
        AbstractSerialDelegatingDefinitionParser.enableAttributes(delegate, attributes, true);
    }

    public static void enableAttribute(MuleDefinitionParser delegate, String attribute) {
        AbstractSerialDelegatingDefinitionParser.enableAttributes(delegate, new String[]{attribute}, true);
    }

    public static void disableAttributes(MuleDefinitionParser delegate, String[][] attributes) {
        for (int i = 0; i < attributes.length; ++i) {
            AbstractSerialDelegatingDefinitionParser.enableAttributes(delegate, attributes[i], false);
        }
    }

    public static void disableAttributes(MuleDefinitionParser delegate, String[] attributes) {
        AbstractSerialDelegatingDefinitionParser.enableAttributes(delegate, attributes, false);
    }

    public static void disableAttribute(MuleDefinitionParser delegate, String attribute) {
        AbstractSerialDelegatingDefinitionParser.enableAttributes(delegate, new String[]{attribute}, false);
    }
}

