/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.factories;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.core.AbstractAnnotatedObject;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.MessageProcessorContainer;
import org.mule.runtime.core.api.processor.MessageProcessorPathElement;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.processor.chain.AbstractMessageProcessorChain;
import org.mule.runtime.core.processor.chain.DynamicMessageProcessorContainer;
import org.mule.runtime.core.util.NotificationUtils;
import org.mule.runtime.dsl.api.component.config.ComponentIdentifier;
import org.reactivestreams.Publisher;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import reactor.core.publisher.Flux;

public class FlowRefFactoryBean
extends AbstractAnnotatedObject
implements FactoryBean<Processor>,
ApplicationContextAware,
MuleContextAware,
Initialisable,
Disposable {
    private static final String NULL_FLOW_CONTRUCT_NAME = "null";
    private static final String MULE_PREFIX = "_mule-";
    private String refName;
    private ApplicationContext applicationContext;
    private MuleContext muleContext;
    private Processor referencedMessageProcessor;
    private ConcurrentMap<String, Processor> referenceCache = new ConcurrentHashMap<String, Processor>();

    public void setName(String name) {
        this.refName = name;
    }

    public void initialise() throws InitialisationException {
        if (this.refName.isEmpty()) {
            throw new InitialisationException(CoreMessages.objectIsNull((String)"flow reference is empty"), (Initialisable)this);
        }
        if (!this.muleContext.getExpressionManager().isExpression(this.refName)) {
            this.referencedMessageProcessor = this.lookupReferencedFlowInApplicationContext(this.refName);
        }
    }

    public void dispose() {
        for (Processor processor : this.referenceCache.values()) {
            if (!(processor instanceof Disposable)) continue;
            ((Disposable)processor).dispose();
        }
        this.referenceCache = null;
    }

    public Processor getObject() throws Exception {
        final Processor processor = this.referencedMessageProcessor != null ? this.referencedMessageProcessor : this.createDynamicReferenceMessageProcessor(this.refName);
        return new AbstractMessageProcessorChain(Collections.singletonList(processor)){

            public void addMessageProcessorPathElements(MessageProcessorPathElement pathElement) {
                NotificationUtils.addMessageProcessorPathElements((Processor)processor, (MessageProcessorPathElement)pathElement.addChild(processor));
            }
        };
    }

    protected Processor createDynamicReferenceMessageProcessor(String name) throws MuleException {
        if (name == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull((String)name));
        }
        if (!this.referenceCache.containsKey(name)) {
            FlowRefMessageProcessorContainer dynamicReference = new FlowRefMessageProcessorContainer(){

                public Event process(Event event) throws MuleException {
                    Processor dynamicMessageProcessor = this.resolveReferencedProcessor(event);
                    return ((Processor)event1 -> dynamicMessageProcessor.process(event1)).process(event);
                }

                public Publisher<Event> apply(Publisher<Event> publisher) {
                    return Flux.from(publisher).flatMap(event -> {
                        try {
                            return Flux.just((Object)event).transform((Function)this.resolveReferencedProcessor((Event)event));
                        }
                        catch (MuleException e) {
                            return Flux.error((Throwable)e);
                        }
                    });
                }

                private Processor resolveReferencedProcessor(Event event) throws MuleException {
                    String flowName = FlowRefFactoryBean.this.muleContext.getExpressionManager().parse(FlowRefFactoryBean.this.refName, event, this.flowConstruct);
                    Processor dynamicMessageProcessor = FlowRefFactoryBean.this.getReferencedFlow(flowName, this.flowConstruct);
                    this.setResolvedMessageProcessor(dynamicMessageProcessor);
                    return dynamicMessageProcessor;
                }
            };
            if (dynamicReference instanceof Initialisable) {
                ((Initialisable)dynamicReference).initialise();
            }
            this.referenceCache.putIfAbsent(name, dynamicReference);
        }
        return (Processor)this.referenceCache.get(name);
    }

    protected Processor getReferencedFlow(String name, FlowConstruct flowConstruct) throws MuleException {
        if (name == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull((String)name));
        }
        String categorizedName = this.getReferencedFlowCategorizedName(name, flowConstruct);
        if (!this.referenceCache.containsKey(categorizedName)) {
            Processor referencedFlow = this.lookupReferencedFlowInApplicationContext(name);
            if (referencedFlow instanceof Initialisable) {
                if (referencedFlow instanceof FlowConstructAware) {
                    ((FlowConstructAware)referencedFlow).setFlowConstruct(flowConstruct);
                }
                if (referencedFlow instanceof MuleContextAware) {
                    ((MuleContextAware)referencedFlow).setMuleContext(this.muleContext);
                }
                if (referencedFlow instanceof MessageProcessorChain) {
                    for (Processor processor : ((MessageProcessorChain)referencedFlow).getMessageProcessors()) {
                        if (processor instanceof FlowConstructAware) {
                            ((FlowConstructAware)processor).setFlowConstruct(flowConstruct);
                        }
                        if (!(processor instanceof MuleContextAware)) continue;
                        ((MuleContextAware)processor).setMuleContext(this.muleContext);
                    }
                }
                ((Initialisable)referencedFlow).initialise();
            }
            if (referencedFlow instanceof Startable) {
                ((Startable)referencedFlow).start();
            }
            this.referenceCache.putIfAbsent(categorizedName, referencedFlow);
        }
        return (Processor)this.referenceCache.get(categorizedName);
    }

    private String getReferencedFlowCategorizedName(String referencedFlowName, FlowConstruct flowConstruct) {
        String flowConstructName = flowConstruct != null ? flowConstruct.getName() : NULL_FLOW_CONTRUCT_NAME;
        return MULE_PREFIX + flowConstructName + "-" + referencedFlowName;
    }

    protected Processor lookupReferencedFlowInApplicationContext(String name) {
        final Processor referencedFlow = (Processor)this.applicationContext.getBean(name);
        if (referencedFlow == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull((String)name));
        }
        if (referencedFlow instanceof FlowConstruct) {
            return new FlowRefMessageProcessor(){

                public void addMessageProcessorPathElements(MessageProcessorPathElement pathElement) {
                    NotificationUtils.addMessageProcessorPathElements((Processor)referencedFlow, (MessageProcessorPathElement)pathElement);
                }

                public Event process(Event event) throws MuleException {
                    return referencedFlow.process(event);
                }

                public Publisher<Event> apply(Publisher<Event> publisher) {
                    return Flux.from(publisher).transform((Function)referencedFlow);
                }
            };
        }
        if (referencedFlow instanceof AnnotatedObject) {
            ((AnnotatedObject)referencedFlow).setAnnotations(this.getAnnotations());
        }
        return referencedFlow;
    }

    public boolean isSingleton() {
        return false;
    }

    public Class<?> getObjectType() {
        return Processor.class;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    private abstract class FlowRefMessageProcessorContainer
    extends FlowRefMessageProcessor
    implements DynamicMessageProcessorContainer,
    FlowConstructAware {
        private MessageProcessorPathElement pathElement;
        private Processor dynamicMessageProcessor;

        private FlowRefMessageProcessorContainer() {
        }

        public void addMessageProcessorPathElements(MessageProcessorPathElement pathElement) {
            this.pathElement = pathElement;
        }

        public NotificationUtils.FlowMap buildInnerPaths() {
            if (this.dynamicMessageProcessor instanceof MessageProcessorContainer) {
                ((MessageProcessorContainer)this.dynamicMessageProcessor).addMessageProcessorPathElements(this.getPathElement());
                return NotificationUtils.buildPathResolver((MessageProcessorPathElement)this.getPathElement());
            }
            return null;
        }

        public MessageProcessorPathElement getPathElement() {
            return this.pathElement;
        }

        protected void setResolvedMessageProcessor(Processor dynamicMessageProcessor) {
            this.dynamicMessageProcessor = dynamicMessageProcessor;
        }
    }

    private abstract class FlowRefMessageProcessor
    implements Processor,
    AnnotatedObject,
    FlowConstructAware,
    MessageProcessorContainer {
        protected FlowConstruct flowConstruct;

        private FlowRefMessageProcessor() {
        }

        public Object getAnnotation(QName name) {
            return FlowRefFactoryBean.this.getAnnotation(name);
        }

        public Map<QName, Object> getAnnotations() {
            return FlowRefFactoryBean.this.getAnnotations();
        }

        public void setAnnotations(Map<QName, Object> annotations) {
            FlowRefFactoryBean.this.setAnnotations(annotations);
        }

        public void setFlowConstruct(FlowConstruct flowConstruct) {
            this.flowConstruct = flowConstruct;
        }

        public org.mule.runtime.api.component.ComponentIdentifier getIdentifier() {
            return new org.mule.runtime.api.component.ComponentIdentifier(){

                public String getNamespace() {
                    return ((ComponentIdentifier)FlowRefMessageProcessor.this.getAnnotation(ComponentIdentifier.ANNOTATION_NAME)).getNamespace();
                }

                public String getName() {
                    return ((ComponentIdentifier)FlowRefMessageProcessor.this.getAnnotation(ComponentIdentifier.ANNOTATION_NAME)).getName();
                }

                public ComponentIdentifier.ComponentType getComponentType() {
                    return ComponentIdentifier.ComponentType.ROUTER;
                }
            };
        }

        public ComponentLocation getLocation(final String flowPath) {
            if (flowPath == null) {
                return null;
            }
            return new ComponentLocation(){

                public String getPath() {
                    return flowPath;
                }

                public Optional<String> getFileName() {
                    return Optional.of((String)FlowRefMessageProcessor.this.getAnnotation(new QName("http://www.mulesoft.org/schema/mule/documentation", "sourceFileName")));
                }

                public Optional<Integer> getLineInFile() {
                    return Optional.of(Integer.valueOf((Integer)FlowRefMessageProcessor.this.getAnnotation(new QName("http://www.mulesoft.org/schema/mule/documentation", "sourceFileLine"))));
                }
            };
        }
    }
}

