/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.parsers.specific;

import org.mule.runtime.config.spring.parsers.MuleDefinitionParser;
import org.mule.runtime.config.spring.parsers.PreProcessor;
import org.mule.runtime.config.spring.parsers.assembly.configuration.PropertyConfiguration;
import org.mule.runtime.config.spring.parsers.delegate.AbstractParallelDelegatingDefinitionParser;
import org.mule.runtime.config.spring.parsers.specific.ComponentDefinitionParser;
import org.mule.runtime.config.spring.parsers.specific.ShortcutComponentDefinitionParser;
import org.mule.runtime.config.spring.util.SpringXMLUtils;
import org.mule.runtime.core.util.StringUtils;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ComponentDelegatingDefinitionParser
extends AbstractParallelDelegatingDefinitionParser {
    private MuleDefinitionParser normalConfig;
    private MuleDefinitionParser shortcutConfig;

    public ComponentDelegatingDefinitionParser(Class clazz) {
        this.normalConfig = new ComponentDefinitionParser(clazz);
        this.shortcutConfig = new ShortcutComponentDefinitionParser(clazz);
        this.addDelegate(this.normalConfig);
        this.addDelegate(this.shortcutConfig);
        this.registerPreProcessor(new CheckExclusiveClassAttributeObjectFactory());
    }

    @Override
    protected MuleDefinitionParser getDelegate(Element element, ParserContext parserContext) {
        if (StringUtils.isEmpty((String)element.getAttribute("class"))) {
            return this.normalConfig;
        }
        return this.shortcutConfig;
    }

    public class CheckExclusiveClassAttributeObjectFactoryException
    extends IllegalStateException {
        private static final long serialVersionUID = 4625276914151932111L;

        CheckExclusiveClassAttributeObjectFactoryException(String message) {
            super(message);
        }
    }

    class CheckExclusiveClassAttributeObjectFactory
    implements PreProcessor {
        private static final String OBJECT_FACTORY_ELEMENT_CONVENTION_SUFFIX = "object";

        CheckExclusiveClassAttributeObjectFactory() {
        }

        @Override
        public void preProcess(PropertyConfiguration config, Element element) {
            NamedNodeMap attributes = element.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                String alias = SpringXMLUtils.attributeName((Attr)((Attr)attributes.item(i)));
                if (!alias.equals("class")) continue;
                for (int j = 0; j < element.getChildNodes().getLength(); ++j) {
                    Node child = element.getChildNodes().item(j);
                    if (!(child instanceof Element) || !child.getLocalName().endsWith(OBJECT_FACTORY_ELEMENT_CONVENTION_SUFFIX)) continue;
                    StringBuilder message = new StringBuilder("The child element '");
                    message.append(child.getLocalName());
                    message.append("' cannot appear with the 'class' attribute");
                    message.append(" in element ");
                    message.append(SpringXMLUtils.elementToString((Element)element));
                    message.append(".");
                    throw new CheckExclusiveClassAttributeObjectFactoryException(message.toString());
                }
            }
        }
    }
}

