/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.factories;

import java.util.List;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.processor.MessageProcessorBuilder;
import org.mule.runtime.core.api.processor.MessageProcessorChainBuilder;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.routing.filter.Filter;
import org.mule.runtime.core.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.routing.MessageProcessorFilterPair;
import org.mule.runtime.core.routing.filters.AcceptAllFilter;
import org.mule.runtime.core.routing.filters.ExpressionFilter;
import org.springframework.beans.factory.FactoryBean;

public class MessageProcessorFilterPairFactoryBean
implements FactoryBean<MessageProcessorFilterPair>,
MuleContextAware {
    private List<Processor> messageProcessors;
    private Filter filter = new ExpressionFilter();
    private MuleContext muleContext;

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public void setMessageProcessors(List<Processor> messageProcessors) {
        this.messageProcessors = messageProcessors;
    }

    public void setExpression(String expression) {
        ((ExpressionFilter)this.filter).setExpression(expression);
    }

    public MessageProcessorFilterPair getObject() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        for (Processor processor : this.messageProcessors) {
            if (processor instanceof Processor) {
                builder.chain(new Processor[]{processor});
                continue;
            }
            if (processor instanceof MessageProcessorBuilder) {
                builder.chain(new MessageProcessorBuilder[]{(MessageProcessorBuilder)processor});
                continue;
            }
            throw new IllegalArgumentException("MessageProcessorBuilder should only have MessageProcessors or MessageProcessorBuilders configured");
        }
        return this.createFilterPair((MessageProcessorChainBuilder)builder);
    }

    private MessageProcessorFilterPair createFilterPair(MessageProcessorChainBuilder builder) throws Exception {
        if (this.filter == null) {
            return new MessageProcessorFilterPair((Processor)builder.build(), (Filter)AcceptAllFilter.INSTANCE);
        }
        return new MessageProcessorFilterPair((Processor)builder.build(), this.filter);
    }

    public Class<MessageProcessorFilterPair> getObjectType() {
        return MessageProcessorFilterPair.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setMuleContext(MuleContext context) {
        if (this.filter != null && this.filter instanceof MuleContextAware) {
            ((MuleContextAware)this.filter).setMuleContext(context);
        }
        this.muleContext = context;
    }
}

