/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.dsl.spring;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.runtime.config.spring.dsl.model.ComponentModel;
import org.mule.runtime.config.spring.dsl.spring.BeanDefinitionBuilderHelper;
import org.mule.runtime.config.spring.dsl.spring.CommonBeanDefinitionCreator;
import org.mule.runtime.config.spring.dsl.spring.ComponentValue;
import org.mule.runtime.config.spring.dsl.spring.DefaultValueVisitor;
import org.mule.runtime.config.spring.dsl.spring.MapFactoryBean;
import org.mule.runtime.config.spring.dsl.spring.ObjectReferencePopulator;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.core.util.ProcessingStrategyUtils;
import org.mule.runtime.dsl.api.component.AttributeDefinition;
import org.mule.runtime.dsl.api.component.AttributeDefinitionVisitor;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.KeyAttributeDefinitionPair;
import org.mule.runtime.dsl.api.component.SetterAttributeDefinition;
import org.mule.runtime.dsl.api.component.TypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;

class ComponentConfigurationBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ComponentConfigurationBuilder.class);
    private final BeanDefinitionBuilderHelper beanDefinitionBuilderHelper;
    private final ObjectReferencePopulator objectReferencePopulator = new ObjectReferencePopulator();
    private final List<ComponentValue> complexParameters;
    private final Map<String, String> simpleParameters;
    private final ComponentModel componentModel;
    private final ComponentBuildingDefinition componentBuildingDefinition;

    public ComponentConfigurationBuilder(ComponentModel componentModel, ComponentBuildingDefinition componentBuildingDefinition, BeanDefinitionBuilderHelper beanDefinitionBuilderHelper) {
        this.componentModel = componentModel;
        this.componentBuildingDefinition = componentBuildingDefinition;
        this.beanDefinitionBuilderHelper = beanDefinitionBuilderHelper;
        this.simpleParameters = new HashMap<String, String>(componentModel.getParameters());
        this.complexParameters = this.collectComplexParametersWithTypes(componentModel);
    }

    public void processConfiguration() {
        this.componentBuildingDefinition.getIgnoredConfigurationParameters().stream().forEach(this.simpleParameters::remove);
        for (SetterAttributeDefinition setterAttributeDefinition : this.componentBuildingDefinition.getSetterParameterDefinitions()) {
            AttributeDefinition attributeDefinition = setterAttributeDefinition.getAttributeDefinition();
            attributeDefinition.accept((AttributeDefinitionVisitor)this.setterVisitor(setterAttributeDefinition.getAttributeName(), attributeDefinition));
        }
        for (AttributeDefinition attributeDefinition : this.componentBuildingDefinition.getConstructorAttributeDefinition()) {
            attributeDefinition.accept((AttributeDefinitionVisitor)this.constructorVisitor());
        }
    }

    private List<ComponentValue> collectComplexParametersWithTypes(ComponentModel componentModel) {
        return componentModel.getInnerComponents().stream().filter(child -> child.isEnabled()).map(cdm -> {
            Class<Object> beanDefinitionType = cdm.getType();
            if (beanDefinitionType == null) {
                if (cdm.getBeanDefinition() == null) {
                    return null;
                }
                try {
                    String beanClassName = cdm.getBeanDefinition().getBeanClassName();
                    beanDefinitionType = beanClassName != null ? ClassUtils.getClass((String)beanClassName) : Object.class;
                }
                catch (ClassNotFoundException e) {
                    logger.debug("Exception trying to determine ComponentModel type: ", (Throwable)e);
                    beanDefinitionType = Object.class;
                }
            }
            BeanDefinition bean = cdm.getBeanDefinition() != null ? cdm.getBeanDefinition() : cdm.getBeanReference();
            return new ComponentValue((ComponentModel)cdm, beanDefinitionType, bean);
        }).filter(beanDefinitionTypePair -> beanDefinitionTypePair != null).collect(Collectors.toList());
    }

    private ConfigurableAttributeDefinitionVisitor constructorVisitor() {
        return new ConfigurableAttributeDefinitionVisitor(this.beanDefinitionBuilderHelper::addConstructorValue);
    }

    private ConfigurableAttributeDefinitionVisitor setterVisitor(String propertyName, AttributeDefinition attributeDefinition) {
        DefaultValueVisitor defaultValueVisitor = new DefaultValueVisitor();
        attributeDefinition.accept((AttributeDefinitionVisitor)defaultValueVisitor);
        Optional<Object> defaultValue = defaultValueVisitor.getDefaultValue();
        return new ConfigurableAttributeDefinitionVisitor(value -> {
            if (this.isPropertySetWithUserConfigValue(propertyName, defaultValue, value)) {
                return;
            }
            this.beanDefinitionBuilderHelper.forProperty(propertyName).addValue(value);
        });
    }

    private boolean isPropertySetWithUserConfigValue(String propertyName, Optional<Object> defaultValue, Object value) {
        return defaultValue.isPresent() && defaultValue.get().equals(value) && this.beanDefinitionBuilderHelper.hasValueForProperty(propertyName);
    }

    private ManagedList constructManagedList(List<Object> beans) {
        ManagedList managedList = new ManagedList();
        managedList.addAll(beans);
        return managedList;
    }

    private List<Object> fromBeanDefinitionTypePairToBeanDefinition(List<ComponentValue> undefinedComplexParameters) {
        return undefinedComplexParameters.stream().map(ComponentValue::getBean).collect(Collectors.toList());
    }

    private class ValueExtractorAttributeDefinitionVisitor
    implements AttributeDefinitionVisitor {
        private Object value;

        private ValueExtractorAttributeDefinitionVisitor() {
        }

        private String getStringValue() {
            return (String)this.getValue();
        }

        public Object getValue() {
            return this.value;
        }

        public void onReferenceObject(Class<?> objectType) {
            ComponentConfigurationBuilder.this.objectReferencePopulator.populate(objectType, referenceId -> {
                this.value = new RuntimeBeanReference(referenceId);
            });
        }

        public void onReferenceSimpleParameter(String configAttributeName) {
            ProcessingStrategyFactory processingStrategyFactory;
            String reference = (String)ComponentConfigurationBuilder.this.simpleParameters.get(configAttributeName);
            if (reference != null) {
                this.value = new RuntimeBeanReference(reference);
            }
            ComponentConfigurationBuilder.this.simpleParameters.remove(configAttributeName);
            if ((configAttributeName.equals("processingStrategy") || configAttributeName.equals("defaultProcessingStrategy")) && (processingStrategyFactory = ProcessingStrategyUtils.parseProcessingStrategy((String)reference)) != null) {
                this.value = processingStrategyFactory;
                return;
            }
        }

        public void onFixedValue(Object value) {
            this.value = value;
        }

        public void onConfigurationParameter(String parameterName, Object defaultValue, Optional<TypeConverter> typeConverter) {
            Object parameterValue = ComponentConfigurationBuilder.this.simpleParameters.get(parameterName);
            ComponentConfigurationBuilder.this.simpleParameters.remove(parameterName);
            Object object = parameterValue = parameterValue != null ? parameterValue : defaultValue;
            if (parameterValue != null) {
                parameterValue = typeConverter.isPresent() ? typeConverter.get().convert(parameterValue) : parameterValue;
            }
            this.value = Optional.ofNullable(parameterValue).orElse(defaultValue);
        }

        public void onUndefinedSimpleParameters() {
            this.value = ComponentConfigurationBuilder.this.simpleParameters;
        }

        public void onUndefinedComplexParameters() {
            this.value = ComponentConfigurationBuilder.this.constructManagedList(ComponentConfigurationBuilder.this.fromBeanDefinitionTypePairToBeanDefinition(ComponentConfigurationBuilder.this.complexParameters));
        }

        public void onComplexChildCollection(Class<?> type, Optional<String> wrapperIdentifier) {
            Predicate<ComponentValue> matchesTypeAndIdentifierPredicate = this.getTypeAndIdentifierPredicate(type, wrapperIdentifier);
            List matchingComponentValues = ComponentConfigurationBuilder.this.complexParameters.stream().filter(matchesTypeAndIdentifierPredicate).collect(Collectors.toList());
            matchingComponentValues.stream().forEach(ComponentConfigurationBuilder.this.complexParameters::remove);
            if (wrapperIdentifier.isPresent() && !matchingComponentValues.isEmpty()) {
                this.value = ((ComponentValue)matchingComponentValues.get(0)).getBean();
            } else if (!matchingComponentValues.isEmpty()) {
                this.value = ComponentConfigurationBuilder.this.constructManagedList(ComponentConfigurationBuilder.this.fromBeanDefinitionTypePairToBeanDefinition(matchingComponentValues));
            }
        }

        public void onComplexChildMap(Class<?> keyType, Class<?> valueType, String wrapperIdentifier) {
            ComponentConfigurationBuilder.this.complexParameters.stream().filter(this.getTypeAndIdentifierPredicate(MapFactoryBean.class, Optional.of(wrapperIdentifier))).findFirst().ifPresent(componentValue -> {
                ComponentConfigurationBuilder.this.complexParameters.remove(componentValue);
                this.value = componentValue.getBean();
            });
        }

        public void onComplexChild(Class<?> type, Optional<String> wrapperIdentifier, Optional<String> childIdentifier) {
            Optional<String> identifier = wrapperIdentifier.isPresent() ? wrapperIdentifier : childIdentifier;
            Predicate<ComponentValue> matchesTypeAndIdentifierPredicate = this.getTypeAndIdentifierPredicate(type, identifier);
            Optional<ComponentValue> value = ComponentConfigurationBuilder.this.complexParameters.stream().filter(matchesTypeAndIdentifierPredicate).findFirst();
            value.ifPresent(beanDefinitionTypePair -> {
                Object bean;
                ComponentConfigurationBuilder.this.complexParameters.remove(beanDefinitionTypePair);
                this.value = bean = beanDefinitionTypePair.getBean();
            });
        }

        private Predicate<ComponentValue> getTypeAndIdentifierPredicate(Class<?> type, Optional<String> identifierOptional) {
            return componentValue -> {
                AtomicReference<Boolean> matchesIdentifier = new AtomicReference<Boolean>(true);
                identifierOptional.ifPresent(wrapperIdentifier -> matchesIdentifier.set(wrapperIdentifier.equals(componentValue.getComponentModel().getIdentifier().getName())));
                return matchesIdentifier.get() != false && CommonBeanDefinitionCreator.areMatchingTypes(type, componentValue.getType());
            };
        }

        public void onValueFromTextContent() {
            this.value = ComponentConfigurationBuilder.this.componentModel.getTextContent();
        }

        public void onMultipleValues(KeyAttributeDefinitionPair[] definitions) {
            for (KeyAttributeDefinitionPair definition : definitions) {
                definition.getAttributeDefinition().accept((AttributeDefinitionVisitor)this);
            }
        }
    }

    private class ConfigurableAttributeDefinitionVisitor
    implements AttributeDefinitionVisitor {
        private final Consumer<Object> valueConsumer;

        ConfigurableAttributeDefinitionVisitor(Consumer<Object> valueConsumer) {
            this.valueConsumer = valueConsumer;
        }

        public void onReferenceObject(Class<?> objectType) {
            ValueExtractorAttributeDefinitionVisitor valueExtractor = new ValueExtractorAttributeDefinitionVisitor();
            valueExtractor.onReferenceObject(objectType);
            this.valueConsumer.accept(valueExtractor.getValue());
        }

        public void onReferenceSimpleParameter(String configAttributeName) {
            ValueExtractorAttributeDefinitionVisitor valueExtractor = new ValueExtractorAttributeDefinitionVisitor();
            valueExtractor.onReferenceSimpleParameter(configAttributeName);
            Object value = valueExtractor.getValue();
            if (value != null) {
                this.valueConsumer.accept(value);
            } else {
                this.valueConsumer.accept(null);
            }
        }

        public void onFixedValue(Object value) {
            ValueExtractorAttributeDefinitionVisitor valueExtractor = new ValueExtractorAttributeDefinitionVisitor();
            valueExtractor.onFixedValue(value);
            this.valueConsumer.accept(value);
        }

        public void onConfigurationParameter(String parameterName, Object defaultValue, Optional<TypeConverter> typeConverter) {
            ValueExtractorAttributeDefinitionVisitor valueExtractor = new ValueExtractorAttributeDefinitionVisitor();
            valueExtractor.onConfigurationParameter(parameterName, defaultValue, typeConverter);
            this.valueConsumer.accept(valueExtractor.getValue());
        }

        public void onUndefinedSimpleParameters() {
            ValueExtractorAttributeDefinitionVisitor valueExtractor = new ValueExtractorAttributeDefinitionVisitor();
            valueExtractor.onUndefinedSimpleParameters();
            this.valueConsumer.accept(valueExtractor.getValue());
        }

        public void onUndefinedComplexParameters() {
            ValueExtractorAttributeDefinitionVisitor valueExtractor = new ValueExtractorAttributeDefinitionVisitor();
            valueExtractor.onUndefinedComplexParameters();
            this.valueConsumer.accept(valueExtractor.getValue());
        }

        public void onComplexChildCollection(Class<?> type, Optional<String> wrapperIdentifier) {
            ValueExtractorAttributeDefinitionVisitor valueExtractor = new ValueExtractorAttributeDefinitionVisitor();
            valueExtractor.onComplexChildCollection(type, wrapperIdentifier);
            this.valueConsumer.accept(valueExtractor.getValue());
        }

        public void onComplexChildMap(Class<?> keyType, Class<?> valueType, String wrapperIdentifier) {
            ValueExtractorAttributeDefinitionVisitor valueExtractor = new ValueExtractorAttributeDefinitionVisitor();
            valueExtractor.onComplexChildMap(keyType, valueType, wrapperIdentifier);
            this.valueConsumer.accept(valueExtractor.getValue());
        }

        public void onComplexChild(Class<?> type, Optional<String> wrapperIdentifier, Optional<String> childIdentifier) {
            ValueExtractorAttributeDefinitionVisitor valueExtractor = new ValueExtractorAttributeDefinitionVisitor();
            valueExtractor.onComplexChild(type, wrapperIdentifier, childIdentifier);
            Object value = valueExtractor.getValue();
            if (value != null) {
                this.valueConsumer.accept(value);
            }
        }

        public void onValueFromTextContent() {
            ValueExtractorAttributeDefinitionVisitor valueExtractor = new ValueExtractorAttributeDefinitionVisitor();
            valueExtractor.onValueFromTextContent();
            this.valueConsumer.accept(valueExtractor.getValue());
        }

        public void onMultipleValues(KeyAttributeDefinitionPair[] definitions) {
            ManagedMap managedMap = new ManagedMap();
            for (KeyAttributeDefinitionPair definition : definitions) {
                ValueExtractorAttributeDefinitionVisitor valueExtractor = new ValueExtractorAttributeDefinitionVisitor();
                definition.getAttributeDefinition().accept((AttributeDefinitionVisitor)valueExtractor);
                Object value = valueExtractor.getValue();
                if (value == null) continue;
                managedMap.put((Object)definition.getKey(), value);
            }
            this.valueConsumer.accept(managedMap);
        }
    }
}

