/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.dsl.model.internal;

import org.apache.commons.lang.StringUtils;
import org.mule.runtime.api.app.declaration.ParameterElementDeclaration;
import org.mule.runtime.api.app.declaration.ParameterValueVisitor;
import org.mule.runtime.api.app.declaration.fluent.ParameterObjectValue;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.config.spring.dsl.model.DslElementModel;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;
import org.mule.runtime.dsl.api.component.config.ComponentIdentifier;
import org.mule.runtime.extension.api.ExtensionConstants;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;

class InfrastructureElementModelDelegate {
    InfrastructureElementModelDelegate() {
    }

    public void addParameter(final ParameterElementDeclaration declaration, final ParameterModel parameterModel, final DslElementSyntax paramDsl, final ComponentConfiguration.Builder parentConfig, final DslElementModel.Builder parentElement) {
        Preconditions.checkArgument((boolean)ExtensionConstants.INFRASTRUCTURE_PARAMETER_NAMES.contains(declaration.getName()), (String)String.format("The parameter '%s' is not of infrastructure kind", declaration.getName()));
        switch (declaration.getName()) {
            case "reconnectionStrategy": {
                this.createReconnectionStrategy(declaration, parameterModel, paramDsl, parentConfig, parentElement);
                return;
            }
            case "streamingStrategy": {
                this.createStreamingStrategy(declaration, parameterModel, paramDsl, parentConfig, parentElement);
                return;
            }
            case "redeliveryPolicy": {
                this.cloneDeclarationToElement(parameterModel, paramDsl, parentConfig, parentElement, (ParameterObjectValue)declaration.getValue(), "redelivery-policy");
                return;
            }
            case "poolingProfile": {
                this.cloneDeclarationToElement(parameterModel, paramDsl, parentConfig, parentElement, (ParameterObjectValue)declaration.getValue(), "pooling-profile");
                return;
            }
            case "tlsContext": {
                this.createTlsContext(declaration, parameterModel, paramDsl, parentConfig, parentElement);
                return;
            }
        }
        declaration.getValue().accept(new ParameterValueVisitor(){

            public void visitSimpleValue(String value) {
                parentConfig.withParameter(declaration.getName(), value);
                parentElement.containing(DslElementModel.builder().withModel(parameterModel).withDsl(paramDsl).withValue(value).build());
            }
        });
    }

    private void createTlsContext(ParameterElementDeclaration declaration, final ParameterModel parameterModel, final DslElementSyntax paramDsl, final ComponentConfiguration.Builder parentConfig, final DslElementModel.Builder parentElement) {
        declaration.getValue().accept(new ParameterValueVisitor(){

            public void visitSimpleValue(String value) {
                parentConfig.withParameter("tlsContext", value);
                parentElement.containing(DslElementModel.builder().withModel(parameterModel).withDsl(paramDsl).build());
            }

            public void visitObjectValue(ParameterObjectValue objectValue) {
                final ComponentConfiguration.Builder tlsConfig = ComponentConfiguration.builder().withIdentifier(ComponentIdentifier.builder().withNamespace("tls").withName("context").build());
                objectValue.getParameters().forEach((name, value) -> value.accept(new ParameterValueVisitor((String)name){
                    final /* synthetic */ String val$name;
                    {
                        this.val$name = string;
                    }

                    public void visitSimpleValue(String value) {
                        tlsConfig.withParameter(this.val$name, value);
                    }

                    public void visitObjectValue(ParameterObjectValue objectValue) {
                        ComponentConfiguration.Builder nested = ComponentConfiguration.builder().withIdentifier(ComponentIdentifier.builder().withNamespace("tls").withName(this.val$name).build());
                        InfrastructureElementModelDelegate.this.cloneParameters(objectValue, nested);
                        tlsConfig.withNestedComponent(nested.build());
                    }
                }));
                InfrastructureElementModelDelegate.this.addParameterElement(parameterModel, paramDsl, parentConfig, parentElement, tlsConfig.build());
            }
        });
    }

    private void createReconnectionStrategy(ParameterElementDeclaration declaration, ParameterModel parameterModel, DslElementSyntax paramDsl, ComponentConfiguration.Builder parentConfig, DslElementModel.Builder parentElement) {
        ParameterObjectValue objectValue = (ParameterObjectValue)declaration.getValue();
        Preconditions.checkArgument((!StringUtils.isBlank((String)objectValue.getTypeId()) ? 1 : 0) != 0, (String)"Missing declaration of which reconnection to use");
        String elementName = objectValue.getTypeId().equals("reconnect") ? "reconnect" : "reconnect-forever";
        this.cloneDeclarationToElement(parameterModel, paramDsl, parentConfig, parentElement, objectValue, elementName);
    }

    private void createStreamingStrategy(ParameterElementDeclaration declaration, ParameterModel parameterModel, DslElementSyntax paramDsl, ComponentConfiguration.Builder parentConfig, DslElementModel.Builder parentElement) {
        ParameterObjectValue objectValue = (ParameterObjectValue)declaration.getValue();
        Preconditions.checkArgument((!StringUtils.isBlank((String)objectValue.getTypeId()) ? 1 : 0) != 0, (String)"Missing declaration of which streaming strategy to use");
        this.cloneDeclarationToElement(parameterModel, paramDsl, parentConfig, parentElement, objectValue, objectValue.getTypeId());
    }

    private void cloneDeclarationToElement(ParameterModel parameterModel, DslElementSyntax paramDsl, ComponentConfiguration.Builder parentConfig, DslElementModel.Builder parentElement, ParameterObjectValue objectValue, String elementName) {
        ComponentConfiguration.Builder redeliveryConfig = ComponentConfiguration.builder().withIdentifier(ComponentIdentifier.builder().withNamespace("mule").withName(elementName).build());
        this.cloneParameters(objectValue, redeliveryConfig);
        this.addParameterElement(parameterModel, paramDsl, parentConfig, parentElement, redeliveryConfig.build());
    }

    private void addParameterElement(ParameterModel parameterModel, DslElementSyntax paramDsl, ComponentConfiguration.Builder parentConfig, DslElementModel.Builder parentElement, ComponentConfiguration result) {
        parentConfig.withNestedComponent(result);
        parentElement.containing(DslElementModel.builder().withModel(parameterModel).withDsl(paramDsl).withConfig(result).build());
    }

    private void cloneParameters(ParameterObjectValue objectValue, final ComponentConfiguration.Builder redeliveryConfig) {
        objectValue.getParameters().forEach((name, value) -> value.accept(new ParameterValueVisitor((String)name){
            final /* synthetic */ String val$name;
            {
                this.val$name = string;
            }

            public void visitSimpleValue(String value) {
                redeliveryConfig.withParameter(this.val$name, value);
            }
        }));
    }
}

