/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.dsl.model.internal;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.config.spring.dsl.model.DslElementModel;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;
import org.mule.runtime.dsl.api.component.config.ComponentIdentifier;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.declaration.type.TypeUtils;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.internal.dsl.syntax.DslSyntaxUtils;

class ConfigurationBasedElementModelFactory {
    private final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    private Map<ExtensionModel, DslSyntaxResolver> resolvers;
    private ExtensionModel currentExtension;
    private DslSyntaxResolver dsl;

    ConfigurationBasedElementModelFactory(Map<ExtensionModel, DslSyntaxResolver> resolvers) {
        this.resolvers = resolvers;
    }

    public <T> Optional<DslElementModel<T>> create(ComponentConfiguration configuration) {
        return Optional.ofNullable(this.createIdentifiedElement(configuration));
    }

    private DslElementModel createIdentifiedElement(final ComponentConfiguration configuration) {
        final ComponentIdentifier identifier = configuration.getIdentifier();
        Optional<Map.Entry> entry = this.resolvers.entrySet().stream().filter(e -> ((ExtensionModel)e.getKey()).getXmlDslModel().getNamespaceUri().equals(identifier.getNamespace())).findFirst();
        if (!entry.isPresent()) {
            return null;
        }
        this.currentExtension = (ExtensionModel)entry.get().getKey();
        this.dsl = (DslSyntaxResolver)entry.get().getValue();
        final Reference elementModel = new Reference();
        new ExtensionWalker(){

            protected void onConfiguration(ConfigurationModel model) {
                DslElementSyntax elementDsl = ConfigurationBasedElementModelFactory.this.dsl.resolve((NamedObject)model);
                ConfigurationBasedElementModelFactory.this.getIdentifier(elementDsl).ifPresent(elementId -> {
                    if (elementId.equals((Object)identifier)) {
                        DslElementModel.Builder element = ConfigurationBasedElementModelFactory.this.createElementModel((ParameterizedModel)model, elementDsl, configuration);
                        ConfigurationBasedElementModelFactory.this.addConnectionProvider(model, ConfigurationBasedElementModelFactory.this.dsl, element, configuration);
                        elementModel.set(element.build());
                        this.stop();
                    }
                });
            }

            protected void onOperation(HasOperationModels owner, OperationModel model) {
                DslElementSyntax elementDsl = ConfigurationBasedElementModelFactory.this.dsl.resolve((NamedObject)model);
                ConfigurationBasedElementModelFactory.this.getIdentifier(elementDsl).ifPresent(elementId -> {
                    if (elementId.equals((Object)identifier)) {
                        elementModel.set(ConfigurationBasedElementModelFactory.this.createElementModel((ParameterizedModel)model, elementDsl, configuration).build());
                        this.stop();
                    }
                });
            }

            protected void onSource(HasSourceModels owner, SourceModel model) {
                DslElementSyntax elementDsl = ConfigurationBasedElementModelFactory.this.dsl.resolve((NamedObject)model);
                ConfigurationBasedElementModelFactory.this.getIdentifier(elementDsl).ifPresent(elementId -> {
                    if (elementId.equals((Object)identifier)) {
                        elementModel.set(ConfigurationBasedElementModelFactory.this.createElementModel((ParameterizedModel)model, elementDsl, configuration).build());
                        this.stop();
                    }
                });
            }
        }.walk(this.currentExtension);
        if (elementModel.get() == null) {
            this.resolveBasedOnTypes(configuration).ifPresent(arg_0 -> ((Reference)elementModel).set(arg_0));
        }
        return (DslElementModel)elementModel.get();
    }

    private Optional<DslElementModel<ObjectType>> resolveBasedOnTypes(ComponentConfiguration configuration) {
        return this.currentExtension.getTypes().stream().map(type -> this.resolveBasedOnType((ObjectType)type, configuration)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private Optional<DslElementModel<ObjectType>> resolveBasedOnType(ObjectType type, ComponentConfiguration configuration) {
        Optional<ComponentIdentifier> elementIdentifier;
        Optional typeDsl = this.dsl.resolve((MetadataType)type);
        if (typeDsl.isPresent() && (elementIdentifier = this.getIdentifier((DslElementSyntax)typeDsl.get())).isPresent() && elementIdentifier.get().equals((Object)configuration.getIdentifier())) {
            DslElementModel.Builder<ObjectType> typeBuilder = DslElementModel.builder().withModel(type).withDsl((DslElementSyntax)typeDsl.get()).withConfig(configuration);
            this.populateObjectFields(type, configuration, (DslElementSyntax)typeDsl.get(), typeBuilder);
            return Optional.of(typeBuilder.build());
        }
        return Optional.empty();
    }

    private void populateObjectFields(ObjectType type, ComponentConfiguration configuration, DslElementSyntax typeDsl, DslElementModel.Builder typeBuilder) {
        type.getFields().forEach(field -> {
            if (DslSyntaxUtils.isFlattened((ObjectFieldType)field, (MetadataType)field.getValue())) {
                ((ObjectType)field.getValue()).getFields().forEach(nested -> {
                    String name = MetadataTypeUtils.getLocalPart((ObjectFieldType)nested);
                    DslElementSyntax fieldDsl = (DslElementSyntax)typeDsl.getContainedElement(name).get();
                    Optional defaultValue = ExtensionModelUtils.getDefaultValue((String)name, (MetadataType)type);
                    nested.getValue().accept(this.getComponentChildVisitor(typeBuilder, configuration, (MetadataType)nested, name, fieldDsl, defaultValue));
                });
            } else {
                String name = MetadataTypeUtils.getLocalPart((ObjectFieldType)field);
                DslElementSyntax fieldDsl = (DslElementSyntax)typeDsl.getContainedElement(name).get();
                Optional defaultValue = ExtensionModelUtils.getDefaultValue((String)name, (MetadataType)type);
                field.getValue().accept(this.getComponentChildVisitor(typeBuilder, configuration, (MetadataType)field, name, fieldDsl, defaultValue));
            }
        });
    }

    private Map<ComponentIdentifier, ComponentConfiguration> geteNestedComponents(ComponentConfiguration configuration) {
        return configuration.getNestedComponents().stream().collect(Collectors.toMap(ComponentConfiguration::getIdentifier, e -> e));
    }

    private MetadataTypeVisitor getComponentChildVisitor(final DslElementModel.Builder typeBuilder, final ComponentConfiguration configuration, final MetadataType model, final String name, final DslElementSyntax modelDsl, final Optional<String> defaultValue) {
        final Map parameters = configuration.getParameters();
        return new MetadataTypeVisitor(){

            protected void defaultVisit(MetadataType metadataType) {
                Optional identifier = ConfigurationBasedElementModelFactory.this.getIdentifier(modelDsl);
                String value = (String)parameters.get(name);
                if (StringUtils.isBlank((String)value)) {
                    if (identifier.isPresent()) {
                        ComponentConfiguration nested = (ComponentConfiguration)ConfigurationBasedElementModelFactory.this.geteNestedComponents(configuration).get(identifier.get());
                        if (nested != null && nested.getValue().isPresent() && !StringUtils.isBlank((String)((String)nested.getValue().get()))) {
                            value = ((String)nested.getValue().get()).trim();
                        }
                    } else if (defaultValue.isPresent()) {
                        value = (String)defaultValue.get();
                    }
                }
                if (!StringUtils.isBlank((String)value)) {
                    typeBuilder.containing(DslElementModel.builder().withModel(model).withDsl(modelDsl).withValue(value).build());
                }
            }

            public void visitArrayType(ArrayType arrayType) {
                ComponentConfiguration fieldComponent;
                if (TypeUtils.isContent((MetadataType)model)) {
                    this.defaultVisit((MetadataType)arrayType);
                    return;
                }
                Optional identifier = ConfigurationBasedElementModelFactory.this.getIdentifier(modelDsl);
                if (identifier.isPresent() && (fieldComponent = (ComponentConfiguration)ConfigurationBasedElementModelFactory.this.geteNestedComponents(configuration).get(identifier.get())) != null) {
                    DslElementModel.Builder<MetadataType> list = DslElementModel.builder().withModel(model).withDsl(modelDsl).withConfig(fieldComponent);
                    modelDsl.getGeneric(arrayType.getType()).ifPresent(itemdsl -> {
                        ComponentIdentifier itemIdentifier = (ComponentIdentifier)ConfigurationBasedElementModelFactory.this.getIdentifier(itemdsl).get();
                        fieldComponent.getNestedComponents().forEach(c -> {
                            if (c.getIdentifier().equals((Object)itemIdentifier)) {
                                ConfigurationBasedElementModelFactory.this.getComponentChildVisitor(list, c, arrayType.getType(), "value", itemdsl, defaultValue);
                            }
                        });
                    });
                    typeBuilder.containing(list.build());
                    return;
                }
                defaultValue.ifPresent(s -> typeBuilder.containing(DslElementModel.builder().withModel(model).withDsl(modelDsl).withValue((String)defaultValue.get()).build()));
            }

            public void visitObject(ObjectType objectType) {
                if (TypeUtils.isContent((MetadataType)model)) {
                    this.defaultVisit((MetadataType)objectType);
                    return;
                }
                Optional identifier = ConfigurationBasedElementModelFactory.this.getIdentifier(modelDsl);
                if (identifier.isPresent()) {
                    if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                        typeBuilder.containing(ConfigurationBasedElementModelFactory.this.createMapElement(objectType, modelDsl, configuration));
                        return;
                    }
                    ComponentConfiguration fieldComponent = (ComponentConfiguration)ConfigurationBasedElementModelFactory.this.geteNestedComponents(configuration).get(identifier.get());
                    fieldComponent = fieldComponent == null ? configuration : fieldComponent;
                    String value = (String)fieldComponent.getParameters().get(modelDsl.getAttributeName());
                    if (!StringUtils.isBlank((String)value)) {
                        typeBuilder.containing(DslElementModel.builder().withModel(model).withDsl(modelDsl).withValue(value).build());
                    } else {
                        ConfigurationBasedElementModelFactory.this.resolveBasedOnType(objectType, fieldComponent).ifPresent(typeBuilder::containing);
                    }
                    return;
                }
                defaultValue.ifPresent(s -> typeBuilder.containing(DslElementModel.builder().withModel(model).withDsl(modelDsl).withValue((String)defaultValue.get()).build()));
            }
        };
    }

    private DslElementModel createMapElement(ObjectType objectType, DslElementSyntax modelDsl, ComponentConfiguration configuration) {
        DslElementModel.Builder<ObjectType> mapBuilder = DslElementModel.builder().withModel(objectType).withDsl(modelDsl).withConfig(configuration);
        if (!configuration.getNestedComponents().isEmpty()) {
            this.populateMapEntries(objectType, modelDsl, mapBuilder, configuration);
        }
        return mapBuilder.build();
    }

    private void populateMapEntries(ObjectType objectType, DslElementSyntax modelDsl, DslElementModel.Builder mapBuilder, ComponentConfiguration mapConfig) {
        mapConfig.getNestedComponents().forEach(entryConfig -> {
            MetadataType entryType = (MetadataType)objectType.getOpenRestriction().get();
            modelDsl.getGeneric(entryType).ifPresent(entryDsl -> {
                DslElementModel.Builder<MetadataType> entry = DslElementModel.builder().withModel(entryType).withConfig((ComponentConfiguration)entryConfig).withDsl((DslElementSyntax)entryDsl);
                entry.containing(DslElementModel.builder().withModel(this.typeLoader.load(String.class)).withValue((String)entryConfig.getParameters().get("key")).withDsl((DslElementSyntax)entryDsl.getAttribute("key").get()).build());
                String value = (String)entryConfig.getParameters().get("value");
                if (StringUtils.isBlank((String)value)) {
                    this.getComponentChildVisitor(entry, (ComponentConfiguration)entryConfig, entryType, "value", (DslElementSyntax)entryDsl.getAttribute("value").get(), Optional.empty());
                } else {
                    entry.containing(DslElementModel.builder().withModel(this.typeLoader.load(String.class)).withValue(value).withDsl((DslElementSyntax)entryDsl.getAttribute("value").get()).build());
                }
                mapBuilder.containing(entry.build());
            });
        });
    }

    private DslElementModel.Builder<ConfigurationModel> addConnectionProvider(ConfigurationModel model, DslSyntaxResolver dsl, DslElementModel.Builder<ConfigurationModel> element, ComponentConfiguration configuration) {
        Stream.concat(model.getConnectionProviders().stream(), this.currentExtension.getConnectionProviders().stream()).map(provider -> {
            DslElementSyntax providerDsl = dsl.resolve((NamedObject)provider);
            ComponentIdentifier identifier = this.getIdentifier(providerDsl).orElse(null);
            return configuration.getNestedComponents().stream().filter(c -> c.getIdentifier().equals((Object)identifier)).findFirst().map(providerConfig -> element.containing(this.createElementModel((ParameterizedModel)provider, providerDsl, (ComponentConfiguration)providerConfig).build())).orElse(null);
        }).filter(Objects::nonNull).findFirst();
        return element;
    }

    private <T extends ParameterizedModel> DslElementModel.Builder<T> createElementModel(T model, DslElementSyntax elementDsl, ComponentConfiguration configuration) {
        DslElementModel.Builder<T> builder = DslElementModel.builder();
        builder.withModel(model).withDsl(elementDsl).withConfig(configuration);
        this.populateParameterizedElements(model, elementDsl, builder, configuration);
        return builder;
    }

    private void populateParameterizedElements(ParameterizedModel model, DslElementSyntax elementDsl, DslElementModel.Builder builder, ComponentConfiguration configuration) {
        Map<ComponentIdentifier, ComponentConfiguration> innerComponents = this.geteNestedComponents(configuration);
        Map parameters = configuration.getParameters();
        List inlineGroupedParameters = model.getParameterGroupModels().stream().filter(ParameterGroupModel::isShowInDsl).peek(group -> this.addInlineGroup(elementDsl, innerComponents, parameters, (ParameterGroupModel)group)).flatMap(g -> g.getParameterModels().stream()).collect(Collectors.toList());
        model.getAllParameterModels().stream().filter(p -> !inlineGroupedParameters.contains(p)).forEach(p -> this.addElementParameter(innerComponents, parameters, elementDsl, builder, (ParameterModel)p));
    }

    private void addInlineGroup(DslElementSyntax elementDsl, Map<ComponentIdentifier, ComponentConfiguration> innerComponents, Map<String, String> parameters, ParameterGroupModel group) {
        elementDsl.getChild(group.getName()).ifPresent(groupDsl -> {
            ComponentConfiguration groupComponent = this.getIdentifier((DslElementSyntax)groupDsl).map(innerComponents::get).orElse(null);
            if (groupComponent != null) {
                DslElementModel.Builder<ParameterGroupModel> groupElementBuilder = DslElementModel.builder().withModel(group).withDsl((DslElementSyntax)groupDsl).withConfig(groupComponent);
                group.getParameterModels().forEach(p -> this.addElementParameter(innerComponents, parameters, (DslElementSyntax)groupDsl, groupElementBuilder, (ParameterModel)p));
            }
        });
    }

    private void addElementParameter(Map<ComponentIdentifier, ComponentConfiguration> innerComponents, Map<String, String> parameters, DslElementSyntax groupDsl, DslElementModel.Builder<ParameterGroupModel> groupElementBuilder, ParameterModel paramModel) {
        groupDsl.getContainedElement(paramModel.getName()).ifPresent(paramDsl -> {
            if (ExtensionModelUtils.isInfrastructure((ParameterModel)paramModel)) {
                this.handleInfrastructure(paramModel, (DslElementSyntax)paramDsl, innerComponents, parameters, groupElementBuilder);
                return;
            }
            ComponentConfiguration paramComponent = this.getIdentifier((DslElementSyntax)paramDsl).map(innerComponents::get).orElse(null);
            if (paramDsl.isWrapped()) {
                this.resolveWrappedElement(groupElementBuilder, paramModel, (DslElementSyntax)paramDsl, paramComponent);
                return;
            }
            String value = paramDsl.supportsAttributeDeclaration() ? (String)parameters.get(paramDsl.getAttributeName()) : null;
            Optional defaultValue = ExtensionModelUtils.getDefaultValue((ParameterModel)paramModel);
            if (paramComponent != null || !StringUtils.isBlank((String)value) || defaultValue.isPresent()) {
                DslElementModel.Builder<ParameterModel> paramElementBuilder = DslElementModel.builder().withModel(paramModel).withDsl((DslElementSyntax)paramDsl);
                if (paramComponent != null && !ExtensionModelUtils.isContent((ParameterModel)paramModel)) {
                    paramElementBuilder.withConfig(paramComponent);
                    paramModel.getType().accept(new MetadataTypeVisitor((DslElementSyntax)paramDsl, paramComponent, paramElementBuilder, defaultValue){
                        final /* synthetic */ DslElementSyntax val$paramDsl;
                        final /* synthetic */ ComponentConfiguration val$paramComponent;
                        final /* synthetic */ DslElementModel.Builder val$paramElementBuilder;
                        final /* synthetic */ Optional val$defaultValue;
                        {
                            this.val$paramDsl = dslElementSyntax;
                            this.val$paramComponent = componentConfiguration;
                            this.val$paramElementBuilder = builder;
                            this.val$defaultValue = optional;
                        }

                        public void visitArrayType(ArrayType arrayType) {
                            MetadataType itemType = arrayType.getType();
                            this.val$paramDsl.getGeneric(itemType).ifPresent(itemdsl -> {
                                ComponentIdentifier itemIdentifier = (ComponentIdentifier)ConfigurationBasedElementModelFactory.this.getIdentifier(itemdsl).get();
                                this.val$paramComponent.getNestedComponents().forEach(c -> {
                                    if (c.getIdentifier().equals((Object)itemIdentifier)) {
                                        itemType.accept(ConfigurationBasedElementModelFactory.this.getComponentChildVisitor(this.val$paramElementBuilder, c, itemType, "value", itemdsl, this.val$defaultValue));
                                    }
                                });
                            });
                        }

                        public void visitObject(ObjectType objectType) {
                            if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                                ConfigurationBasedElementModelFactory.this.populateMapEntries(objectType, this.val$paramDsl, this.val$paramElementBuilder, this.val$paramComponent);
                                return;
                            }
                            ConfigurationBasedElementModelFactory.this.populateObjectFields(objectType, this.val$paramComponent, this.val$paramDsl, this.val$paramElementBuilder);
                        }
                    });
                } else {
                    if (StringUtils.isBlank((String)value)) {
                        if (paramComponent != null && paramComponent.getValue().isPresent() && !StringUtils.isBlank((String)((String)paramComponent.getValue().get()))) {
                            value = ((String)paramComponent.getValue().get()).trim();
                        } else if (defaultValue.isPresent()) {
                            value = (String)defaultValue.get();
                        }
                    }
                    paramElementBuilder.withValue(value);
                }
                groupElementBuilder.containing(paramElementBuilder.build());
            }
        });
    }

    private void resolveWrappedElement(DslElementModel.Builder<ParameterGroupModel> groupElementBuilder, ParameterModel p, DslElementSyntax pDsl, ComponentConfiguration paramComponent) {
        if (paramComponent != null) {
            DslElementModel.Builder<ParameterModel> paramElement = DslElementModel.builder().withModel(p).withDsl(pDsl).withConfig(paramComponent);
            if (paramComponent.getNestedComponents().size() > 0) {
                ComponentConfiguration wrappedComponent = (ComponentConfiguration)paramComponent.getNestedComponents().get(0);
                this.create(wrappedComponent).ifPresent(paramElement::containing);
            }
            groupElementBuilder.containing(paramElement.build());
        }
    }

    private Optional<ComponentIdentifier> getIdentifier(DslElementSyntax dsl) {
        if (dsl.supportsTopLevelDeclaration() || dsl.supportsChildDeclaration()) {
            return Optional.of(ComponentIdentifier.builder().withName(dsl.getElementName()).withNamespace(dsl.getNamespaceUri()).build());
        }
        return Optional.empty();
    }

    private void handleInfrastructure(ParameterModel paramModel, DslElementSyntax paramDsl, Map<ComponentIdentifier, ComponentConfiguration> nested, Map<String, String> parameters, DslElementModel.Builder<ParameterGroupModel> groupElementBuilder) {
        switch (paramModel.getName()) {
            case "reconnectionStrategy": {
                ComponentConfiguration config;
                ComponentIdentifier reconnectId = this.newIdentifier("reconnect", paramDsl.getNamespaceUri());
                ComponentConfiguration componentConfiguration = config = nested.containsKey(reconnectId) ? nested.get(reconnectId) : nested.get(this.newIdentifier("reconnect-forever", paramDsl.getNamespaceUri()));
                if (config != null) {
                    groupElementBuilder.containing(this.newElementModel(paramModel, paramDsl, config));
                }
                return;
            }
            case "redeliveryPolicy": {
                ComponentConfiguration redelivery = nested.get(this.newIdentifier("redelivery-policy", paramDsl.getNamespaceUri()));
                if (redelivery != null) {
                    groupElementBuilder.containing(this.newElementModel(paramModel, paramDsl, redelivery));
                }
                return;
            }
            case "poolingProfile": {
                ComponentConfiguration pooling = nested.get(this.getIdentifier(paramDsl).get());
                if (pooling != null) {
                    groupElementBuilder.containing(this.newElementModel(paramModel, paramDsl, pooling));
                }
                return;
            }
            case "disableValidation": {
                if (!StringUtils.isBlank((String)parameters.get("disableValidation"))) {
                    groupElementBuilder.containing(DslElementModel.builder().withModel(paramModel).withDsl(paramDsl).withValue(parameters.get("disableValidation")).build());
                }
                return;
            }
            case "streamingStrategy": {
                ComponentConfiguration streaming = null;
                for (ComponentIdentifier componentIdentifier : nested.keySet()) {
                    if (componentIdentifier.getName().equals("in-memory-stream")) {
                        streaming = nested.get(componentIdentifier);
                        break;
                    }
                    if (componentIdentifier.getName().equals("repeatable-in-memory-stream")) {
                        streaming = nested.get(componentIdentifier);
                        break;
                    }
                    if (!componentIdentifier.getName().equals("repeatable-file-store-stream")) continue;
                    streaming = nested.get(componentIdentifier);
                    break;
                }
                if (streaming != null) {
                    groupElementBuilder.containing(this.newElementModel(paramModel, paramDsl, streaming));
                }
                return;
            }
            case "tlsContext": {
                ComponentConfiguration tls = nested.get(this.getIdentifier(paramDsl).get());
                if (tls != null) {
                    groupElementBuilder.containing(this.newElementModel(paramModel, paramDsl, tls));
                } else if (!StringUtils.isBlank((String)parameters.get("tlsContext"))) {
                    groupElementBuilder.containing(DslElementModel.builder().withModel(paramModel).withDsl(paramDsl).withValue(parameters.get("tlsContext")).build());
                }
                return;
            }
        }
    }

    private ComponentIdentifier newIdentifier(String name, String ns) {
        return ComponentIdentifier.builder().withName(name).withNamespace(ns).build();
    }

    private DslElementModel newElementModel(ParameterModel paramModel, DslElementSyntax paramDsl, ComponentConfiguration configuration) {
        return DslElementModel.builder().withModel(paramModel).withDsl(paramDsl).withConfig(configuration).build();
    }
}

