/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.dsl.model;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.HashedMap;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.processor.MessageRouter;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;
import org.mule.runtime.dsl.api.component.config.ComponentIdentifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;

public class ComponentModel {
    private boolean root = false;
    private ComponentIdentifier identifier;
    private Map<String, Object> customAttributes = new HashMap<String, Object>();
    private Map<String, String> parameters = new HashMap<String, String>();
    private Set<String> schemaValueParameter = new HashSet<String>();
    private ComponentModel parent;
    private Map<String, Object> annotations = new HashedMap();
    private List<ComponentModel> innerComponents = new ArrayList<ComponentModel>();
    private String textContent;
    private BeanReference beanReference;
    private BeanDefinition beanDefinition;
    private Class<?> type;
    private boolean enabled = true;

    public ComponentIdentifier getIdentifier() {
        return this.identifier;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public List<ComponentModel> getInnerComponents() {
        return this.innerComponents;
    }

    public Map<String, Object> getCustomAttributes() {
        return ImmutableMap.copyOf(this.customAttributes);
    }

    public boolean isRoot() {
        return this.root;
    }

    public void setBeanDefinition(BeanDefinition beanDefinition) {
        this.beanDefinition = beanDefinition;
    }

    public void setRoot(boolean root) {
        this.root = root;
    }

    public void setParameter(String parameterName, String value) {
        this.parameters.put(parameterName, value);
    }

    public BeanDefinition getBeanDefinition() {
        return this.beanDefinition;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public String getNameAttribute() {
        return this.parameters.get("name");
    }

    public boolean isScope() {
        return MessageRouter.class.isAssignableFrom(this.type);
    }

    public void setParent(ComponentModel parent) {
        this.parent = parent;
    }

    public ComponentModel getParent() {
        return this.parent;
    }

    public String getTextContent() {
        return this.textContent;
    }

    public void setBeanReference(BeanReference beanReference) {
        this.beanReference = beanReference;
    }

    public BeanReference getBeanReference() {
        return this.beanReference;
    }

    public boolean isParameterValueProvidedBySchema(String parameterName) {
        return this.schemaValueParameter.contains(parameterName);
    }

    public Map<String, Object> getAnnotations() {
        return Collections.unmodifiableMap(this.annotations);
    }

    public ComponentConfiguration getConfiguration() {
        ComponentConfiguration.Builder builder = ComponentConfiguration.builder().withIdentifier(ComponentIdentifier.builder().withName(this.getIdentifier().getName()).withNamespace((String)this.getCustomAttributes().get("NAMESPACE_URI")).build()).withValue(this.textContent);
        this.parameters.entrySet().forEach(e -> builder.withParameter((String)e.getKey(), (String)e.getValue()));
        this.innerComponents.forEach(i -> builder.withNestedComponent(i.getConfiguration()));
        return builder.build();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.getInnerComponents().stream().forEach(innerComponent -> innerComponent.setEnabled(enabled));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentModel that = (ComponentModel)o;
        if (this.root != that.root) {
            return false;
        }
        if (!this.identifier.equals((Object)that.identifier)) {
            return false;
        }
        if (!this.parameters.equals(that.parameters)) {
            return false;
        }
        return this.innerComponents.equals(that.innerComponents);
    }

    public int hashCode() {
        int result = this.root ? 1 : 0;
        result = 31 * result + this.identifier.hashCode();
        result = 31 * result + this.parameters.hashCode();
        result = 31 * result + this.innerComponents.hashCode();
        return result;
    }

    public static class Builder {
        private ComponentModel model = new ComponentModel();

        public Builder setIdentifier(ComponentIdentifier identifier) {
            this.model.identifier = identifier;
            return this;
        }

        public Builder addParameter(String parameterName, String value, boolean valueFromSchema) {
            this.model.parameters.put(parameterName, value);
            if (valueFromSchema) {
                this.model.schemaValueParameter.add(parameterName);
            }
            return this;
        }

        public Builder addChildComponentModel(ComponentModel componentModel) {
            this.model.innerComponents.add(componentModel);
            componentModel.setParent(this.model);
            return this;
        }

        public Builder setTextContent(String textContent) {
            this.model.textContent = textContent;
            return this;
        }

        public Builder markAsRootComponent() {
            this.model.root = true;
            return this;
        }

        public Builder addCustomAttribute(String name, Object value) {
            this.model.customAttributes.put(name, value);
            return this;
        }

        public ComponentModel build() {
            Preconditions.checkState((this.model.identifier != null ? 1 : 0) != 0, (String)"An identifier must be provided");
            return this.model;
        }
    }
}

