/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring;

import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.config.spring.DefaultXmlGathererErrorHandlerFactory;
import org.mule.runtime.config.spring.ModuleDelegatingEntityResolver;
import org.mule.runtime.config.spring.MuleDocumentLoader;
import org.mule.runtime.config.spring.XmlGathererErrorHandler;
import org.mule.runtime.config.spring.XmlGathererErrorHandlerFactory;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class XmlConfigurationDocumentLoader {
    private static final int VALIDATION_XSD = 3;
    private final XmlGathererErrorHandlerFactory xmlGathererErrorHandlerFactory;

    public XmlConfigurationDocumentLoader() {
        this(new DefaultXmlGathererErrorHandlerFactory());
    }

    public XmlConfigurationDocumentLoader(XmlGathererErrorHandlerFactory xmlGathererErrorHandlerFactory) {
        this.xmlGathererErrorHandlerFactory = xmlGathererErrorHandlerFactory;
    }

    public Document loadDocument(String filename, InputStream inputStream) {
        return this.loadDocument(Optional.empty(), filename, inputStream);
    }

    public Document loadDocument(Optional<ExtensionManager> extensionManager, String filename, InputStream inputStream) {
        Document document;
        XmlGathererErrorHandler errorHandler = this.xmlGathererErrorHandlerFactory.create();
        try {
            document = new MuleDocumentLoader().loadDocument(new InputSource(inputStream), new ModuleDelegatingEntityResolver(extensionManager), errorHandler, 3, true);
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        this.throwExceptionIfErrorsWereFound(errorHandler, filename);
        return document;
    }

    private void throwExceptionIfErrorsWereFound(XmlGathererErrorHandler errorHandler, String filename) {
        List<SAXParseException> errors = errorHandler.getErrors();
        if (!errors.isEmpty()) {
            String subMessage = String.format(errors.size() == 1 ? "was '%s' error" : "were '%s' errors", errors.size());
            StringBuilder sb = new StringBuilder(String.format("There %s while parsing the file '%s'.", subMessage, filename));
            sb.append(System.lineSeparator()).append("Full list:");
            errors.stream().forEach(error -> sb.append(System.lineSeparator()).append(error));
            sb.append(System.lineSeparator());
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)sb.toString()));
        }
    }
}

