/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring;

import java.util.Optional;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.ComponentId;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.metadata.ProcessorId;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.config.spring.LazyMuleArtifactContext;
import org.mule.runtime.config.spring.dsl.model.NoSuchComponentModelException;

public class LazyMetadataService
implements MetadataService {
    private final LazyMuleArtifactContext lazyMuleArtifactContext;
    private final MetadataService metadataService;

    public LazyMetadataService(LazyMuleArtifactContext lazyMuleArtifactContext, MetadataService metadataService) {
        this.lazyMuleArtifactContext = lazyMuleArtifactContext;
        this.metadataService = metadataService;
    }

    public MetadataResult<MetadataKeysContainer> getMetadataKeys(ComponentId componentId) {
        return this.initializeComponent(componentId).orElseGet(() -> this.metadataService.getMetadataKeys(this.adjustProcessorId(componentId)));
    }

    public MetadataResult<ComponentMetadataDescriptor<OperationModel>> getOperationMetadata(ComponentId componentId) {
        return this.initializeComponent(componentId).orElseGet(() -> this.metadataService.getOperationMetadata(this.adjustProcessorId(componentId)));
    }

    private ComponentId adjustProcessorId(ComponentId componentId) {
        if (componentId instanceof ProcessorId) {
            return new ProcessorId((String)componentId.getFlowName().get(), "0");
        }
        return componentId;
    }

    public MetadataResult<ComponentMetadataDescriptor<OperationModel>> getOperationMetadata(ComponentId componentId, MetadataKey key) {
        return this.initializeComponent(componentId).orElseGet(() -> this.metadataService.getOperationMetadata(this.adjustProcessorId(componentId), key));
    }

    public MetadataResult<ComponentMetadataDescriptor<SourceModel>> getSourceMetadata(ComponentId componentId) {
        return this.initializeComponent(componentId).orElseGet(() -> this.metadataService.getSourceMetadata(componentId));
    }

    public MetadataResult<ComponentMetadataDescriptor<SourceModel>> getSourceMetadata(ComponentId componentId, MetadataKey key) {
        return this.initializeComponent(componentId).orElseGet(() -> this.metadataService.getSourceMetadata(componentId, key));
    }

    public void disposeCache(String id) {
        this.metadataService.disposeCache(id);
    }

    public MetadataResult<MetadataKeysContainer> getEntityKeys(ComponentId componentId) {
        return this.initializeComponent(componentId).orElseGet(() -> this.metadataService.getEntityKeys(componentId));
    }

    public MetadataResult<TypeMetadataDescriptor> getEntityMetadata(ComponentId componentId, MetadataKey key) {
        return this.initializeComponent(componentId).orElseGet(() -> this.metadataService.getEntityMetadata(componentId, key));
    }

    private Optional<MetadataResult<?>> initializeComponent(ComponentId componentId) {
        String componentIdentifier = componentId.getFlowName().isPresent() ? (String)componentId.getFlowName().get() + "/" + componentId.getComponentPath() : componentId.getComponentPath();
        try {
            this.lazyMuleArtifactContext.initializeComponent(componentIdentifier);
        }
        catch (NoSuchComponentModelException e) {
            return Optional.of(MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)((Object)e)).withFailureCode(FailureCode.COMPONENT_NOT_FOUND).onComponent()}));
        }
        catch (Exception e) {
            return Optional.of(MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)e).onComponent()}));
        }
        return Optional.empty();
    }
}

