/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring;

import com.google.common.base.Throwables;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.config.spring.LazyComponentInitializer;
import org.mule.runtime.config.spring.dsl.model.NoSuchComponentModelException;
import org.mule.runtime.core.api.connectivity.ConnectivityTestingService;
import org.mule.runtime.core.api.exception.ObjectNotFoundException;

public class LazyConnectivityTestingService
implements ConnectivityTestingService {
    private final LazyComponentInitializer lazyComponentInitializer;
    private final ConnectivityTestingService connectivityTestingService;

    public LazyConnectivityTestingService(LazyComponentInitializer lazyComponentInitializer, ConnectivityTestingService connectivityTestingService) {
        this.lazyComponentInitializer = lazyComponentInitializer;
        this.connectivityTestingService = connectivityTestingService;
    }

    public ConnectionValidationResult testConnection(String identifier) {
        try {
            this.lazyComponentInitializer.initializeComponent(identifier);
        }
        catch (MuleRuntimeException e) {
            if (e.getCause() instanceof NoSuchComponentModelException) {
                throw new ObjectNotFoundException(identifier);
            }
            return Throwables.getCausalChain((Throwable)e).stream().filter(exception -> exception.getClass().equals(ConnectionException.class) && ((ConnectionException)exception).getErrorType().isPresent()).map(exception -> ConnectionValidationResult.failure((String)exception.getMessage(), (ErrorType)((ErrorType)((ConnectionException)exception).getErrorType().get()), (Exception)((Exception)exception))).findFirst().orElse(this.unknownFailureResponse((Exception)((Object)e)));
        }
        catch (Exception e) {
            return this.unknownFailureResponse(e);
        }
        return this.connectivityTestingService.testConnection(identifier);
    }

    private ConnectionValidationResult unknownFailureResponse(Exception e) {
        return ConnectionValidationResult.failure((String)e.getMessage(), (Exception)e);
    }
}

