/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.dsl.model;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.config.spring.dsl.model.ApplicationModel;
import org.mule.runtime.config.spring.dsl.model.ComponentBuildingDefinitionRegistry;
import org.mule.runtime.config.spring.dsl.model.ComponentModel;
import org.mule.runtime.config.spring.dsl.model.NoSuchComponentModelException;
import org.mule.runtime.config.spring.dsl.processor.AbstractAttributeDefinitionVisitor;
import org.mule.runtime.config.spring.dsl.spring.CommonBeanDefinitionCreator;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.dsl.api.component.AttributeDefinitionVisitor;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;

public class MinimalApplicationModelGenerator {
    private final ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry;
    private final ApplicationModel applicationModel;

    public MinimalApplicationModelGenerator(ApplicationModel applicationModel, ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry) {
        this.applicationModel = applicationModel;
        this.applicationModel.resolveComponentTypes();
        this.componentBuildingDefinitionRegistry = componentBuildingDefinitionRegistry;
    }

    public ApplicationModel getMinimalModelByPath(String componentPath) {
        String[] parts = componentPath.split("/");
        String flowName = parts[0];
        ComponentModel flowModel = this.findRequiredComponentModel(flowName);
        this.filterFlowModelParts(flowModel, parts);
        return this.getMinimalModelByName(flowModel.getNameAttribute());
    }

    public ApplicationModel getMinimalModelByName(String name) {
        ComponentModel requestedComponentModel = this.findRequiredComponentModel(name);
        Set<String> otherRequiredGlobalComponents = this.resolveComponentDependencies(requestedComponentModel);
        otherRequiredGlobalComponents.add(name);
        Set<String> allRequiredComponentModels = this.findComponentModelsDependencies(otherRequiredGlobalComponents);
        Iterator<ComponentModel> iterator = this.applicationModel.getRootComponentModel().getInnerComponents().iterator();
        while (iterator.hasNext()) {
            ComponentModel componentModel = iterator.next();
            if (componentModel.getNameAttribute() != null && allRequiredComponentModels.contains(componentModel.getNameAttribute())) continue;
            iterator.remove();
        }
        return this.applicationModel;
    }

    private ComponentModel filterFlowModelParts(ComponentModel flowModel, String[] parts) {
        ComponentModel currentLevelModel = flowModel;
        block6: for (int i = 1; i < parts.length; ++i) {
            String part;
            switch (part = parts[i]) {
                case "source": {
                    ComponentModel sourceComponentModel = flowModel.getInnerComponents().get(0);
                    Preconditions.checkState((boolean)CommonBeanDefinitionCreator.areMatchingTypes(MessageSource.class, sourceComponentModel.getType()), (String)String.format("Flow path is pointing to the message source of flow %s but it seems that the flow does not have a message source, component identifier of first element is %s", flowModel.getNameAttribute(), sourceComponentModel.getIdentifier()));
                    Iterator<ComponentModel> iterator = flowModel.getInnerComponents().iterator();
                    iterator.next();
                    while (iterator.hasNext()) {
                        iterator.next();
                        iterator.remove();
                    }
                    continue block6;
                }
                default: {
                    int selectedPath = Integer.parseInt(part);
                    List<ComponentModel> innerComponents = currentLevelModel.getInnerComponents();
                    Iterator<ComponentModel> iterator = innerComponents.iterator();
                    int currentElement = 0;
                    while (iterator.hasNext()) {
                        ComponentModel childComponentModel = iterator.next();
                        if (childComponentModel.getType() != null && CommonBeanDefinitionCreator.areMatchingTypes(Processor.class, childComponentModel.getType())) {
                            if (currentElement != selectedPath) {
                                iterator.remove();
                            } else {
                                currentLevelModel = childComponentModel;
                            }
                            ++currentElement;
                            continue;
                        }
                        iterator.remove();
                    }
                    break block3;
                }
            }
        }
        return flowModel;
    }

    private ComponentModel findRequiredComponentModel(String name) {
        return this.applicationModel.findNamedComponent(name).orElseThrow(() -> new NoSuchComponentModelException(I18nMessageFactory.createStaticMessage((String)("No named component with name " + name))));
    }

    private Set<String> findComponentModelsDependencies(Set<String> componentModelNames) {
        Set<String> componentsToSearchDependencies = componentModelNames;
        HashSet<String> foundDependencies = new HashSet<String>();
        HashSet<String> alreadySearchedDependencies = new HashSet<String>();
        do {
            componentsToSearchDependencies.addAll(foundDependencies);
            for (String componentModelName : componentsToSearchDependencies) {
                if (alreadySearchedDependencies.contains(componentModelName)) continue;
                alreadySearchedDependencies.add(componentModelName);
                foundDependencies.addAll(this.resolveComponentDependencies(this.findRequiredComponentModel(componentModelName)));
            }
            foundDependencies.addAll(componentModelNames);
        } while (!foundDependencies.containsAll(componentsToSearchDependencies));
        return foundDependencies;
    }

    private Set<String> resolveComponentDependencies(ComponentModel requestedComponentModel) {
        HashSet<String> otherDependencies = new HashSet<String>();
        requestedComponentModel.getInnerComponents().stream().forEach(childComponent -> otherDependencies.addAll(this.resolveComponentDependencies((ComponentModel)childComponent)));
        final HashSet<String> parametersReferencingDependencies = new HashSet<String>();
        parametersReferencingDependencies.add("config-ref");
        ComponentBuildingDefinition buildingDefinition = this.componentBuildingDefinitionRegistry.getBuildingDefinition(requestedComponentModel.getIdentifier()).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("No component building definition for component " + requestedComponentModel.getIdentifier()))));
        buildingDefinition.getAttributesDefinitions().stream().forEach(attributeDefinition -> attributeDefinition.accept((AttributeDefinitionVisitor)new AbstractAttributeDefinitionVisitor(){

            @Override
            public void onReferenceSimpleParameter(String reference) {
                parametersReferencingDependencies.add(reference);
            }
        }));
        for (String parametersReferencingDependency : parametersReferencingDependencies) {
            if (!requestedComponentModel.getParameters().containsKey(parametersReferencingDependency)) continue;
            otherDependencies.add(requestedComponentModel.getParameters().get(parametersReferencingDependency));
        }
        return otherDependencies;
    }
}

