/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.dsl.model;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.config.spring.dsl.model.DslElementModel;
import org.mule.runtime.config.spring.dsl.model.XmlDslElementModelConverter;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultXmlDslElementModelConverter
implements XmlDslElementModelConverter {
    private static final List<String> INFRASTRUCTURE_NAMES = Arrays.asList("config-ref", "name", "pooling-profile", "reconnect", "reconnect-forever", "redelivery-policy", "context", "tlsContext", "poolingProfile", "reconnectionStrategy", "redeliveryPolicy", "target");
    private final Document doc;

    DefaultXmlDslElementModelConverter(Document owner) {
        this.doc = owner;
    }

    @Override
    public Element asXml(DslElementModel elementModel) {
        Object model = elementModel.getModel();
        Preconditions.checkArgument((model instanceof ConfigurationModel || model instanceof ComponentModel ? 1 : 0) != 0, (String)"The element must be either a ConfigurationModel or a ComponentModel");
        DslElementSyntax dsl = elementModel.getDsl();
        Element componentRoot = this.createElement(dsl);
        if (!elementModel.getConfiguration().isPresent()) {
            this.writeDslStructure(componentRoot, dsl);
        } else {
            this.writeApplicationElement(componentRoot, elementModel, componentRoot);
        }
        return componentRoot;
    }

    private void writeApplicationElement(Element element, DslElementModel<?> elementModel, Element parentNode) {
        this.populateInfrastructureConfiguration(element, elementModel);
        if (elementModel.getContainedElements().isEmpty() && elementModel.getValue().isPresent()) {
            this.setTextContentElement(element, elementModel, parentNode);
            return;
        }
        elementModel.getContainedElements().stream().filter(c -> !this.isInfrastructure((DslElementModel)c)).forEach(inner -> {
            DslElementSyntax innerDsl = inner.getDsl();
            Reference configured = new Reference((Object)false);
            if (innerDsl.supportsAttributeDeclaration() && inner.getValue().isPresent()) {
                this.getCustomizedValue((DslElementModel)inner).ifPresent(value -> {
                    configured.set((Object)true);
                    element.setAttribute(innerDsl.getAttributeName(), (String)value);
                });
            }
            if (!((Boolean)configured.get()).booleanValue() && innerDsl.supportsChildDeclaration()) {
                Element childElement = this.createElement(innerDsl);
                this.writeApplicationElement(childElement, (DslElementModel<?>)inner, element);
            }
        });
        if (parentNode != element) {
            parentNode.appendChild(element);
        }
    }

    private void setTextContentElement(Element element, DslElementModel<?> elementModel, Element parentNode) {
        this.getCustomizedValue(elementModel).ifPresent(value -> {
            if (elementModel.getDsl().supportsChildDeclaration() && !elementModel.getDsl().supportsAttributeDeclaration()) {
                element.setTextContent((String)value);
                if (parentNode != element) {
                    parentNode.appendChild(element);
                }
            } else {
                parentNode.setAttribute(elementModel.getDsl().getAttributeName(), (String)value);
            }
        });
    }

    private Optional<String> getCustomizedValue(DslElementModel elementModel) {
        Optional<String> defaultValue = this.getDefaultValue(elementModel.getDsl().getAttributeName(), elementModel.getModel());
        String value = elementModel.getValue().get();
        if (!defaultValue.isPresent() || !defaultValue.get().equals(value)) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    private Optional<String> getDefaultValue(String name, Object model) {
        if (model instanceof ParameterModel) {
            return ExtensionModelUtils.getDefaultValue((ParameterModel)((ParameterModel)model));
        }
        return ExtensionModelUtils.getDefaultValue((String)name, (MetadataType)((MetadataType)model));
    }

    private Element writeDslStructure(Element element, DslElementSyntax dsl) {
        dsl.getAttributes().forEach(a -> element.setAttribute(a.getAttributeName(), ""));
        dsl.getChilds().forEach(current -> {
            Element childElement = this.createElement((DslElementSyntax)current);
            element.appendChild(this.writeDslStructure(childElement, (DslElementSyntax)current));
        });
        dsl.getGenerics().forEach((type, generic) -> {
            Element childElement = this.createElement((DslElementSyntax)generic);
            element.appendChild(this.writeDslStructure(childElement, (DslElementSyntax)generic));
        });
        return element;
    }

    private Element createElement(DslElementSyntax dsl) {
        this.doc.getDocumentElement().setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + dsl.getNamespace(), dsl.getNamespaceUri());
        return this.doc.createElementNS(dsl.getNamespaceUri(), dsl.getNamespace() + ":" + dsl.getElementName());
    }

    private boolean isInfrastructure(DslElementModel elementModel) {
        Object model = elementModel.getModel();
        if (model instanceof ParameterModel) {
            return ExtensionModelUtils.isInfrastructure((ParameterModel)((ParameterModel)model));
        }
        return INFRASTRUCTURE_NAMES.contains(elementModel.getDsl().getAttributeName()) || INFRASTRUCTURE_NAMES.contains(elementModel.getDsl().getElementName());
    }

    private void populateInfrastructureConfiguration(Element element, DslElementModel<?> elementModel) {
        elementModel.getContainedElements().stream().filter(this::isInfrastructure).forEach(e -> {
            if (e.getContainedElements().isEmpty() && e.getValue().isPresent()) {
                element.setAttribute(e.getDsl().getAttributeName(), e.getValue().get());
            } else {
                Optional<ComponentConfiguration> config = e.getConfiguration();
                config.ifPresent(c -> {
                    if (c.getIdentifier().getNamespace().contains("tls")) {
                        element.appendChild(this.createTLS((ComponentConfiguration)c));
                    } else {
                        element.appendChild(this.clone((ComponentConfiguration)c));
                    }
                });
            }
        });
        elementModel.getConfiguration().ifPresent(c -> Stream.of("name", "config-ref").forEach(name -> {
            String value = (String)c.getParameters().get(name);
            if (!StringUtils.isBlank((String)value)) {
                element.setAttribute((String)name, value);
            }
        }));
    }

    private Element createTLS(ComponentConfiguration config) {
        String namespaceURI = "http://www.mulesoft.org/schema/mule/tls";
        this.doc.getDocumentElement().setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:tls", namespaceURI);
        Element nested = this.doc.createElementNS(namespaceURI, "tls:" + config.getIdentifier().getName());
        config.getParameters().forEach(nested::setAttribute);
        config.getNestedComponents().forEach(inner -> nested.appendChild(this.createTLS((ComponentConfiguration)inner)));
        return nested;
    }

    private Element clone(ComponentConfiguration config) {
        Element element = this.doc.createElement(config.getIdentifier().getName());
        config.getParameters().forEach(element::setAttribute);
        config.getNestedComponents().forEach(nested -> element.appendChild(this.clone((ComponentConfiguration)nested)));
        return element;
    }
}

