/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.parsers.processors;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.mule.runtime.config.spring.parsers.PreProcessor;
import org.mule.runtime.config.spring.parsers.assembly.configuration.PropertyConfiguration;
import org.mule.runtime.config.spring.util.SpringXMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class RequireAttribute
implements PreProcessor {
    private Set required;

    public RequireAttribute(String required) {
        this(new String[]{required});
    }

    public RequireAttribute(String[] required) {
        this.required = new HashSet<String>(Arrays.asList(required));
    }

    @Override
    public void preProcess(PropertyConfiguration config, Element element) {
        NamedNodeMap attributes = element.getAttributes();
        for (String name : this.required) {
            boolean found = false;
            for (int i = 0; i < attributes.getLength() && !found; ++i) {
                String alias = SpringXMLUtils.attributeName((Attr)((Attr)attributes.item(i)));
                found = name.equals(alias);
            }
            if (found) continue;
            throw new RequireAttributeException("Attribute " + name + " is required here.");
        }
    }

    public static class RequireAttributeException
    extends IllegalStateException {
        public RequireAttributeException(String message) {
            super(message);
        }
    }
}

