/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.dsl.spring;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.config.spring.dsl.spring.ConfigurableInstanceFactory;
import org.mule.runtime.config.spring.dsl.spring.ObjectFactoryCommonConfigurator;
import org.mule.runtime.core.AbstractAnnotatedObject;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.dsl.api.component.ObjectFactory;

public class ConfigurableObjectFactory<T>
extends AbstractAnnotatedObject
implements ObjectFactory<T> {
    @Inject
    private MuleContext muleContext;
    private Class<ObjectFactoryCommonConfigurator> commonConfiguratorType;
    private ConfigurableInstanceFactory factory;
    private Map<String, Object> parameters = new HashMap<String, Object>();

    public T getObject() throws Exception {
        Object instance = this.factory.createInstance(this.parameters);
        if (instance instanceof AnnotatedObject) {
            ((AnnotatedObject)instance).setAnnotations(this.getAnnotations());
        }
        if (this.commonConfiguratorType != null) {
            ObjectFactoryCommonConfigurator commonConfigurator = (ObjectFactoryCommonConfigurator)ClassUtils.instanciateClass(this.commonConfiguratorType, (Object[])new Object[0]);
            commonConfigurator.configure(instance, this.parameters);
        }
        if (instance instanceof MuleContextAware) {
            ((MuleContextAware)instance).setMuleContext(this.muleContext);
        }
        return instance;
    }

    public void setCommonConfiguratorType(Class<ObjectFactoryCommonConfigurator> commonConfiguratorType) {
        this.commonConfiguratorType = commonConfiguratorType;
    }

    public void setFactory(ConfigurableInstanceFactory factory) {
        this.factory = factory;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }
}

