/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.dsl.model;

import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.mule.runtime.config.spring.dsl.model.ApplicationModel;
import org.mule.runtime.config.spring.dsl.model.ComponentModel;
import org.mule.runtime.config.spring.dsl.processor.ConfigLine;
import org.mule.runtime.config.spring.dsl.processor.SimpleConfigAttribute;
import org.mule.runtime.config.spring.dsl.processor.xml.XmlCustomAttributeHandler;
import org.mule.runtime.dsl.api.component.ComponentIdentifier;
import org.springframework.util.PropertyPlaceholderHelper;

public class ComponentModelReader {
    private PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("${", "}");
    private Properties applicationProperties;

    public ComponentModelReader(Properties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public ComponentModel extractComponentDefinitionModel(ConfigLine configLine, String configFileName) {
        String namespace = configLine.getNamespace() == null ? "mule" : configLine.getNamespace();
        ComponentModel.Builder builder = new ComponentModel.Builder().setIdentifier(new ComponentIdentifier.Builder().withNamespace(namespace).withName(configLine.getIdentifier()).build()).setTextContent(configLine.getTextContent());
        XmlCustomAttributeHandler.to(builder).addNode(XmlCustomAttributeHandler.from(configLine).getNode()).addConfigFileName(configFileName);
        for (SimpleConfigAttribute simpleConfigAttribute : configLine.getConfigAttributes().values()) {
            builder.addParameter(simpleConfigAttribute.getName(), this.resolveValueIfIsPlaceHolder(simpleConfigAttribute.getValue()), simpleConfigAttribute.isValueFromSchema());
        }
        List componentModels = configLine.getChildren().stream().map(childConfigLine -> this.extractComponentDefinitionModel((ConfigLine)childConfigLine, configFileName)).collect(Collectors.toList());
        componentModels.stream().forEach(componentDefinitionModel -> {
            String value;
            if (ApplicationModel.SPRING_PROPERTY_IDENTIFIER.equals((Object)componentDefinitionModel.getIdentifier()) && (value = componentDefinitionModel.getParameters().get("value")) != null) {
                builder.addParameter(componentDefinitionModel.getNameAttribute(), this.resolveValueIfIsPlaceHolder(value), false);
            }
            builder.addChildComponentModel((ComponentModel)componentDefinitionModel);
        });
        ConfigLine parent = configLine.getParent();
        if (parent != null && this.isConfigurationTopComponent(parent)) {
            builder.markAsRootComponent();
        }
        ComponentModel componentModel = builder.build();
        for (ComponentModel innerComponentModel : componentModel.getInnerComponents()) {
            innerComponentModel.setParent(componentModel);
        }
        return componentModel;
    }

    private String resolveValueIfIsPlaceHolder(String value) {
        return this.propertyPlaceholderHelper.replacePlaceholders(value, this.applicationProperties);
    }

    private boolean isConfigurationTopComponent(ConfigLine parent) {
        return parent.getIdentifier().equals("mule") || parent.getIdentifier().equals("mule-domain") || parent.getIdentifier().equals("policy");
    }
}

