/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.config.spring.DefaultObjectSerializerFactoryBean;
import org.mule.runtime.config.spring.NotificationConfig;
import org.mule.runtime.config.spring.OptionalObjectsController;
import org.mule.runtime.config.spring.ServerNotificationManagerConfigurator;
import org.mule.runtime.config.spring.SpringRegistryBootstrap;
import org.mule.runtime.config.spring.factories.ConstantFactoryBean;
import org.mule.runtime.config.spring.factories.ExtensionManagerFactoryBean;
import org.mule.runtime.config.spring.factories.TransactionManagerFactoryBean;
import org.mule.runtime.config.spring.processors.MuleObjectNameProcessor;
import org.mule.runtime.config.spring.processors.ParentContextPropertyPlaceholderProcessor;
import org.mule.runtime.config.spring.processors.PropertyPlaceholderProcessor;
import org.mule.runtime.core.DynamicDataTypeConversionResolver;
import org.mule.runtime.core.api.CustomService;
import org.mule.runtime.core.api.CustomizationService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.notification.ConnectionNotificationListener;
import org.mule.runtime.core.api.context.notification.CustomNotificationListener;
import org.mule.runtime.core.api.context.notification.ExceptionNotificationListener;
import org.mule.runtime.core.api.context.notification.ManagementNotificationListener;
import org.mule.runtime.core.api.context.notification.MuleContextNotificationListener;
import org.mule.runtime.core.api.context.notification.RegistryNotificationListener;
import org.mule.runtime.core.api.context.notification.SecurityNotificationListener;
import org.mule.runtime.core.api.context.notification.TransactionNotificationListener;
import org.mule.runtime.core.config.ChainedThreadingProfile;
import org.mule.runtime.core.config.bootstrap.ArtifactType;
import org.mule.runtime.core.config.factories.HostNameFactory;
import org.mule.runtime.core.connectivity.DefaultConnectivityTestingService;
import org.mule.runtime.core.connector.MuleConnectorOperationLocator;
import org.mule.runtime.core.context.notification.ConnectionNotification;
import org.mule.runtime.core.context.notification.CustomNotification;
import org.mule.runtime.core.context.notification.ExceptionNotification;
import org.mule.runtime.core.context.notification.ManagementNotification;
import org.mule.runtime.core.context.notification.MessageProcessingFlowTraceManager;
import org.mule.runtime.core.context.notification.MuleContextNotification;
import org.mule.runtime.core.context.notification.RegistryNotification;
import org.mule.runtime.core.context.notification.SecurityNotification;
import org.mule.runtime.core.context.notification.TransactionNotification;
import org.mule.runtime.core.el.DefaultExpressionManager;
import org.mule.runtime.core.el.mvel.MVELExpressionLanguage;
import org.mule.runtime.core.exception.MessagingExceptionLocationProvider;
import org.mule.runtime.core.execution.MuleMessageProcessingManager;
import org.mule.runtime.core.internal.connection.DefaultConnectionManager;
import org.mule.runtime.core.internal.locator.DefaultConfigurationComponentLocator;
import org.mule.runtime.core.internal.metadata.MuleMetadataService;
import org.mule.runtime.core.management.stats.DefaultProcessingTimeWatcher;
import org.mule.runtime.core.policy.DefaultPolicyManager;
import org.mule.runtime.core.policy.DefaultPolicyStateHandler;
import org.mule.runtime.core.retry.policies.NoRetryPolicyTemplate;
import org.mule.runtime.core.security.MuleSecurityManager;
import org.mule.runtime.core.time.TimeSupplier;
import org.mule.runtime.core.util.DefaultStreamCloserService;
import org.mule.runtime.core.util.lock.MuleLockFactory;
import org.mule.runtime.core.util.lock.SingleServerLockProvider;
import org.mule.runtime.core.util.queue.DelegateQueueManager;
import org.mule.runtime.core.util.store.DefaultObjectStoreFactoryBean;
import org.mule.runtime.core.util.store.MuleObjectStoreManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

class SpringMuleContextServiceConfigurator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringMuleContextServiceConfigurator.class);
    private final MuleContext muleContext;
    private final ArtifactType artifactType;
    private final OptionalObjectsController optionalObjectsController;
    private final CustomizationService customizationService;
    private final BeanDefinitionRegistry beanDefinitionRegistry;
    private static final ImmutableSet<String> APPLICATION_ONLY_SERVICES = ImmutableSet.builder().add((Object)"_muleSecurityManager").add((Object)"_muleMessageProcessingManager").add((Object)"_muleStreamCloserService").add((Object)"_converterResolver").add((Object)"_muleLockFactory").add((Object)"_muleLockProvider").add((Object)"_muleProcessingTimeWatcher").add((Object)"_muleConnectorMessageProcessorLocator").add((Object)"_muleExceptionLocationProvider").add((Object)"_muleMessageProcessingFlowTraceManager").build();
    private static final ImmutableMap<String, String> OBJECT_STORE_NAME_TO_LOCAL_OBJECT_STORE_NAME = ImmutableMap.builder().put((Object)"_defaultInMemoryObjectStore", (Object)"_localInMemoryObjectStore").put((Object)"_defaultPersistentObjectStore", (Object)"_localPersistentObjectStore").put((Object)"_defaultUserObjectStore", (Object)"_localUserObjectStore").put((Object)"_defaultTransientUserObjectStore", (Object)"_localTransientUserObjectStore").build();
    private final ImmutableMap<String, BeanDefinition> defaultContextServices = ImmutableMap.builder().put((Object)"_muleTransactionManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(TransactionManagerFactoryBean.class)).put((Object)"_defaultRetryPolicyTemplate", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(NoRetryPolicyTemplate.class)).put((Object)"_muleExpressionLanguage", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(MVELExpressionLanguage.class)).put((Object)"_muleExpressionManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultExpressionManager.class)).put((Object)"_muleExtensionManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(ExtensionManagerFactoryBean.class)).put((Object)"_muleTimeSupplier", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(TimeSupplier.class)).put((Object)"_muleConnectionManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultConnectionManager.class)).put((Object)"_muleMetadataService", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(MuleMetadataService.class)).put((Object)"_muleObjectNameProcessor", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(MuleObjectNameProcessor.class)).put((Object)"_mulePolicyManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultPolicyManager.class)).put((Object)"_mulePolicyStateHandler", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultPolicyStateHandler.class)).put((Object)"_muleDefaultObjectSerializer", (Object)SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(DefaultObjectSerializerFactoryBean.class).addDependsOn("_muleConfiguration").getBeanDefinition()).put((Object)"_muleNotificationManager", (Object)SpringMuleContextServiceConfigurator.createNotificationManagerBeanDefinition()).put((Object)"_defaultInMemoryObjectStore", (Object)SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(ConstantFactoryBean.class).addConstructorArgReference("_localInMemoryObjectStore").getBeanDefinition()).put((Object)"_localInMemoryObjectStore", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultObjectStoreFactoryBean.class, "createDefaultInMemoryObjectStore")).put((Object)"_defaultPersistentObjectStore", (Object)SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(ConstantFactoryBean.class).addConstructorArgReference("_localPersistentObjectStore").getBeanDefinition()).put((Object)"_localPersistentObjectStore", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultObjectStoreFactoryBean.class, "createDefaultPersistentObjectStore")).put((Object)"_defaultUserObjectStore", (Object)SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(ConstantFactoryBean.class).addConstructorArgReference("_localUserObjectStore").getBeanDefinition()).put((Object)"_localUserObjectStore", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultObjectStoreFactoryBean.class, "createDefaultUserObjectStore")).put((Object)"_defaultTransientUserObjectStore", (Object)SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(ConstantFactoryBean.class).addConstructorArgReference("_localTransientUserObjectStore").getBeanDefinition()).put((Object)"_localTransientUserObjectStore", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultObjectStoreFactoryBean.class, "createDefaultUserTransientObjectStore")).put((Object)"_muleObjectStoreManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(MuleObjectStoreManager.class)).put((Object)"_defaultPersistentQueueStore", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultObjectStoreFactoryBean.class, "createDefaultPersistentQueueStore")).put((Object)"_defaultInMemoryQueueStore", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultObjectStoreFactoryBean.class, "createDefaultInMemoryQueueStore")).put((Object)"_muleQueueManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(ConstantFactoryBean.class).addConstructorArgReference("_localQueueManager").getBeanDefinition()).put((Object)"_localQueueManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DelegateQueueManager.class)).put((Object)"_defaultThreadingProfile", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(ChainedThreadingProfile.class)).put((Object)"_defaultMessageDispatcherThreadingProfile", (Object)SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(ChainedThreadingProfile.class).addConstructorArgReference("_defaultThreadingProfile").getBeanDefinition()).put((Object)"_defaultMessageRequesterThreadingProfile", (Object)SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(ChainedThreadingProfile.class).addConstructorArgReference("_defaultThreadingProfile").getBeanDefinition()).put((Object)"_defaultMessageReceiverThreadingProfile", (Object)SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(ChainedThreadingProfile.class).addConstructorArgReference("_defaultThreadingProfile").getBeanDefinition()).put((Object)"_muleParentContextPropertyPlaceholderProcessor", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(ParentContextPropertyPlaceholderProcessor.class)).put((Object)"_mulePropertyPlaceholderProcessor", (Object)SpringMuleContextServiceConfigurator.createMulePropertyPlaceholderBeanDefinition()).put((Object)"_muleSecurityManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(MuleSecurityManager.class)).put((Object)"_muleMessageProcessingManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(MuleMessageProcessingManager.class)).put((Object)"_muleStreamCloserService", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultStreamCloserService.class)).put((Object)"_converterResolver", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DynamicDataTypeConversionResolver.class)).put((Object)"_muleLockFactory", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(MuleLockFactory.class)).put((Object)"_muleLockProvider", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(SingleServerLockProvider.class)).put((Object)"_muleProcessingTimeWatcher", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultProcessingTimeWatcher.class)).put((Object)"_muleConnectorMessageProcessorLocator", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(MuleConnectorOperationLocator.class)).put((Object)"_muleExceptionLocationProvider", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(MessagingExceptionLocationProvider.class)).put((Object)"_muleMessageProcessingFlowTraceManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(MessageProcessingFlowTraceManager.class)).put((Object)"_muleConnectivityTestingService", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultConnectivityTestingService.class)).put((Object)"_muleConfigurationComponentLocator", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultConfigurationComponentLocator.class)).build();

    public SpringMuleContextServiceConfigurator(MuleContext muleContext, ArtifactType artifactType, OptionalObjectsController optionalObjectsController, BeanDefinitionRegistry beanDefinitionRegistry) {
        this.muleContext = muleContext;
        this.customizationService = muleContext.getCustomizationService();
        this.artifactType = artifactType;
        this.optionalObjectsController = optionalObjectsController;
        this.beanDefinitionRegistry = beanDefinitionRegistry;
    }

    void createArtifactServices() {
        this.defaultContextServices.entrySet().stream().filter(service -> !APPLICATION_ONLY_SERVICES.contains(service.getKey()) || this.artifactType.equals((Object)ArtifactType.APP)).forEach(service -> this.registerBeanDefinition((String)service.getKey(), (BeanDefinition)service.getValue()));
        this.createBootstrapBeanDefinitions();
        this.createLocalObjectStoreBeanDefinitions();
        this.createQueueStoreBeanDefinitions();
        this.createQueueManagerBeanDefinitions();
        this.createCustomServices();
    }

    private void createCustomServices() {
        Map customServices = this.customizationService.getCustomServices();
        for (String serviceName : customServices.keySet()) {
            if (this.beanDefinitionRegistry.containsBeanDefinition(serviceName)) {
                throw new IllegalStateException("There is already a bean definition registered with key: " + serviceName);
            }
            CustomService customService = (CustomService)customServices.get(serviceName);
            BeanDefinition beanDefinition = this.getCustomServiceBeanDefinition(customService);
            this.registerBeanDefinition(serviceName, beanDefinition);
        }
    }

    private void registerBeanDefinition(String serviceId, BeanDefinition defaultBeanDefinition) {
        BeanDefinition beanDefinition = defaultBeanDefinition;
        Optional customServiceOptional = this.customizationService.getOverriddenService(serviceId);
        if (customServiceOptional.isPresent()) {
            beanDefinition = this.getCustomServiceBeanDefinition((CustomService)customServiceOptional.get());
        }
        this.beanDefinitionRegistry.registerBeanDefinition(serviceId, beanDefinition);
    }

    private BeanDefinition getCustomServiceBeanDefinition(CustomService customService) {
        AbstractBeanDefinition beanDefinition;
        Optional customServiceClass = customService.getServiceClass();
        Optional customServiceImpl = customService.getServiceImpl();
        if (customServiceClass.isPresent()) {
            beanDefinition = SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder((Class)customServiceClass.get()).getBeanDefinition();
        } else if (customServiceImpl.isPresent()) {
            beanDefinition = SpringMuleContextServiceConfigurator.getConstantObjectBeanDefinition(customServiceImpl.get());
        } else {
            throw new IllegalStateException("A custom service must define a service class or instance");
        }
        return beanDefinition;
    }

    private void createQueueStoreBeanDefinitions() {
        this.beanDefinitionRegistry.registerAlias("_defaultPersistentQueueStore", "_fileQueueStore");
        this.beanDefinitionRegistry.registerAlias("_defaultInMemoryQueueStore", "_simpleMemoryQueueStore");
    }

    private static BeanDefinition createMulePropertyPlaceholderBeanDefinition() {
        HashMap<String, HostNameFactory> factories = new HashMap<String, HostNameFactory>();
        factories.put("hostname", new HostNameFactory());
        BeanDefinitionBuilder mulePropertyPlaceholderProcessor = SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(PropertyPlaceholderProcessor.class);
        return mulePropertyPlaceholderProcessor.addPropertyValue("factories", factories).addPropertyValue("ignoreUnresolvablePlaceholders", (Object)true).getBeanDefinition();
    }

    private void createQueueManagerBeanDefinitions() {
        if (this.customizationService.getOverriddenService("_muleQueueManager").isPresent()) {
            this.registerBeanDefinition("_localQueueManager", (BeanDefinition)SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(ConstantFactoryBean.class).addConstructorArgReference("_localQueueManager").getBeanDefinition());
        } else {
            this.registerBeanDefinition("_localQueueManager", SpringMuleContextServiceConfigurator.getBeanDefinition(DelegateQueueManager.class));
        }
    }

    private void createLocalObjectStoreBeanDefinitions() {
        AtomicBoolean anyBaseStoreWasRedefined = new AtomicBoolean(false);
        OBJECT_STORE_NAME_TO_LOCAL_OBJECT_STORE_NAME.entrySet().forEach(objectStoreLocal -> this.customizationService.getOverriddenService((String)objectStoreLocal.getKey()).ifPresent(customService -> {
            this.beanDefinitionRegistry.registerAlias((String)objectStoreLocal.getKey(), (String)objectStoreLocal.getValue());
            customService.getServiceClass().ifPresent(serviceClass -> {
                anyBaseStoreWasRedefined.set(true);
                this.beanDefinitionRegistry.registerBeanDefinition((String)objectStoreLocal.getValue(), (BeanDefinition)this.defaultContextServices.get(objectStoreLocal.getKey()));
            });
        }));
        if (anyBaseStoreWasRedefined.get()) {
            this.beanDefinitionRegistry.registerBeanDefinition("_localObjectStoreManager", (BeanDefinition)SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(MuleObjectStoreManager.class).addPropertyValue("basePersistentStoreKey", (Object)new RuntimeBeanReference("_defaultPersistentObjectStore")).addPropertyValue("baseTransientStoreKey", (Object)new RuntimeBeanReference("_defaultInMemoryObjectStore")).addPropertyValue("basePersistentUserStoreKey", (Object)new RuntimeBeanReference("_localUserObjectStore")).addPropertyValue("baseTransientUserStoreKey", (Object)new RuntimeBeanReference("_localTransientUserObjectStore")).getBeanDefinition());
        } else {
            this.beanDefinitionRegistry.registerAlias("_muleObjectStoreManager", "_localObjectStoreManager");
        }
    }

    private static BeanDefinition createNotificationManagerBeanDefinition() {
        ArrayList<NotificationConfig> defaultNotifications = new ArrayList<NotificationConfig>();
        defaultNotifications.add(new NotificationConfig(MuleContextNotificationListener.class, MuleContextNotification.class));
        defaultNotifications.add(new NotificationConfig(SecurityNotificationListener.class, SecurityNotification.class));
        defaultNotifications.add(new NotificationConfig(ManagementNotificationListener.class, ManagementNotification.class));
        defaultNotifications.add(new NotificationConfig(ConnectionNotificationListener.class, ConnectionNotification.class));
        defaultNotifications.add(new NotificationConfig(RegistryNotificationListener.class, RegistryNotification.class));
        defaultNotifications.add(new NotificationConfig(CustomNotificationListener.class, CustomNotification.class));
        defaultNotifications.add(new NotificationConfig(ExceptionNotificationListener.class, ExceptionNotification.class));
        defaultNotifications.add(new NotificationConfig(TransactionNotificationListener.class, TransactionNotification.class));
        return SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(ServerNotificationManagerConfigurator.class).addPropertyValue("enabledNotifications", defaultNotifications).getBeanDefinition();
    }

    private void createBootstrapBeanDefinitions() {
        try {
            SpringRegistryBootstrap springRegistryBootstrap = new SpringRegistryBootstrap(this.artifactType, this.muleContext, this.optionalObjectsController, this.beanDefinitionRegistry);
            springRegistryBootstrap.initialise();
        }
        catch (InitialisationException e) {
            throw new RuntimeException(e);
        }
    }

    private static BeanDefinition getBeanDefinition(Class<?> beanType) {
        return SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(beanType).getBeanDefinition();
    }

    private static BeanDefinition getConstantObjectBeanDefinition(Object impl) {
        return SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(ConstantFactoryBean.class).addConstructorArgValue(impl).getBeanDefinition();
    }

    private static BeanDefinitionBuilder getBeanDefinitionBuilder(Class<?> beanType) {
        return BeanDefinitionBuilder.genericBeanDefinition(beanType);
    }

    private static BeanDefinition getBeanDefinition(Class<?> beanType, String factoryMethodName) {
        return SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(beanType).setFactoryMethod(factoryMethodName).getBeanDefinition();
    }
}

