/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring;

import java.util.List;
import java.util.Map;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.config.spring.LazyComponentInitializer;
import org.mule.runtime.config.spring.LazyConnectivityTestingService;
import org.mule.runtime.config.spring.LazyMetadataService;
import org.mule.runtime.config.spring.MuleArtifactContext;
import org.mule.runtime.config.spring.OptionalObjectsController;
import org.mule.runtime.config.spring.dsl.model.ApplicationModel;
import org.mule.runtime.config.spring.dsl.model.MinimalApplicationModelGenerator;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connectivity.ConnectivityTestingService;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.config.ConfigResource;
import org.mule.runtime.core.config.bootstrap.ArtifactType;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.dsl.api.config.ArtifactConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class LazyMuleArtifactContext
extends MuleArtifactContext
implements LazyComponentInitializer {
    private ConnectivityTestingService lazyConnectivityTestingService;
    private MetadataService metadataService;

    public LazyMuleArtifactContext(MuleContext muleContext, ConfigResource[] artifactConfigResources, ArtifactConfiguration artifactConfiguration, OptionalObjectsController optionalObjectsController, Map<String, String> artifactProperties, ArtifactType artifactType) throws BeansException {
        super(muleContext, artifactConfigResources, artifactConfiguration, optionalObjectsController, artifactProperties, artifactType);
    }

    private void createComponents(DefaultListableBeanFactory beanFactory, ApplicationModel applicationModel, boolean mustBeRoot) {
        this.applyLifecycle(super.createApplicationComponents(beanFactory, applicationModel, mustBeRoot));
    }

    private void applyLifecycle(List<String> createdComponentModels) {
        Object object;
        if (this.muleContext.isInitialised()) {
            for (String createdComponentModelName : createdComponentModels) {
                object = this.muleContext.getRegistry().get(createdComponentModelName);
                try {
                    LifecycleUtils.initialiseIfNeeded((Object)object, (boolean)true, (MuleContext)this.muleContext);
                }
                catch (InitialisationException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.muleContext.isStarted()) {
            for (String createdComponentModelName : createdComponentModels) {
                object = this.muleContext.getRegistry().get(createdComponentModelName);
                try {
                    LifecycleUtils.startIfNeeded((Object)object);
                }
                catch (MuleException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    protected void createInitialApplicationComponents(DefaultListableBeanFactory beanFactory, BeanDefinitionReader beanDefinitionReader) {
        if (!this.useNewParsingMechanism) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not create mule application since lazy init is enabled but there are component in the configuration that are not parsed with the new mechanism " + this.getOldParsingMechanismComponentIdentifiers())));
        }
        this.createComponents(beanFactory, this.applicationModel, true);
    }

    @Override
    public void initializeComponent(String componentName) {
        ClassUtils.withContextClassLoader((ClassLoader)this.muleContext.getExecutionClassLoader(), () -> {
            if (this.muleContext.getRegistry().get(componentName) != null) {
                return;
            }
            MinimalApplicationModelGenerator minimalApplicationModelGenerator = new MinimalApplicationModelGenerator(this.applicationModel, this.componentBuildingDefinitionRegistry);
            ApplicationModel minimalApplicationModel = !componentName.contains("/") ? minimalApplicationModelGenerator.getMinimalModelByName(componentName) : minimalApplicationModelGenerator.getMinimalModelByPath(componentName);
            this.createComponents((DefaultListableBeanFactory)this.getBeanFactory(), minimalApplicationModel, false);
        });
    }

    @Override
    public ConnectivityTestingService getConnectivityTestingService() {
        if (this.lazyConnectivityTestingService == null) {
            this.lazyConnectivityTestingService = new LazyConnectivityTestingService(this, (ConnectivityTestingService)this.muleContext.getRegistry().get("_muleConnectivityTestingService"));
        }
        return this.lazyConnectivityTestingService;
    }

    @Override
    public MetadataService getMetadataService() {
        if (this.metadataService == null) {
            this.metadataService = new LazyMetadataService(this, (MetadataService)this.muleContext.getRegistry().get("_muleMetadataService"));
        }
        return this.metadataService;
    }
}

