/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.factories;

import java.util.List;
import org.mule.AbstractAnnotatedObject;
import org.mule.api.MuleContext;
import org.mule.api.NameableObject;
import org.mule.api.context.MuleContextAware;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorBuilder;
import org.mule.api.processor.ProcessingStrategy;
import org.mule.processor.AsyncDelegateMessageProcessor;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.springframework.beans.factory.FactoryBean;

public class AsyncMessageProcessorsFactoryBean
extends AbstractAnnotatedObject
implements FactoryBean,
MuleContextAware,
NameableObject {
    protected MuleContext muleContext;
    protected List messageProcessors;
    protected ProcessingStrategy processingStrategy;
    protected String name;

    public Class getObjectType() {
        return MessageProcessor.class;
    }

    public void setMessageProcessors(List messageProcessors) {
        this.messageProcessors = messageProcessors;
    }

    public Object getObject() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.setName("'async' child chain");
        for (Object processor : this.messageProcessors) {
            if (processor instanceof MessageProcessor) {
                builder.chain(new MessageProcessor[]{(MessageProcessor)processor});
                continue;
            }
            if (processor instanceof MessageProcessorBuilder) {
                builder.chain(new MessageProcessorBuilder[]{(MessageProcessorBuilder)processor});
                continue;
            }
            throw new IllegalArgumentException("MessageProcessorBuilder should only have MessageProcessor's or MessageProcessorBuilder's configured");
        }
        AsyncDelegateMessageProcessor delegate = new AsyncDelegateMessageProcessor((MessageProcessor)builder.build(), this.processingStrategy, this.name);
        delegate.setAnnotations(this.getAnnotations());
        return delegate;
    }

    public boolean isSingleton() {
        return false;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProcessingStrategy(ProcessingStrategy processingStrategy) {
        this.processingStrategy = processingStrategy;
    }
}

