/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.specific;

import org.mule.config.spring.parsers.assembly.BeanAssembler;
import org.mule.config.spring.parsers.assembly.BeanAssemblerFactory;
import org.mule.config.spring.parsers.assembly.DefaultBeanAssembler;
import org.mule.config.spring.parsers.assembly.configuration.PropertyConfiguration;
import org.mule.config.spring.parsers.collection.ChildMapEntryDefinitionParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;

public class ImportMapEntryDefinitionParser
extends ChildMapEntryDefinitionParser {
    public ImportMapEntryDefinitionParser(String mapName) {
        super(mapName);
        this.addAlias("name", "key");
        this.addAlias("class", "value");
        this.setBeanAssemblerFactory(new ImportMapEntryBeanAssemblerFactory());
    }

    private static class ImportMapEntryBeanAssembler
    extends DefaultBeanAssembler {
        public ImportMapEntryBeanAssembler(PropertyConfiguration beanConfig, BeanDefinitionBuilder bean, PropertyConfiguration targetConfig, BeanDefinition target) {
            super(beanConfig, bean, targetConfig, target);
        }

        @Override
        public void insertBeanInTarget(String oldName) {
            this.assertTargetPresent();
            MutablePropertyValues sourceProperties = this.bean.getRawBeanDefinition().getPropertyValues();
            String newName = ImportMapEntryBeanAssembler.bestGuessName(this.targetConfig, oldName, this.target.getBeanClassName());
            MutablePropertyValues targetProperties = this.target.getPropertyValues();
            PropertyValue pv = targetProperties.getPropertyValue(newName);
            ManagedMap oldValue = (ManagedMap)(null == pv ? null : pv.getValue());
            if (null == oldValue) {
                oldValue = new ManagedMap();
                pv = new PropertyValue(newName, (Object)oldValue);
                targetProperties.addPropertyValue(pv);
            }
            String importName = null;
            String importClassName = (String)sourceProperties.getPropertyValue("value").getValue();
            PropertyValue namePropertyValue = sourceProperties.getPropertyValue("key");
            importName = namePropertyValue != null ? (String)namePropertyValue.getValue() : importClassName.substring(importClassName.lastIndexOf(".") + 1, importClassName.length());
            oldValue.put((Object)importName, (Object)importClassName);
        }
    }

    private static class ImportMapEntryBeanAssemblerFactory
    implements BeanAssemblerFactory {
        private ImportMapEntryBeanAssemblerFactory() {
        }

        @Override
        public BeanAssembler newBeanAssembler(PropertyConfiguration beanConfig, BeanDefinitionBuilder bean, PropertyConfiguration targetConfig, BeanDefinition target) {
            return new ImportMapEntryBeanAssembler(beanConfig, bean, targetConfig, target);
        }
    }
}

