/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.factories;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class FlowRefFactoryBean
implements FactoryBean<MessageProcessor>,
ApplicationContextAware,
MuleContextAware,
Initialisable,
Disposable {
    private String refName;
    private ApplicationContext applicationContext;
    private MuleContext muleContext;
    private MessageProcessor referencedMessageProcessor;
    private ConcurrentMap<String, MessageProcessor> referenceCache = new ConcurrentHashMap<String, MessageProcessor>();

    public void setName(String name) {
        this.refName = name;
    }

    public void initialise() throws InitialisationException {
        if (this.refName.isEmpty()) {
            throw new InitialisationException(CoreMessages.objectIsNull((String)"flow reference is empty"), (Initialisable)this);
        }
        if (!this.muleContext.getExpressionManager().isExpression(this.refName)) {
            this.referencedMessageProcessor = this.lookupReferencedFlowInApplicationContext(this.refName);
        }
    }

    public void dispose() {
        for (MessageProcessor processor : this.referenceCache.values()) {
            if (!(processor instanceof Disposable)) continue;
            ((Disposable)processor).dispose();
        }
        this.referenceCache = null;
    }

    public MessageProcessor getObject() throws Exception {
        if (this.referencedMessageProcessor != null) {
            return this.referencedMessageProcessor;
        }
        return this.createDynamicReferenceMessageProcessor(this.refName);
    }

    protected MessageProcessor createDynamicReferenceMessageProcessor(String name) throws InitialisationException {
        if (name == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull((String)name));
        }
        if (!this.referenceCache.containsKey(name)) {
            MessageProcessor dynamicReference = new MessageProcessor(){

                public MuleEvent process(MuleEvent event) throws MuleException {
                    MessageProcessor dynamicMessageProcessor = FlowRefFactoryBean.this.getReferencedFlow(FlowRefFactoryBean.this.muleContext.getExpressionManager().parse(FlowRefFactoryBean.this.refName, event));
                    return dynamicMessageProcessor.process(event);
                }
            };
            if (dynamicReference instanceof Initialisable) {
                ((Initialisable)dynamicReference).initialise();
            }
            this.referenceCache.putIfAbsent(name, dynamicReference);
        }
        return (MessageProcessor)this.referenceCache.get(name);
    }

    protected MessageProcessor getReferencedFlow(String name) throws InitialisationException {
        if (name == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull((String)name));
        }
        if (!this.referenceCache.containsKey(name)) {
            MessageProcessor processor = this.lookupReferencedFlowInApplicationContext(name);
            if (processor instanceof Initialisable) {
                ((Initialisable)processor).initialise();
            }
            this.referenceCache.putIfAbsent(name, processor);
        }
        return (MessageProcessor)this.referenceCache.get(name);
    }

    protected MessageProcessor lookupReferencedFlowInApplicationContext(String name) {
        final MessageProcessor referencedFlow = (MessageProcessor)this.applicationContext.getBean(name);
        if (referencedFlow == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull((String)name));
        }
        if (referencedFlow instanceof FlowConstruct) {
            return new MessageProcessor(){

                public MuleEvent process(MuleEvent event) throws MuleException {
                    return referencedFlow.process(event);
                }
            };
        }
        return referencedFlow;
    }

    public boolean isSingleton() {
        return false;
    }

    public Class<?> getObjectType() {
        return MessageProcessor.class;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

