/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.config.ConfigurationException;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.context.MuleContextAware;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.config.i18n.MessageFactory;
import org.springframework.beans.factory.SmartFactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleConfigurationConfigurator
implements MuleContextAware,
SmartFactoryBean {
    private MuleContext muleContext;
    private DefaultMuleConfiguration config = new DefaultMuleConfiguration();
    protected transient Log logger = LogFactory.getLog(MuleConfigurationConfigurator.class);

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public boolean isEagerInit() {
        return true;
    }

    public boolean isPrototype() {
        return false;
    }

    public Object getObject() throws Exception {
        MuleConfiguration configuration = this.muleContext.getConfiguration();
        if (configuration instanceof DefaultMuleConfiguration) {
            DefaultMuleConfiguration defaultConfig = (DefaultMuleConfiguration)configuration;
            defaultConfig.setDefaultResponseTimeout(this.config.getDefaultResponseTimeout());
            defaultConfig.setDefaultTransactionTimeout(this.config.getDefaultTransactionTimeout());
            defaultConfig.setShutdownTimeout(this.config.getShutdownTimeout());
            return configuration;
        }
        throw new ConfigurationException(MessageFactory.createStaticMessage((String)("Unable to set properties on read-only MuleConfiguration: " + configuration.getClass())));
    }

    public Class<?> getObjectType() {
        return MuleConfiguration.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setDefaultSynchronousEndpoints(boolean synchronous) {
        this.config.setDefaultSynchronousEndpoints(synchronous);
    }

    public void setDefaultResponseTimeout(int responseTimeout) {
        this.config.setDefaultResponseTimeout(responseTimeout);
    }

    public void setDefaultTransactionTimeout(int defaultTransactionTimeout) {
        this.config.setDefaultTransactionTimeout(defaultTransactionTimeout);
    }

    public void setShutdownTimeout(int shutdownTimeout) {
        this.config.setShutdownTimeout(shutdownTimeout);
    }
}

