/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.assembly.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.mule.config.spring.parsers.assembly.configuration.Conventions;
import org.mule.config.spring.parsers.assembly.configuration.PropertyConfiguration;
import org.mule.config.spring.parsers.assembly.configuration.SingleProperty;
import org.mule.config.spring.parsers.assembly.configuration.SinglePropertyWrapper;
import org.mule.config.spring.parsers.assembly.configuration.ValueMap;
import org.mule.util.StringUtils;

public class SimplePropertyConfiguration
implements PropertyConfiguration {
    private List references = new ArrayList();
    private Properties nameMappings = new Properties();
    private Map valueMappings = new HashMap();
    private Set collections = new HashSet();
    private Map ignored = new HashMap();
    private boolean ignoreAll = false;

    public void addReference(String propertyName) {
        this.references.add(this.dropRef(propertyName));
    }

    public void addMapping(String propertyName, Map mappings) {
        this.valueMappings.put(propertyName, new NamedValueMap(propertyName, mappings));
    }

    public void addMapping(String propertyName, String mappings) {
        this.valueMappings.put(propertyName, new NamedValueMap(propertyName, mappings));
    }

    public void addMapping(String propertyName, ValueMap mappings) {
        this.valueMappings.put(propertyName, new NamedValueMap(propertyName, mappings));
    }

    public void addAlias(String alias, String propertyName) {
        this.nameMappings.put(alias, propertyName);
    }

    public void addCollection(String propertyName) {
        this.collections.add(this.dropRef(propertyName));
    }

    public void addIgnored(String propertyName) {
        this.ignored.put(this.dropRef(propertyName), Boolean.TRUE);
    }

    public void removeIgnored(String propertyName) {
        this.ignored.put(this.dropRef(propertyName), Boolean.FALSE);
    }

    public void setIgnoredDefault(boolean ignoreAll) {
        this.ignoreAll = ignoreAll;
    }

    public String getAttributeMapping(String alias) {
        return this.getAttributeMapping(alias, alias);
    }

    public String getAttributeAlias(String name) {
        for (Map.Entry<Object, Object> entry : this.nameMappings.entrySet()) {
            if (!entry.getValue().equals(name)) continue;
            return entry.getKey().toString();
        }
        return name;
    }

    public String getAttributeMapping(String alias, String deflt) {
        return this.nameMappings.getProperty(alias, deflt);
    }

    public boolean isCollection(String propertyName) {
        return this.collections.contains(this.dropRef(propertyName));
    }

    public boolean isIgnored(String propertyName) {
        String name = this.dropRef(propertyName);
        if (this.ignored.containsKey(name)) {
            return (Boolean)this.ignored.get(name);
        }
        return this.ignoreAll;
    }

    public boolean isReference(String attributeName) {
        return this.references.contains(this.dropRef(attributeName)) || attributeName.endsWith("-ref") || attributeName.endsWith("-refs") || attributeName.equals("ref");
    }

    public SingleProperty getSingleProperty(String name) {
        return new SinglePropertyWrapper(name, this);
    }

    public String translateName(String oldName) {
        String name = this.dropRef(oldName);
        name = this.getAttributeMapping(name);
        if (!org.springframework.util.StringUtils.hasText((String)(name = Conventions.attributeNameToPropertyName(name)))) {
            throw new IllegalStateException("Illegal property name for " + oldName + ": cannot be null or empty.");
        }
        return name;
    }

    protected String dropRef(String name) {
        return StringUtils.chomp((String)StringUtils.chomp((String)name, (String)"-ref"), (String)"-refs");
    }

    public Object translateValue(String name, String value) {
        NamedValueMap vm = (NamedValueMap)this.valueMappings.get(name);
        if (vm != null) {
            return vm.getValue(value);
        }
        return value;
    }

    public static class MapValueMap
    implements ValueMap {
        private Map map;

        public MapValueMap(Map map) {
            this.map = map;
        }

        public MapValueMap(String definition) {
            this.map = new HashMap();
            String[] values = org.springframework.util.StringUtils.tokenizeToStringArray((String)definition, (String)",");
            for (int i = 0; i < values.length; ++i) {
                String value = values[i];
                int x = value.indexOf("=");
                if (x == -1) {
                    throw new IllegalArgumentException("Mappings string not properly defined: " + definition);
                }
                this.map.put(value.substring(0, x), value.substring(x + 1));
            }
        }

        public Object rewrite(String value) {
            Object result = this.map.get(value);
            if (null == result) {
                return value;
            }
            return result.toString();
        }
    }

    public static class NamedValueMap {
        private String propertyName;
        private ValueMap valueMap;

        public NamedValueMap(String propertyName, String mappingsString) {
            this.propertyName = propertyName;
            this.valueMap = new MapValueMap(mappingsString);
        }

        public NamedValueMap(String propertyName, Map valueMap) {
            this.propertyName = propertyName;
            this.valueMap = new MapValueMap(valueMap);
        }

        public NamedValueMap(String propertyName, ValueMap valueMap) {
            this.propertyName = propertyName;
            this.valueMap = valueMap;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public Object getValue(String key) {
            return this.valueMap.rewrite(key);
        }
    }
}

