/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.hotdeploy;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.config.ConfigurationException;
import org.mule.api.context.notification.MuleContextNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.config.ConfigResource;
import org.mule.config.StartupContext;
import org.mule.config.spring.SpringXmlConfigurationBuilder;
import org.mule.config.spring.hotdeploy.DefaultMuleSharedDomainClassLoader;
import org.mule.config.spring.hotdeploy.FileWatcher;
import org.mule.config.spring.hotdeploy.MuleApplicationClassLoader;
import org.mule.context.DefaultMuleContextFactory;
import org.mule.context.notification.MuleContextNotification;
import org.mule.context.notification.NotificationException;
import org.mule.module.boot.MuleBootstrapUtils;

public class ReloadableBuilder
extends SpringXmlConfigurationBuilder {
    protected static final ClassLoader CLASSLOADER_ROOT = Thread.currentThread().getContextClassLoader();
    protected static final URL[] CLASSPATH_EMPTY = new URL[0];
    protected final transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected File monitoredResource;
    protected static final int RELOAD_INTERVAL_MS = 3000;

    public ReloadableBuilder(ConfigResource[] configResources) {
        super(configResources);
    }

    public ReloadableBuilder(String s) throws ConfigurationException {
        super(s);
    }

    public ReloadableBuilder(String[] strings) throws ConfigurationException {
        super(strings);
    }

    public void configure(MuleContext muleContext) throws ConfigurationException {
        boolean redeploymentEnabled = !StartupContext.get().getStartupOptions().containsKey("production");
        try {
            ConfigResource[] allResources;
            if (this.useDefaultConfigResource) {
                allResources = new ConfigResource[this.configResources.length + 1];
                allResources[0] = new ConfigResource("default-mule-config.xml");
                System.arraycopy(this.configResources, 0, allResources, 1, this.configResources.length);
            } else {
                allResources = this.configResources;
            }
            this.monitoredResource = new File(allResources[1].getUrl().getFile());
            ClassLoader parent = MuleBootstrapUtils.isStandalone() ? new DefaultMuleSharedDomainClassLoader(CLASSLOADER_ROOT) : CLASSLOADER_ROOT;
            MuleApplicationClassLoader cl = new MuleApplicationClassLoader(this.monitoredResource, parent);
            Thread.currentThread().setContextClassLoader(cl);
            if (redeploymentEnabled && this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Monitoring for hot-reload: " + this.monitoredResource));
            }
            final ConfigFileWatcher watcher = new ConfigFileWatcher(muleContext);
            if (redeploymentEnabled) {
                muleContext.registerListener((ServerNotificationListener)new MuleContextNotificationListener<MuleContextNotification>(){

                    public void onNotification(MuleContextNotification notification) {
                        if (notification.getAction() == 104) {
                            ReloadableBuilder.this.scheduleConfigMonitor(watcher);
                        }
                    }
                });
            }
            super.configure(muleContext);
        }
        catch (NotificationException e) {
            throw new ConfigurationException((Throwable)e);
        }
        catch (IOException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected void scheduleConfigMonitor(FileWatcher watcher) {
        int reloadIntervalMs = 3000;
        new Timer().schedule((TimerTask)watcher, new Date(System.currentTimeMillis() + 3000L), 3000L);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"Reload interval: 3000");
        }
    }

    protected void doConfigure(MuleContext muleContext) throws Exception {
        ConfigResource[] allResources;
        if (this.useDefaultConfigResource) {
            allResources = new ConfigResource[this.configResources.length + 1];
            allResources[0] = new ConfigResource("default-mule-config.xml");
            System.arraycopy(this.configResources, 0, allResources, 1, this.configResources.length);
        } else {
            allResources = this.configResources;
        }
        this.createSpringRegistry(muleContext, this.createApplicationContext(muleContext, allResources));
    }

    protected class ConfigFileWatcher
    extends FileWatcher {
        private volatile boolean cancelled;
        private final MuleContext muleContext;

        public ConfigFileWatcher(MuleContext muleContext) {
            super(ReloadableBuilder.this.monitoredResource);
            this.muleContext = muleContext;
        }

        protected synchronized void onChange(File file) {
            if (this.cancelled) {
                return;
            }
            this.cancel();
            this.cancelled = true;
            if (ReloadableBuilder.this.logger.isInfoEnabled()) {
                ReloadableBuilder.this.logger.info((Object)("================== Reloading " + file));
            }
            try {
                this.muleContext.dispose();
                Thread.currentThread().setContextClassLoader(null);
                ClassLoader parent = MuleBootstrapUtils.isStandalone() ? new DefaultMuleSharedDomainClassLoader(CLASSLOADER_ROOT) : CLASSLOADER_ROOT;
                MuleApplicationClassLoader cl = new MuleApplicationClassLoader(ReloadableBuilder.this.monitoredResource, parent);
                Thread.currentThread().setContextClassLoader(cl);
                DefaultMuleContextFactory f = new DefaultMuleContextFactory();
                MuleContext newContext = f.createMuleContext((ConfigurationBuilder)ReloadableBuilder.this);
                newContext.start();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

