/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.collection;

import java.util.Map;
import org.mule.config.spring.parsers.AbstractMuleBeanDefinitionParser;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.MapFactoryBean;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class OrphanMapDefinitionParser
extends AbstractMuleBeanDefinitionParser {
    private Class mapClass;
    private String name;
    private boolean dynamicName = false;

    public OrphanMapDefinitionParser(Class mapClass) {
        this.mapClass = mapClass;
        this.dynamicName = true;
    }

    public OrphanMapDefinitionParser(Class mapClass, String name) {
        this.mapClass = mapClass;
        this.name = name;
    }

    protected Class getBeanClass(Element element) {
        return MapFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Map parsedMap = parserContext.getDelegate().parseMapElement(element, (BeanDefinition)builder.getRawBeanDefinition());
        builder.addPropertyValue("sourceMap", (Object)parsedMap);
        builder.addPropertyValue("targetMapClass", (Object)this.mapClass.getName());
        this.getBeanAssembler(element, builder).setBeanFlag("org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE");
    }

    protected void preProcess(Element element) {
        super.preProcess(element);
        if (this.dynamicName) {
            this.name = null;
        }
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        return this.name;
    }
}

