/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.config.ConfigurationException;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.context.MuleContextAware;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.config.i18n.MessageFactory;
import org.springframework.beans.factory.SmartFactoryBean;

public class MuleConfigurationConfigurator
implements MuleContextAware,
SmartFactoryBean {
    private MuleContext muleContext;
    private DefaultMuleConfiguration config = new DefaultMuleConfiguration();
    protected transient Log logger = LogFactory.getLog(MuleConfigurationConfigurator.class);

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public boolean isEagerInit() {
        return true;
    }

    public boolean isPrototype() {
        return false;
    }

    public Object getObject() throws Exception {
        MuleConfiguration configuration = this.muleContext.getConfiguration();
        if (configuration instanceof DefaultMuleConfiguration) {
            ((DefaultMuleConfiguration)configuration).setDefaultSynchronousEndpoints(this.config.isDefaultSynchronousEndpoints());
            ((DefaultMuleConfiguration)configuration).setDefaultSynchronousEventTimeout(this.config.getDefaultSynchronousEventTimeout());
            ((DefaultMuleConfiguration)configuration).setDefaultRemoteSync(this.config.isDefaultRemoteSync());
            ((DefaultMuleConfiguration)configuration).setDefaultTransactionTimeout(this.config.getDefaultTransactionTimeout());
            return configuration;
        }
        throw new ConfigurationException(MessageFactory.createStaticMessage((String)("Unable to set properties on read-only MuleConfiguration: " + configuration.getClass())));
    }

    public Class getObjectType() {
        return MuleConfiguration.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setDefaultSynchronousEndpoints(boolean synchronous) {
        this.config.setDefaultSynchronousEndpoints(synchronous);
    }

    public void setDefaultSynchronousEventTimeout(int synchronousEventTimeout) {
        this.config.setDefaultSynchronousEventTimeout(synchronousEventTimeout);
    }

    public void setDefaultRemoteSync(boolean remoteSync) {
        this.config.setDefaultRemoteSync(remoteSync);
    }

    public void setDefaultTransactionTimeout(int defaultTransactionTimeout) {
        this.config.setDefaultTransactionTimeout(defaultTransactionTimeout);
    }
}

