/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import org.mule.api.MuleContext;
import org.mule.api.config.ConfigurationException;
import org.mule.api.registry.Registry;
import org.mule.config.ConfigResource;
import org.mule.config.builders.AbstractResourceConfigurationBuilder;
import org.mule.config.spring.MuleApplicationContext;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class SpringXmlConfigurationBuilder
extends AbstractResourceConfigurationBuilder {
    protected String defaultConfigResourceName = "default-mule-config.xml";
    protected ApplicationContext parentContext;

    public SpringXmlConfigurationBuilder(String configResources, ApplicationContext parentContext) throws ConfigurationException {
        super(configResources);
        this.parentContext = parentContext;
    }

    public SpringXmlConfigurationBuilder(String[] configResources, ApplicationContext parentContext) throws ConfigurationException {
        super(configResources);
        this.parentContext = parentContext;
    }

    public SpringXmlConfigurationBuilder(String[] configResources) throws ConfigurationException {
        this(configResources, null);
    }

    public SpringXmlConfigurationBuilder(String configResources) throws ConfigurationException {
        this(configResources, null);
    }

    public SpringXmlConfigurationBuilder(ConfigResource[] configResources, ApplicationContext parentContext) {
        super(configResources);
        this.parentContext = parentContext;
    }

    public SpringXmlConfigurationBuilder(ConfigResource[] configResources) {
        this(configResources, null);
    }

    protected void doConfigure(MuleContext muleContext) throws Exception {
        ConfigResource[] all = new ConfigResource[this.configResources.length + 1];
        all[0] = new ConfigResource(this.defaultConfigResourceName);
        System.arraycopy(this.configResources, 0, all, 1, this.configResources.length);
        this.createSpringParentRegistry(muleContext, muleContext.getRegistry(), all);
    }

    protected void createSpringParentRegistry(MuleContext muleContext, Registry registry, ConfigResource[] all) {
        try {
            if (this.parentContext != null) {
                new MuleApplicationContext(muleContext, registry, all, this.parentContext);
            } else {
                new MuleApplicationContext(muleContext, registry, all);
            }
        }
        catch (BeansException e) {
            registry.setParent(null);
            throw e;
        }
    }

    public void setDefaultConfigResourceName(String defaultConfigResourceName) {
        this.defaultConfigResourceName = defaultConfigResourceName;
    }

    public void setParentContext(ApplicationContext parentContext) {
        this.parentContext = parentContext;
    }
}

