/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.util;

import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleTransitionResult;
import org.mule.config.i18n.MessageFactory;
import org.mule.object.AbstractObjectFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringBeanLookup
extends AbstractObjectFactory
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private String bean;

    public LifecycleTransitionResult initialise() throws InitialisationException {
        if (this.bean == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage((String)"Bean name has not been set."), (Initialisable)this);
        }
        if (this.applicationContext == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage((String)"ApplicationContext has not been injected."), (Initialisable)this);
        }
        return LifecycleTransitionResult.OK;
    }

    public void dispose() {
    }

    public Class getObjectClass() {
        return this.applicationContext.getType(this.bean);
    }

    public Object getInstance() throws Exception {
        Object instance = this.applicationContext.getBean(this.bean);
        this.fireInitialisationCallbacks(instance);
        return instance;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String getBean() {
        return this.bean;
    }

    public void setBean(String bean) {
        this.bean = bean;
    }

    public boolean isSingleton() {
        return this.applicationContext.isSingleton(this.bean);
    }
}

