/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.specific;

import org.mule.config.spring.parsers.assembly.BeanAssembler;
import org.mule.config.spring.parsers.generic.MuleOrphanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.SystemPropertyUtils;
import org.w3c.dom.Element;

public class EnvironmentPropertyDefinitionParser
extends MuleOrphanDefinitionParser {
    private final String VALUE_ATTR = "value";
    private final String NAME_ATTR = "name";

    public EnvironmentPropertyDefinitionParser() {
        super(true);
        this.addIgnored("name");
        this.addIgnored("value");
    }

    protected Class getBeanClass(Element element) {
        return String.class;
    }

    protected void postProcess(ParserContext context, BeanAssembler assembler, Element element) {
        String name = element.getAttribute("name");
        if (name.indexOf(32) != -1) {
            this.logger.warn((Object)("Environment property name should not contain spaces: \"" + name + "\""));
        }
        String value = element.getAttribute("value");
        assembler.getBean().addConstructorArg((Object)SystemPropertyUtils.resolvePlaceholders((String)value));
        super.postProcess(context, assembler, element);
    }
}

