/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.specific;

import org.mule.api.model.Model;
import org.mule.api.registry.ServiceException;
import org.mule.config.spring.parsers.AbstractMuleBeanDefinitionParser;
import org.mule.model.ModelFactory;
import org.mule.util.ClassUtils;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.w3c.dom.Element;

public class ModelDefinitionParser
extends AbstractMuleBeanDefinitionParser {
    private String type;

    public ModelDefinitionParser(String type) {
        this.type = type;
        this.singleton = true;
    }

    protected Class getBeanClass(Element element) {
        return ModelFactoryBean.class;
    }

    public class ModelFactoryBean
    extends AbstractFactoryBean {
        private Model model;

        public Class getObjectType() {
            try {
                return ModelFactory.getModelClass((String)ModelDefinitionParser.this.type);
            }
            catch (ServiceException e) {
                throw new BeanCreationException("Failed to load model class", (Throwable)e);
            }
        }

        protected Object createInstance() throws Exception {
            this.model = (Model)ClassUtils.instanciateClass((Class)this.getObjectType(), (Object[])ClassUtils.NO_ARGS);
            return this.model;
        }

        public void afterPropertiesSet() throws Exception {
            super.afterPropertiesSet();
            this.model.initialise();
        }

        public void destroy() throws Exception {
            super.destroy();
            this.model.dispose();
        }
    }
}

