/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.scripting.component;

import javax.script.Bindings;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.component.AbstractComponent;
import org.mule.runtime.module.scripting.component.Scriptable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptComponent
extends AbstractComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptComponent.class);
    private Scriptable script;

    protected void doInitialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)this.script, (MuleContext)this.muleContext);
        super.doInitialise();
    }

    protected void doDispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.script, (Logger)LOGGER);
    }

    protected Object doInvoke(Event event, Event.Builder eventBuilder) throws Exception {
        Bindings bindings = this.script.getScriptEngine().createBindings();
        this.putBindings(bindings);
        this.script.populateBindings(bindings, event, eventBuilder);
        try {
            Object object = this.script.runScript(bindings);
            return object;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            eventBuilder.message((Message)((InternalMessage)bindings.get("message")));
            bindings.clear();
        }
    }

    protected void putBindings(Bindings bindings) {
    }

    public Scriptable getScript() {
        return this.script;
    }

    public void setScript(Scriptable script) {
        this.script = script;
    }
}

