/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.scripting.transformer;

import javax.script.Bindings;
import javax.script.ScriptException;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleUtils;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.module.scripting.component.Scriptable;
import org.mule.transformer.AbstractMessageTransformer;

public class ScriptTransformer
extends AbstractMessageTransformer {
    private Scriptable script;

    public void initialise() throws InitialisationException {
        super.initialise();
        LifecycleUtils.initialiseIfNeeded((Object)this.script, (MuleContext)this.muleContext);
    }

    public void dispose() {
        super.dispose();
        LifecycleUtils.disposeIfNeeded((Object)this.script);
    }

    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        Bindings bindings = this.script.getScriptEngine().createBindings();
        this.script.populateBindings(bindings, message);
        try {
            Object object = this.script.runScript(bindings);
            return object;
        }
        catch (ScriptException e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
        finally {
            bindings.clear();
        }
    }

    public Scriptable getScript() {
        return this.script;
    }

    public void setScript(Scriptable script) {
        this.script = script;
    }
}

