/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.scripting.builders;

import javax.script.Bindings;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.config.ConfigResource;
import org.mule.config.builders.AbstractResourceConfigurationBuilder;
import org.mule.config.builders.i18n.BuildersMessages;
import org.mule.module.scripting.component.Scriptable;

public class ScriptConfigurationBuilder
extends AbstractResourceConfigurationBuilder {
    public static final String SCRIPT_ENGINE_NAME_PROPERTY = "org.mule.script.engine";
    private Scriptable scriptComponent = new Scriptable();
    protected MuleContext muleContext = null;

    public ScriptConfigurationBuilder(String configResource) throws MuleException {
        this(System.getProperty(SCRIPT_ENGINE_NAME_PROPERTY), configResource);
    }

    public ScriptConfigurationBuilder(String[] configResources) throws MuleException {
        this(System.getProperty(SCRIPT_ENGINE_NAME_PROPERTY), configResources);
    }

    public ScriptConfigurationBuilder(String scriptEngineName, String configResource) throws MuleException {
        super(configResource);
        if (scriptEngineName == null) {
            logger.warn((Object)BuildersMessages.systemPropertyNotSet((String)SCRIPT_ENGINE_NAME_PROPERTY).getMessage());
        }
        this.scriptComponent.setScriptEngineName(scriptEngineName);
    }

    public ScriptConfigurationBuilder(String scriptEngineName, String[] configResources) throws MuleException {
        super(configResources);
        if (scriptEngineName == null) {
            logger.warn((Object)BuildersMessages.systemPropertyNotSet((String)SCRIPT_ENGINE_NAME_PROPERTY).getMessage());
        }
        this.scriptComponent.setScriptEngineName(scriptEngineName);
    }

    protected void doConfigure(MuleContext muleContext) throws Exception {
        this.muleContext = muleContext;
        for (int i = 0; i < this.configResources.length; ++i) {
            ConfigResource configResource = this.configResources[i];
            this.scriptComponent.setScriptFile(configResource.getResourceName());
            this.scriptComponent.initialise();
            Bindings bindings = this.scriptComponent.getScriptEngine().createBindings();
            this.scriptComponent.populateDefaultBindings(bindings);
            this.scriptComponent.runScript(bindings);
        }
    }

    protected void populateBindings(Bindings bindings) {
        bindings.put("muleContext", (Object)this.muleContext);
    }
}

