/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.scripting.expression;

import java.util.Map;
import java.util.WeakHashMap;
import javax.script.Bindings;
import javax.script.ScriptException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transport.MessageAdapter;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.scripting.component.Scriptable;
import org.mule.util.expression.ExpressionEvaluator;

public abstract class AbstractScriptExpressionEvaluator
implements ExpressionEvaluator,
Disposable {
    protected Map cache = new WeakHashMap(8);

    public Object evaluate(String expression, Object message) {
        Scriptable script = this.getScript(expression);
        Bindings bindings = script.getScriptEngine().createBindings();
        if (message instanceof MuleMessage) {
            script.populateBindings(bindings, (MessageAdapter)((MuleMessage)message));
        } else {
            script.populateBindings(bindings, message);
        }
        try {
            return script.runScript(bindings);
        }
        catch (ScriptException e) {
            return null;
        }
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("setName");
    }

    protected Scriptable getScript(String expression) {
        Scriptable script = (Scriptable)this.cache.get(expression);
        if (script == null) {
            script = new Scriptable();
            script.setScriptEngineName(this.getName());
            script.setScriptText(expression);
            try {
                script.initialise();
            }
            catch (InitialisationException e) {
                throw new MuleRuntimeException(CoreMessages.initialisationFailure((String)"An error occurred initialising script."), (Throwable)e);
            }
            this.cache.put(expression, script);
        }
        return script;
    }

    public void dispose() {
        this.cache.clear();
    }
}

