/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.scripting.component;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.routing.NestedRouter;
import org.mule.api.routing.NestedRouterCollection;
import org.mule.component.AbstractComponent;
import org.mule.module.scripting.component.Scriptable;
import org.mule.routing.nested.DefaultNestedRouterCollection;
import org.mule.routing.nested.NestedInvocationHandler;
import org.mule.transformer.TransformerTemplate;
import org.mule.transport.NullPayload;
import org.mule.util.ClassUtils;

public class ScriptComponent
extends AbstractComponent {
    protected NestedRouterCollection nestedRouter = new DefaultNestedRouterCollection();
    private Scriptable script;
    private Map proxies;

    protected void doInitialise() throws InitialisationException {
        super.doInitialise();
        try {
            this.configureComponentBindings();
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected MuleMessage doOnCall(MuleEvent event) throws Exception {
        Bindings bindings = this.script.getScriptEngine().createBindings();
        if (this.proxies.size() > 0) {
            bindings.putAll(this.proxies);
        }
        this.script.populateBindings(bindings, event);
        Object result = this.script.runScript(bindings);
        if (result != null) {
            if (result instanceof MuleMessage) {
                return (MuleMessage)result;
            }
            event.getMessage().applyTransformers(Collections.singletonList(new TransformerTemplate((TransformerTemplate.TransformerCallback)new TransformerTemplate.OverwitePayloadCallback(result))));
            return event.getMessage();
        }
        return new DefaultMuleMessage((Object)NullPayload.getInstance());
    }

    public Scriptable getScript() {
        return this.script;
    }

    public void setScript(Scriptable script) {
        this.script = script;
    }

    public NestedRouterCollection getNestedRouter() {
        return this.nestedRouter;
    }

    public void setNestedRouter(NestedRouterCollection nestedRouter) {
        this.nestedRouter = nestedRouter;
    }

    protected void configureComponentBindings() throws MuleException {
        this.proxies = new HashMap();
        if (this.nestedRouter != null && this.nestedRouter.getRouters().size() > 0) {
            for (NestedRouter nestedRouter : this.nestedRouter.getRouters()) {
                Object proxy;
                String bindingName = ClassUtils.getSimpleName((Class)nestedRouter.getInterface());
                if (this.proxies.containsKey(bindingName)) {
                    proxy = this.proxies.get(bindingName);
                    NestedInvocationHandler handler = (NestedInvocationHandler)Proxy.getInvocationHandler(proxy);
                    handler.addRouterForInterface(nestedRouter);
                    continue;
                }
                proxy = Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{nestedRouter.getInterface()}, (InvocationHandler)new NestedInvocationHandler(nestedRouter));
                this.proxies.put(bindingName, proxy);
            }
        }
    }
}

