/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import javax.script.Bindings;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.components.script.jsr223.Scriptable;
import org.mule.config.builders.AbstractResourceConfigurationBuilder;
import org.mule.config.builders.i18n.BuildersMessages;

public class ScriptConfigurationBuilder
extends AbstractResourceConfigurationBuilder {
    public static final String SCRIPT_ENGINE_NAME_PROPERTY = "org.mule.script.engine";
    private Scriptable scriptComponent = new Scriptable();
    protected MuleContext muleContext = null;
    protected boolean initialised = false;

    public ScriptConfigurationBuilder(String configResource) throws MuleException {
        this(System.getProperty(SCRIPT_ENGINE_NAME_PROPERTY), configResource);
    }

    public ScriptConfigurationBuilder(String[] configResources) throws MuleException {
        this(System.getProperty(SCRIPT_ENGINE_NAME_PROPERTY), configResources);
    }

    public ScriptConfigurationBuilder(String scriptEngineName, String configResource) throws MuleException {
        super(configResource);
        if (scriptEngineName == null) {
            throw new IllegalArgumentException(BuildersMessages.systemPropertyNotSet((String)SCRIPT_ENGINE_NAME_PROPERTY).getMessage());
        }
        this.scriptComponent.setScriptEngineName(scriptEngineName);
    }

    public ScriptConfigurationBuilder(String scriptEngineName, String[] configResources) throws MuleException {
        super(configResources);
        if (scriptEngineName == null) {
            throw new IllegalArgumentException(BuildersMessages.systemPropertyNotSet((String)SCRIPT_ENGINE_NAME_PROPERTY).getMessage());
        }
        this.scriptComponent.setScriptEngineName(scriptEngineName);
    }

    protected void doConfigure(MuleContext muleContext) throws Exception {
        for (int i = 0; i < this.configResources.length; ++i) {
            String configResource = this.configResources[i];
            this.scriptComponent.setScriptFile(configResource);
            this.scriptComponent.initialise();
            Bindings ns = this.scriptComponent.getScriptEngine().createBindings();
            this.populateBindings(ns);
            this.scriptComponent.runScript(ns);
        }
    }

    protected void populateBindings(Bindings bindings) {
        bindings.put("muleContext", (Object)this.muleContext);
    }
}

