/*
 * Decompiled with CFR 0.152.
 */
package org.mule.components.script;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationException;
import org.mule.api.lifecycle.Callable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.service.Service;
import org.mule.api.service.ServiceAware;
import org.mule.util.ClassUtils;
import org.mule.util.FileUtils;
import org.mule.util.monitor.FileListener;
import org.mule.util.monitor.FileMonitor;

public abstract class AbstractScriptComponent
implements Lifecycle,
ServiceAware,
FileListener,
Callable {
    public static final int DEFAULT_RELOAD_INTERVAL_MS = 60000;
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private String script = null;
    private String scriptText = null;
    private boolean autoReload = true;
    protected Service service;
    private FileMonitor monitor;
    private long reloadInterval = 60000L;

    public void setService(Service service) throws ConfigurationException {
        this.service = service;
    }

    public void initialise() throws InitialisationException {
        if (this.getScript() == null && this.getScriptText() == null) {
            String extension = this.getDefaultFileExtension();
            if (!extension.startsWith(".")) {
                extension = "." + extension;
            }
            this.setScript(this.service.getName() + extension);
            this.logger.info((Object)("script name is not set, using default: " + this.service.getName() + extension));
        }
        if (this.getScriptText() != null) {
            this.loadInterpreter(this.getScriptText());
        } else {
            this.loadInterpreter(this.getScriptUrl(this.getScript()));
        }
        if (this.autoReload) {
            File f = FileUtils.newFile((String)this.getScript());
            if (f.exists()) {
                this.monitor = new FileMonitor(this.reloadInterval);
                this.monitor.addFile(f);
                this.monitor.addListener((FileListener)this);
                this.logger.debug((Object)"Service script is reloadable");
            } else {
                this.logger.warn((Object)"Cannot setup autoreload as the script fie is not on the local file system");
            }
        }
    }

    protected URL getScriptUrl(String scriptLocation) {
        File f = FileUtils.newFile((String)scriptLocation);
        if (f.exists()) {
            try {
                return f.toURL();
            }
            catch (MalformedURLException e) {
                this.logger.error((Object)("Failed to create URL from file: " + f.getAbsolutePath()), (Throwable)e);
                return null;
            }
        }
        return ClassUtils.getResource((String)scriptLocation, this.getClass());
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public boolean isAutoReload() {
        return this.autoReload;
    }

    public void setAutoReload(boolean autoReload) {
        this.autoReload = autoReload;
    }

    public void start() throws MuleException {
        if (this.monitor != null) {
            this.monitor.start();
        }
    }

    public void stop() throws MuleException {
        if (this.monitor != null) {
            this.monitor.stop();
        }
    }

    public void dispose() {
        try {
            this.stop();
        }
        catch (MuleException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public String getScriptText() {
        return this.scriptText;
    }

    public void setScriptText(String scriptText) {
        this.scriptText = scriptText;
    }

    protected abstract void loadInterpreter(URL var1) throws InitialisationException;

    protected abstract void loadInterpreter(String var1) throws InitialisationException;

    protected abstract String getDefaultFileExtension();
}

