/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Arrays;
import java.util.Iterator;
import org.jcodings.Encoding;
import org.joni.NameEntry;
import org.joni.Regex;
import org.joni.Region;
import org.joni.exception.JOniException;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.StringSupport;

@JRubyClass(name={"MatchData"})
public class RubyMatchData
extends RubyObject {
    Region regs;
    int begin;
    int end;
    RubyString str;
    Regex pattern;
    RubyRegexp regexp;
    boolean charOffsetUpdated;
    Region charOffsets;
    private static ObjectAllocator MATCH_DATA_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyMatchData(runtime, klass);
        }
    };
    private static final int MATCH_BUSY = 128;

    public static RubyClass createMatchDataClass(Ruby runtime) {
        RubyClass matchDataClass = runtime.defineClass("MatchData", runtime.getObject(), MATCH_DATA_ALLOCATOR);
        runtime.setMatchData(matchDataClass);
        matchDataClass.index = 27;
        matchDataClass.setReifiedClass(RubyMatchData.class);
        runtime.defineGlobalConstant("MatchingData", matchDataClass);
        matchDataClass.kindOf = new RubyModule.JavaClassKindOf(RubyMatchData.class);
        matchDataClass.getMetaClass().undefineMethod("new");
        matchDataClass.defineAnnotatedMethods(RubyMatchData.class);
        return matchDataClass;
    }

    public RubyMatchData(Ruby runtime) {
        super(runtime, runtime.getMatchData());
    }

    public RubyMatchData(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @Override
    public void copySpecialInstanceVariables(IRubyObject clone) {
        RubyMatchData match2 = (RubyMatchData)clone;
        match2.regs = this.regs;
        match2.begin = this.begin;
        match2.end = this.end;
        match2.pattern = this.pattern;
        match2.regexp = this.regexp;
        match2.charOffsetUpdated = this.charOffsetUpdated;
        match2.charOffsets = this.charOffsets;
    }

    @Override
    public int getNativeTypeIndex() {
        return 27;
    }

    private void updatePairs(ByteList value2, Encoding encoding2, Pair[] pairs) {
        int p2;
        Arrays.sort(pairs);
        int length2 = pairs.length;
        byte[] bytes2 = value2.getUnsafeBytes();
        int s2 = p2 = value2.getBegin();
        int c = 0;
        for (int i2 = 0; i2 < length2; ++i2) {
            int q = s2 + pairs[i2].bytePos;
            pairs[i2].charPos = c += StringSupport.strLength(encoding2, bytes2, p2, q);
            p2 = q;
        }
    }

    private void updateCharOffsetOnlyOneReg(ByteList value2, Encoding encoding2) {
        if (this.charOffsets == null || this.charOffsets.numRegs < 1) {
            this.charOffsets = new Region(1);
        }
        if (encoding2.maxLength() == 1) {
            this.charOffsets.beg[0] = this.begin;
            this.charOffsets.end[0] = this.end;
            this.charOffsetUpdated = true;
            return;
        }
        Object[] pairs = new Pair[2];
        pairs[0] = new Pair();
        pairs[0].bytePos = this.begin;
        pairs[1] = new Pair();
        pairs[1].bytePos = this.end;
        this.updatePairs(value2, encoding2, (Pair[])pairs);
        Pair key2 = new Pair();
        key2.bytePos = this.begin;
        this.charOffsets.beg[0] = ((Pair)pairs[Arrays.binarySearch((Object[])pairs, (Object)key2)]).charPos;
        key2.bytePos = this.end;
        this.charOffsets.end[0] = ((Pair)pairs[Arrays.binarySearch((Object[])pairs, (Object)key2)]).charPos;
    }

    private void updateCharOffsetManyRegs(ByteList value2, Encoding encoding2) {
        int numRegs = this.regs.numRegs;
        if (this.charOffsets == null || this.charOffsets.numRegs < numRegs) {
            this.charOffsets = new Region(numRegs);
        }
        if (encoding2.maxLength() == 1) {
            for (int i2 = 0; i2 < numRegs; ++i2) {
                this.charOffsets.beg[i2] = this.regs.beg[i2];
                this.charOffsets.end[i2] = this.regs.end[i2];
            }
            return;
        }
        Object[] pairs = new Pair[numRegs * 2];
        for (int i3 = 0; i3 < pairs.length; ++i3) {
            pairs[i3] = new Pair();
        }
        int numPos = 0;
        for (int i4 = 0; i4 < numRegs; ++i4) {
            if (this.regs.beg[i4] < 0) continue;
            pairs[numPos++].bytePos = this.regs.beg[i4];
            pairs[numPos++].bytePos = this.regs.end[i4];
        }
        this.updatePairs(value2, encoding2, (Pair[])pairs);
        Pair key2 = new Pair();
        for (int i5 = 0; i5 < this.regs.numRegs; ++i5) {
            if (this.regs.beg[i5] < 0) {
                this.charOffsets.end[i5] = -1;
                this.charOffsets.beg[i5] = -1;
                continue;
            }
            key2.bytePos = this.regs.beg[i5];
            this.charOffsets.beg[i5] = ((Pair)pairs[Arrays.binarySearch((Object[])pairs, (Object)key2)]).charPos;
            key2.bytePos = this.regs.end[i5];
            this.charOffsets.end[i5] = ((Pair)pairs[Arrays.binarySearch((Object[])pairs, (Object)key2)]).charPos;
        }
    }

    private void updateCharOffset() {
        if (this.charOffsetUpdated) {
            return;
        }
        ByteList value2 = this.str.getByteList();
        Encoding enc = value2.getEncoding();
        if (this.regs == null) {
            this.updateCharOffsetOnlyOneReg(value2, enc);
        } else {
            this.updateCharOffsetManyRegs(value2, enc);
        }
        this.charOffsetUpdated = true;
    }

    public final void use() {
        this.flags |= 0x80;
    }

    public final boolean used() {
        return (this.flags & 0x80) != 0;
    }

    void check() {
        if (this.str == null) {
            throw this.getRuntime().newTypeError("uninitialized Match");
        }
    }

    private void checkLazyRegexp() {
        if (this.regexp == null) {
            this.regexp = RubyRegexp.newRegexp(this.getRuntime(), (ByteList)this.pattern.getUserObject(), this.pattern);
        }
    }

    private RubyString makeShared(Ruby runtime, RubyString str, int begin2, int length2) {
        if (runtime.is1_9()) {
            return str.makeShared19(runtime, begin2, length2);
        }
        return str.makeShared(runtime, begin2, length2);
    }

    private RubyArray match_array(Ruby runtime, int start2) {
        this.check();
        if (this.regs == null) {
            if (start2 != 0) {
                return runtime.newEmptyArray();
            }
            if (this.begin == -1) {
                return runtime.newArray(runtime.getNil());
            }
            RubyString ss = this.makeShared(runtime, this.str, this.begin, this.end - this.begin);
            if (this.isTaint()) {
                ss.setTaint(true);
            }
            return runtime.newArray((IRubyObject)ss);
        }
        RubyArray arr = runtime.newArray(this.regs.numRegs - start2);
        for (int i2 = start2; i2 < this.regs.numRegs; ++i2) {
            if (this.regs.beg[i2] == -1) {
                arr.append(runtime.getNil());
                continue;
            }
            RubyString ss = this.makeShared(runtime, this.str, this.regs.beg[i2], this.regs.end[i2] - this.regs.beg[i2]);
            if (this.isTaint()) {
                ss.setTaint(true);
            }
            arr.append(ss);
        }
        return arr;
    }

    public IRubyObject group(long n) {
        return RubyRegexp.nth_match((int)n, this);
    }

    public IRubyObject group(int n) {
        return RubyRegexp.nth_match(n, this);
    }

    public IRubyObject[] getNamedBackrefValues(Ruby runtime) {
        if (this.pattern.numberOfNames() == 0) {
            return NULL_ARRAY;
        }
        IRubyObject[] values2 = new IRubyObject[this.pattern.numberOfNames()];
        int j = 0;
        Iterator i2 = this.pattern.namedBackrefIterator();
        while (i2.hasNext()) {
            NameEntry e = (NameEntry)i2.next();
            int nth = this.pattern.nameToBackrefNumber(e.name, e.nameP, e.nameEnd, this.regs);
            values2[j++] = RubyRegexp.nth_match(nth, this);
        }
        return values2;
    }

    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        NameEntry e;
        if (this.str == null) {
            return this.anyToString();
        }
        Ruby runtime = this.getRuntime();
        RubyString result2 = runtime.newString();
        result2.cat((byte)35).cat((byte)60);
        result2.append(this.getMetaClass().getRealClass().to_s());
        NameEntry[] names2 = new NameEntry[this.regs == null ? 1 : this.regs.numRegs];
        if (this.pattern.numberOfNames() > 0) {
            Iterator i2 = this.pattern.namedBackrefIterator();
            while (i2.hasNext()) {
                e = (NameEntry)i2.next();
                for (int num : e.getBackRefs()) {
                    names2[num] = e;
                }
            }
        }
        for (int i3 = 0; i3 < names2.length; ++i3) {
            IRubyObject v;
            result2.cat((byte)32);
            if (i3 > 0) {
                e = names2[i3];
                if (e != null) {
                    result2.cat(e.name, e.nameP, e.nameEnd - e.nameP);
                } else {
                    result2.cat((byte)(48 + i3));
                }
                result2.cat((byte)58);
            }
            if ((v = RubyRegexp.nth_match(i3, this)).isNil()) {
                result2.cat("nil".getBytes());
                continue;
            }
            result2.append(runtime.is1_9() ? ((RubyString)v).inspect19() : ((RubyString)v).inspect());
        }
        return result2.cat((byte)62);
    }

    @JRubyMethod(name={"regexp"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject regexp(ThreadContext context, Block block) {
        this.check();
        this.checkLazyRegexp();
        return this.regexp;
    }

    @JRubyMethod(name={"names"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject names(ThreadContext context, Block block) {
        this.check();
        this.checkLazyRegexp();
        return this.regexp.names(context);
    }

    @Override
    @JRubyMethod(name={"to_a"})
    public RubyArray to_a() {
        return this.match_array(this.getRuntime(), 0);
    }

    @JRubyMethod(name={"values_at"}, rest=true)
    public IRubyObject values_at(IRubyObject[] args2) {
        return this.to_a().values_at(args2);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_8)
    public IRubyObject select(ThreadContext context, Block block) {
        RubyArray result2;
        Ruby runtime = context.runtime;
        if (this.regs == null) {
            if (this.begin < 0) {
                return runtime.newEmptyArray();
            }
            IRubyObject s2 = this.str.substr(runtime, this.begin, this.end - this.begin);
            s2.setTaint(this.isTaint());
            result2 = block.yield(context, s2).isTrue() ? runtime.newArray(s2) : runtime.newEmptyArray();
        } else {
            result2 = runtime.newArray();
            boolean taint2 = this.isTaint();
            for (int i2 = 0; i2 < this.regs.numRegs; ++i2) {
                IRubyObject s3 = this.str.substr(runtime, this.regs.beg[i2], this.regs.end[i2] - this.regs.beg[i2]);
                if (taint2) {
                    s3.setTaint(true);
                }
                if (!block.yield(context, s3).isTrue()) continue;
                result2.append(s3);
            }
        }
        return result2;
    }

    @JRubyMethod(name={"captures"})
    public IRubyObject captures(ThreadContext context) {
        return this.match_array(context.runtime, 1);
    }

    private int nameToBackrefNumber(RubyString str) {
        ByteList value2 = str.getByteList();
        try {
            return this.pattern.nameToBackrefNumber(value2.getUnsafeBytes(), value2.getBegin(), value2.getBegin() + value2.getRealSize(), this.regs);
        }
        catch (JOniException je) {
            throw this.getRuntime().newIndexError(je.getMessage());
        }
    }

    public final int backrefNumber(IRubyObject obj) {
        this.check();
        if (obj instanceof RubySymbol) {
            return this.nameToBackrefNumber((RubyString)((RubySymbol)obj).id2name());
        }
        if (obj instanceof RubyString) {
            return this.nameToBackrefNumber((RubyString)obj);
        }
        return RubyNumeric.num2int(obj);
    }

    public IRubyObject op_aref(IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return this.op_aref(args2[0]);
            }
            case 2: {
                return this.op_aref(args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 1, 2);
        return null;
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject op_aref(IRubyObject idx) {
        this.check();
        if (!(idx instanceof RubyFixnum) || ((RubyFixnum)idx).getLongValue() < 0L) {
            return this.to_a().aref(idx);
        }
        return RubyRegexp.nth_match(RubyNumeric.fix2int(idx), this);
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject op_aref(IRubyObject idx, IRubyObject rest2) {
        if (!rest2.isNil() || !(idx instanceof RubyFixnum) || ((RubyFixnum)idx).getLongValue() < 0L) {
            return this.to_a().aref(idx, rest2);
        }
        return RubyRegexp.nth_match(RubyNumeric.fix2int(idx), this);
    }

    @JRubyMethod(name={"[]"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_aref19(IRubyObject idx) {
        this.check();
        IRubyObject result2 = this.op_arefCommon(idx);
        return result2 == null ? this.to_a().aref19(idx) : result2;
    }

    /*
     * WARNING - void declaration
     */
    @JRubyMethod(name={"[]"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_aref19(IRubyObject idx, IRubyObject rest2) {
        void var3_3;
        IRubyObject result2;
        return !rest2.isNil() || (result2 = this.op_arefCommon(idx)) == null ? this.to_a().aref19(idx, rest2) : var3_3;
    }

    private IRubyObject op_arefCommon(IRubyObject idx) {
        if (idx instanceof RubyFixnum) {
            int num = RubyNumeric.fix2int(idx);
            if (num >= 0) {
                return RubyRegexp.nth_match(num, this);
            }
        } else {
            if (idx instanceof RubySymbol) {
                return RubyRegexp.nth_match(this.nameToBackrefNumber((RubyString)((RubySymbol)idx).id2name()), this);
            }
            if (idx instanceof RubyString) {
                return RubyRegexp.nth_match(this.nameToBackrefNumber((RubyString)idx), this);
            }
        }
        return null;
    }

    @JRubyMethod(name={"size", "length"})
    public IRubyObject size(ThreadContext context) {
        this.check();
        Ruby runtime = context.runtime;
        return this.regs == null ? RubyFixnum.one(runtime) : RubyFixnum.newFixnum(runtime, this.regs.numRegs);
    }

    @JRubyMethod(name={"begin"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject begin(ThreadContext context, IRubyObject index2) {
        Ruby runtime = context.runtime;
        int i2 = RubyNumeric.num2int(index2);
        int b2 = this.beginCommon(runtime, i2);
        return b2 < 0 ? runtime.getNil() : RubyFixnum.newFixnum(runtime, b2);
    }

    @JRubyMethod(name={"begin"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject begin19(ThreadContext context, IRubyObject index2) {
        Ruby runtime = context.runtime;
        int i2 = this.backrefNumber(index2);
        int b2 = this.beginCommon(runtime, i2);
        if (b2 < 0) {
            return runtime.getNil();
        }
        if (!this.str.singleByteOptimizable()) {
            this.updateCharOffset();
            b2 = this.charOffsets.beg[i2];
        }
        return RubyFixnum.newFixnum(runtime, b2);
    }

    private int beginCommon(Ruby runtime, int i2) {
        this.check();
        if (i2 < 0 || (this.regs == null ? 1 : this.regs.numRegs) <= i2) {
            throw runtime.newIndexError("index " + i2 + " out of matches");
        }
        return this.regs == null ? this.begin : this.regs.beg[i2];
    }

    @JRubyMethod(name={"end"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject end(ThreadContext context, IRubyObject index2) {
        Ruby runtime = context.runtime;
        int i2 = RubyNumeric.num2int(index2);
        int e = this.endCommon(runtime, i2);
        return e < 0 ? runtime.getNil() : RubyFixnum.newFixnum(runtime, e);
    }

    @JRubyMethod(name={"end"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject end19(ThreadContext context, IRubyObject index2) {
        Ruby runtime = context.runtime;
        int i2 = this.backrefNumber(index2);
        int e = this.endCommon(runtime, i2);
        if (e < 0) {
            return runtime.getNil();
        }
        if (!this.str.singleByteOptimizable()) {
            this.updateCharOffset();
            e = this.charOffsets.end[i2];
        }
        return RubyFixnum.newFixnum(runtime, e);
    }

    private int endCommon(Ruby runtime, int i2) {
        this.check();
        if (i2 < 0 || (this.regs == null ? 1 : this.regs.numRegs) <= i2) {
            throw runtime.newIndexError("index " + i2 + " out of matches");
        }
        return this.regs == null ? this.end : this.regs.end[i2];
    }

    @JRubyMethod(name={"offset"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject offset(ThreadContext context, IRubyObject index2) {
        return this.offsetCommon(context, RubyNumeric.num2int(index2), false);
    }

    @JRubyMethod(name={"offset"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject offset19(ThreadContext context, IRubyObject index2) {
        return this.offsetCommon(context, this.backrefNumber(index2), true);
    }

    private IRubyObject offsetCommon(ThreadContext context, int i2, boolean is_19) {
        int e;
        int b2;
        this.check();
        Ruby runtime = context.runtime;
        if (i2 < 0 || (this.regs == null ? 1 : this.regs.numRegs) <= i2) {
            throw runtime.newIndexError("index " + i2 + " out of matches");
        }
        if (this.regs == null) {
            b2 = this.begin;
            e = this.end;
        } else {
            b2 = this.regs.beg[i2];
            e = this.regs.end[i2];
        }
        if (b2 < 0) {
            return runtime.newArray(runtime.getNil(), runtime.getNil());
        }
        if (is_19 && !this.str.singleByteOptimizable()) {
            this.updateCharOffset();
            b2 = this.charOffsets.beg[i2];
            e = this.charOffsets.end[i2];
        }
        return runtime.newArray((IRubyObject)RubyFixnum.newFixnum(runtime, b2), (IRubyObject)RubyFixnum.newFixnum(runtime, e));
    }

    @JRubyMethod(name={"pre_match"})
    public IRubyObject pre_match(ThreadContext context) {
        this.check();
        if (this.begin == -1) {
            return context.runtime.getNil();
        }
        return this.makeShared(context.runtime, this.str, 0, this.begin).infectBy(this);
    }

    @JRubyMethod(name={"post_match"})
    public IRubyObject post_match(ThreadContext context) {
        this.check();
        if (this.begin == -1) {
            return context.runtime.getNil();
        }
        return this.makeShared(context.runtime, this.str, this.end, this.str.getByteList().length() - this.end).infectBy(this);
    }

    @Override
    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        this.check();
        IRubyObject ss = RubyRegexp.last_match(this);
        if (ss.isNil()) {
            ss = RubyString.newEmptyString(this.getRuntime());
        }
        if (this.isTaint()) {
            ss.setTaint(true);
        }
        return ss;
    }

    @JRubyMethod(name={"string"})
    public IRubyObject string() {
        this.check();
        return this.str;
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject original) {
        if (this == original) {
            return this;
        }
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        if (original instanceof RubyBasicObject && !((RubyBasicObject)original).instance_of_p(context, this.getMetaClass()).isTrue()) {
            throw runtime.newTypeError("wrong argument class");
        }
        RubyMatchData origMatchData = (RubyMatchData)original;
        this.str = origMatchData.str;
        this.regs = origMatchData.regs;
        return this;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RubyMatchData)) {
            return false;
        }
        RubyMatchData match2 = (RubyMatchData)other;
        return (this.str == match2.str || this.str != null && this.str.equals(match2.str)) && (this.regexp == match2.regexp || this.regexp != null && this.regexp.equals(match2.regexp)) && (this.charOffsets == match2.charOffsets || this.charOffsets != null && this.charOffsets.equals(match2.charOffsets)) && this.begin == match2.begin && this.end == match2.end && this.charOffsetUpdated == match2.charOffsetUpdated;
    }

    @Override
    @JRubyMethod(name={"eql?", "=="}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject eql_p(IRubyObject obj) {
        return this.getRuntime().newBoolean(this.equals(obj));
    }

    @Override
    @JRubyMethod(name={"hash"}, compat=CompatVersion.RUBY1_9)
    public RubyFixnum hash() {
        this.check();
        return this.getRuntime().newFixnum(this.pattern.hashCode() ^ this.str.hashCode());
    }

    private static final class Pair
    implements Comparable<Pair> {
        int bytePos;
        int charPos;

        private Pair() {
        }

        @Override
        public int compareTo(Pair pair) {
            return this.bytePos - pair.bytePos;
        }
    }
}

