/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.objectweb.asm.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jruby.objectweb.asm.Label;
import org.jruby.objectweb.asm.MethodVisitor;
import org.jruby.objectweb.asm.tree.AbstractInsnNode;
import org.jruby.objectweb.asm.tree.LabelNode;

public class LookupSwitchInsnNode
extends AbstractInsnNode {
    public LabelNode dflt;
    public List keys;
    public List labels;

    public LookupSwitchInsnNode(LabelNode labelNode, int[] nArray, LabelNode[] labelNodeArray) {
        super(171);
        this.dflt = labelNode;
        this.keys = new ArrayList(nArray == null ? 0 : nArray.length);
        this.labels = new ArrayList(labelNodeArray == null ? 0 : labelNodeArray.length);
        if (nArray != null) {
            for (int j = 0; j < nArray.length; ++j) {
                this.keys.add(new Integer(nArray[j]));
            }
        }
        if (labelNodeArray != null) {
            this.labels.addAll(Arrays.asList(labelNodeArray));
        }
    }

    public int getType() {
        return 12;
    }

    public void accept(MethodVisitor methodVisitor) {
        int[] nArray = new int[this.keys.size()];
        for (int j = 0; j < nArray.length; ++j) {
            nArray[j] = (Integer)this.keys.get(j);
        }
        Label[] labelArray = new Label[this.labels.size()];
        for (int j = 0; j < labelArray.length; ++j) {
            labelArray[j] = ((LabelNode)this.labels.get(j)).getLabel();
        }
        methodVisitor.visitLookupSwitchInsn(this.dflt.getLabel(), nArray, labelArray);
        this.acceptAnnotations(methodVisitor);
    }

    public AbstractInsnNode clone(Map map) {
        LookupSwitchInsnNode lookupSwitchInsnNode = new LookupSwitchInsnNode(LookupSwitchInsnNode.clone(this.dflt, map), null, LookupSwitchInsnNode.clone(this.labels, map));
        lookupSwitchInsnNode.keys.addAll(this.keys);
        return lookupSwitchInsnNode.cloneAnnotations(this);
    }
}

