/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.IOException;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jruby.util.io.SelectorFactory;

public class SelectorPool {
    private final Map<SelectorProvider, List<Selector>> pool = new HashMap<SelectorProvider, List<Selector>>();

    public synchronized Selector get() throws IOException {
        return this.retrieveFromPool(SelectorProvider.provider());
    }

    public synchronized Selector get(SelectorProvider provider) throws IOException {
        return this.retrieveFromPool(provider);
    }

    public synchronized void put(Selector selector) {
        this.returnToPool(selector);
    }

    public synchronized void cleanup() {
        for (Map.Entry<SelectorProvider, List<Selector>> entry : this.pool.entrySet()) {
            List<Selector> providerPool = entry.getValue();
            while (!providerPool.isEmpty()) {
                Selector selector = providerPool.remove(providerPool.size() - 1);
                try {
                    selector.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.pool.clear();
    }

    private Selector retrieveFromPool(SelectorProvider provider) throws IOException {
        List<Selector> providerPool = this.pool.get(provider);
        if (providerPool != null && !providerPool.isEmpty()) {
            return providerPool.remove(providerPool.size() - 1);
        }
        return SelectorFactory.openWithRetryFrom(null, provider);
    }

    private void returnToPool(Selector selector) {
        SelectorProvider provider = selector.provider();
        List<Selector> providerPool = this.pool.get(provider);
        if (providerPool == null) {
            providerPool = new LinkedList<Selector>();
            this.pool.put(provider, providerPool);
        }
        providerPool.add(selector);
    }
}

