/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed;

import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.ScriptingContainer;
import org.jruby.util.UriLikePathHelper;

public class IsolatedScriptingContainer
extends ScriptingContainer {
    private static final String URI_CLASSLOADER = "uri:classloader:/";
    private static final String JRUBYDIR = "/.jrubydir";
    private static final String JRUBY_HOME = "/META-INF/jruby.home";

    public IsolatedScriptingContainer() {
        this(LocalContextScope.SINGLETON);
    }

    public IsolatedScriptingContainer(LocalContextScope scope, LocalVariableBehavior behavior) {
        this(scope, behavior, true);
    }

    public IsolatedScriptingContainer(LocalContextScope scope) {
        this(scope, LocalVariableBehavior.TRANSIENT);
    }

    public IsolatedScriptingContainer(LocalVariableBehavior behavior) {
        this(LocalContextScope.SINGLETON, behavior);
    }

    public IsolatedScriptingContainer(LocalContextScope scope, LocalVariableBehavior behavior, boolean lazy) {
        super(scope, behavior, lazy);
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        this.setClassLoader(cl);
        LinkedList<String> loadPaths = new LinkedList<String>();
        loadPaths.add(URI_CLASSLOADER);
        this.setLoadPaths(loadPaths);
        UriLikePathHelper uriPath = new UriLikePathHelper(cl);
        URL url = uriPath.getResource("/META-INF/jruby.home/.jrubydir");
        if (url != null) {
            this.setHomeDirectory("uri:classloader://META-INF/jruby.home");
        }
        if ((url = uriPath.getResource(JRUBYDIR)) != null) {
            this.setCurrentDirectory(URI_CLASSLOADER);
        }
        this.setEnvironment(null);
    }

    @Override
    public void setEnvironment(Map environment) {
        if (!(environment != null && environment.containsKey("GEM_PATH") && environment.containsKey("GEM_HOME") && environment.containsKey("JARS_HOME"))) {
            HashMap<String, String> env;
            HashMap<String, String> hashMap = env = environment == null ? new HashMap<String, String>() : new HashMap(environment);
            if (!env.containsKey("GEM_PATH")) {
                env.put("GEM_PATH", URI_CLASSLOADER);
            }
            if (!env.containsKey("GEM_HOME")) {
                env.put("GEM_HOME", URI_CLASSLOADER);
            }
            if (!env.containsKey("JARS_HOME")) {
                env.put("JARS_HOME", "uri:classloader:/jars");
            }
            super.setEnvironment(env);
        } else {
            super.setEnvironment(environment);
        }
    }

    public void addLoadPath(ClassLoader cl) {
        this.addLoadPath(new UriLikePathHelper(cl).getUriLikePath());
    }

    public void addLoadPath(ClassLoader cl, String ref) {
        this.addLoadPath(new UriLikePathHelper(cl).getUriLikePath(ref));
    }

    protected void addLoadPath(String uri) {
        if (!this.getLoadPaths().contains(uri)) {
            this.getLoadPaths().add(uri);
        }
    }

    public void addGemPath(ClassLoader cl) {
        this.addGemPath(new UriLikePathHelper(cl).getUriLikePath("/specifications/.jrubydir"));
    }

    public void addGemPath(ClassLoader cl, String ref) {
        this.addGemPath(new UriLikePathHelper(cl).getUriLikePath(ref));
    }

    protected void addGemPath(String uri) {
        this.runScriptlet("Gem::Specification.add_dir '" + uri + "' unless Gem::Specification.dirs.member?( '" + uri + "' )");
    }
}

