/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.s3.util;

import com.amazonaws.1.11.21.shade.services.s3.model.AccessControlList;
import com.amazonaws.1.11.21.shade.services.s3.model.BucketLifecycleConfiguration;
import com.amazonaws.1.11.21.shade.services.s3.model.BucketNotificationConfiguration;
import com.amazonaws.1.11.21.shade.services.s3.model.CORSRule;
import com.amazonaws.1.11.21.shade.services.s3.model.CanonicalGrantee;
import com.amazonaws.1.11.21.shade.services.s3.model.CopyPartResult;
import com.amazonaws.1.11.21.shade.services.s3.model.MultipartUpload;
import com.amazonaws.1.11.21.shade.services.s3.model.NotificationConfiguration;
import com.amazonaws.1.11.21.shade.services.s3.model.ObjectListing;
import com.amazonaws.1.11.21.shade.services.s3.model.ObjectMetadata;
import com.amazonaws.1.11.21.shade.services.s3.model.PartSummary;
import com.amazonaws.1.11.21.shade.services.s3.model.RoutingRuleCondition;
import com.amazonaws.1.11.21.shade.services.s3.model.StorageClass;
import com.amazonaws.1.11.21.shade.services.s3.model.TopicConfiguration;
import com.amazonaws.1.11.21.shade.services.s3.model.UploadPartResult;
import com.amazonaws.1.11.21.shade.services.s3.model.VersionListing;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.mule.module.s3.model.BLCRule;
import org.mule.module.s3.model.Bucket;
import org.mule.module.s3.model.BucketWebsiteConfiguration;
import org.mule.module.s3.model.CORSRule;
import org.mule.module.s3.model.CompleteMultipartUploadResult;
import org.mule.module.s3.model.EmailAddressGrantee;
import org.mule.module.s3.model.Grant;
import org.mule.module.s3.model.Grantee;
import org.mule.module.s3.model.GroupGrantee;
import org.mule.module.s3.model.MultipartUploadListing;
import org.mule.module.s3.model.Owner;
import org.mule.module.s3.model.PartListing;
import org.mule.module.s3.model.Permission;
import org.mule.module.s3.model.RedirectRule;
import org.mule.module.s3.model.RoutingRule;
import org.mule.module.s3.model.S3Object;
import org.mule.module.s3.model.S3ObjectMetadata;
import org.mule.module.s3.model.S3ObjectSummary;
import org.mule.module.s3.model.S3VersionSummary;

public class S3ModelFactory {
    private S3ModelFactory() {
    }

    public static Bucket wrapBucket(com.amazonaws.1.11.21.shade.services.s3.model.Bucket bucket) {
        if (bucket.getOwner() != null) {
            return new Bucket(bucket.getName(), new Owner(bucket.getOwner().getId(), bucket.getOwner().getDisplayName()), bucket.getCreationDate());
        }
        return new Bucket(bucket.getName(), new Owner(), bucket.getCreationDate());
    }

    public static AccessControlList unwrapAccessControlList(org.mule.module.s3.model.AccessControlList acl) {
        AccessControlList accessControlList = new AccessControlList();
        if (acl.getOwner() != null) {
            accessControlList.setOwner(new com.amazonaws.1.11.21.shade.services.s3.model.Owner(acl.getOwner().getId(), acl.getOwner().getDisplayName()));
        }
        if (acl.getGrants() != null) {
            for (Grant grant : acl.getGrants()) {
                com.amazonaws.1.11.21.shade.services.s3.model.Grantee grantee = grant.getGrantee().getTypeIdentifier().equalsIgnoreCase("id") ? new CanonicalGrantee(grant.getGrantee().getIdentifier()) : (grant.getGrantee().getTypeIdentifier().equalsIgnoreCase("emailAddress") ? new com.amazonaws.1.11.21.shade.services.s3.model.EmailAddressGrantee(grant.getGrantee().getIdentifier()) : com.amazonaws.1.11.21.shade.services.s3.model.GroupGrantee.parseGroupGrantee(grant.getGrantee().getIdentifier()));
                com.amazonaws.1.11.21.shade.services.s3.model.Permission permission = com.amazonaws.1.11.21.shade.services.s3.model.Permission.parsePermission(grant.getPermission().toString());
                accessControlList.grantPermission(grantee, permission);
            }
        }
        return accessControlList;
    }

    public static org.mule.module.s3.model.AccessControlList wrapAccessControlList(AccessControlList objectAcl) {
        org.mule.module.s3.model.AccessControlList acl = new org.mule.module.s3.model.AccessControlList();
        if (objectAcl.getOwner() != null) {
            acl.setOwner(new Owner(objectAcl.getOwner().getId(), objectAcl.getOwner().getDisplayName()));
        }
        if (objectAcl.getGrantsAsList() != null) {
            for (com.amazonaws.1.11.21.shade.services.s3.model.Grant grant : objectAcl.getGrantsAsList()) {
                Grantee grantee = grant.getGrantee().getTypeIdentifier().equalsIgnoreCase("id") ? new org.mule.module.s3.model.CanonicalGrantee(grant.getGrantee().getIdentifier()) : (grant.getGrantee().getTypeIdentifier().equalsIgnoreCase("emailAddress") ? new EmailAddressGrantee(grant.getGrantee().getIdentifier()) : GroupGrantee.parseGroupGrantee(grant.getGrantee().getIdentifier()));
                Permission permission = Permission.parsePermission(grant.getPermission().toString());
                acl.grantPermission(grantee, permission);
            }
        }
        return acl;
    }

    public static List<org.mule.module.s3.model.CORSRule> wrapBucketCrossOriginConfigurationRules(List<CORSRule> rules) {
        ArrayList<org.mule.module.s3.model.CORSRule> corsRules = new ArrayList<org.mule.module.s3.model.CORSRule>(rules.size());
        for (CORSRule rule : rules) {
            org.mule.module.s3.model.CORSRule corsRule = new org.mule.module.s3.model.CORSRule(rule.getId());
            corsRule.setMaxAgeSeconds(rule.getMaxAgeSeconds());
            corsRule.setAllowedHeaders(rule.getAllowedHeaders());
            corsRule.setAllowedOrigins(rule.getAllowedOrigins());
            corsRule.setExposedHeaders(rule.getExposedHeaders());
            if (rule.getAllowedMethods() != null) {
                ArrayList<CORSRule.AllowedMethods> allowedMethods = new ArrayList<CORSRule.AllowedMethods>(rule.getAllowedMethods().size());
                for (CORSRule.AllowedMethods allowedMethod : rule.getAllowedMethods()) {
                    allowedMethods.add(CORSRule.AllowedMethods.fromValue(allowedMethod.toString()));
                }
                corsRule.setAllowedMethods(allowedMethods);
            }
            corsRules.add(corsRule);
        }
        return corsRules;
    }

    public static List<CORSRule> unwrapBucketCrossOriginConfigurationRules(List<org.mule.module.s3.model.CORSRule> crossOriginConfigurationRules) {
        ArrayList<CORSRule> corsRules = new ArrayList<CORSRule>(crossOriginConfigurationRules.size());
        for (org.mule.module.s3.model.CORSRule rule : crossOriginConfigurationRules) {
            CORSRule corsRule = new CORSRule();
            corsRule.setId(rule.getId());
            corsRule.setMaxAgeSeconds(rule.getMaxAgeSeconds());
            corsRule.setAllowedHeaders(rule.getAllowedHeaders());
            corsRule.setAllowedOrigins(rule.getAllowedOrigins());
            corsRule.setExposedHeaders(rule.getExposedHeaders());
            if (rule.getAllowedMethods() != null) {
                ArrayList<CORSRule.AllowedMethods> allowedMethods = new ArrayList<CORSRule.AllowedMethods>(rule.getAllowedMethods().size());
                for (CORSRule.AllowedMethods allowedMethod : rule.getAllowedMethods()) {
                    allowedMethods.add(CORSRule.AllowedMethods.fromValue(allowedMethod.toString()));
                }
                corsRule.setAllowedMethods(allowedMethods);
            }
            corsRules.add(corsRule);
        }
        return corsRules;
    }

    public static List<BLCRule> wrapBucketLifecycleRules(List<BucketLifecycleConfiguration.Rule> rules) {
        ArrayList<BLCRule> blcRules = new ArrayList<BLCRule>(rules.size());
        for (BucketLifecycleConfiguration.Rule rule : rules) {
            BucketLifecycleConfiguration.NoncurrentVersionTransition noncurrentVersionTransition;
            BLCRule blcRule = new BLCRule(rule.getId());
            blcRule.setPrefix(rule.getPrefix());
            blcRule.setStatus(rule.getStatus());
            blcRule.setExpirationDate(rule.getExpirationDate());
            blcRule.setExpirationInDays(rule.getExpirationInDays());
            blcRule.setNoncurrentVersionExpirationInDays(rule.getNoncurrentVersionExpirationInDays());
            BucketLifecycleConfiguration.Transition transition = rule.getTransition();
            if (transition != null) {
                BLCRule.Transition newTransition = new BLCRule.Transition();
                newTransition.setDate(transition.getDate());
                newTransition.setDays(transition.getDays());
                newTransition.setStorageClass(org.mule.module.s3.model.StorageClass.fromValue(transition.getStorageClass().toString()));
                blcRule.setTransition(newTransition);
            }
            if ((noncurrentVersionTransition = rule.getNoncurrentVersionTransition()) != null) {
                BLCRule.NoncurrentVersionTransition versionTransition = new BLCRule.NoncurrentVersionTransition();
                versionTransition.setDays(noncurrentVersionTransition.getDays());
                versionTransition.setStorageClass(org.mule.module.s3.model.StorageClass.fromValue(noncurrentVersionTransition.getStorageClass().toString()));
                blcRule.setNoncurrentVersionTransition(versionTransition);
            }
            blcRules.add(blcRule);
        }
        return blcRules;
    }

    public static List<BucketLifecycleConfiguration.Rule> unwrapBucketLifecycleConfigurationRules(List<BLCRule> lifecycleConfigurationRules) {
        ArrayList<BucketLifecycleConfiguration.Rule> blcRules = new ArrayList<BucketLifecycleConfiguration.Rule>(lifecycleConfigurationRules.size());
        for (BLCRule rule : lifecycleConfigurationRules) {
            BLCRule.NoncurrentVersionTransition noncurrentVersionTransition;
            BucketLifecycleConfiguration.Rule blcRule = new BucketLifecycleConfiguration.Rule();
            blcRule.setId(rule.getId());
            blcRule.setPrefix(rule.getPrefix());
            blcRule.setStatus(rule.getStatus());
            blcRule.setExpirationDate(rule.getExpirationDate());
            blcRule.setExpirationInDays(rule.getExpirationInDays());
            blcRule.setNoncurrentVersionExpirationInDays(rule.getNoncurrentVersionExpirationInDays());
            BLCRule.Transition transition = rule.getTransition();
            if (transition != null) {
                BucketLifecycleConfiguration.Transition newTransition = new BucketLifecycleConfiguration.Transition();
                newTransition.setDate(transition.getDate());
                newTransition.setDays(transition.getDays());
                newTransition.setStorageClass(StorageClass.fromValue(transition.getStorageClass().toString()));
                blcRule.setTransition(newTransition);
            }
            if ((noncurrentVersionTransition = rule.getNoncurrentVersionTransition()) != null) {
                BucketLifecycleConfiguration.NoncurrentVersionTransition versionTransition = new BucketLifecycleConfiguration.NoncurrentVersionTransition();
                versionTransition.setDays(noncurrentVersionTransition.getDays());
                versionTransition.setStorageClass(StorageClass.fromValue(noncurrentVersionTransition.getStorageClass().toString()));
                blcRule.setNoncurrentVersionTransition(versionTransition);
            }
            blcRules.add(blcRule);
        }
        return blcRules;
    }

    public static com.amazonaws.1.11.21.shade.services.s3.model.BucketWebsiteConfiguration unwrapBucketWebsiteConfiguration(BucketWebsiteConfiguration configuration) {
        List<RoutingRule> routingRules;
        com.amazonaws.1.11.21.shade.services.s3.model.BucketWebsiteConfiguration newConfiguration = new com.amazonaws.1.11.21.shade.services.s3.model.BucketWebsiteConfiguration(configuration.getIndexDocumentSuffix(), configuration.getErrorDocument());
        RedirectRule redirectRule = configuration.getRedirectAllRequestsTo();
        if (redirectRule != null) {
            com.amazonaws.1.11.21.shade.services.s3.model.RedirectRule newRedirectRule = new com.amazonaws.1.11.21.shade.services.s3.model.RedirectRule().withHostName(redirectRule.getHostName()).withProtocol(redirectRule.getprotocol()).withReplaceKeyPrefixWith(redirectRule.getReplaceKeyPrefixWith()).withReplaceKeyWith(redirectRule.getReplaceKeyWith()).withHttpRedirectCode(redirectRule.getHttpRedirectCode());
            newConfiguration.setRedirectAllRequestsTo(newRedirectRule);
        }
        if (!(routingRules = configuration.getRoutingRules()).isEmpty()) {
            ArrayList<com.amazonaws.1.11.21.shade.services.s3.model.RoutingRule> newRoutingRules = new ArrayList<com.amazonaws.1.11.21.shade.services.s3.model.RoutingRule>(routingRules.size());
            for (RoutingRule routingRule : routingRules) {
                RoutingRuleCondition ruleCondition = null;
                org.mule.module.s3.model.RoutingRuleCondition condition = routingRule.getCondition();
                if (condition != null) {
                    ruleCondition = new RoutingRuleCondition().withHttpErrorCodeReturnedEquals(condition.getHttpErrorCodeReturnedEquals()).withKeyPrefixEquals(condition.getKeyPrefixEquals());
                }
                com.amazonaws.1.11.21.shade.services.s3.model.RedirectRule rule = null;
                RedirectRule ruleRedirect = routingRule.getRedirect();
                if (ruleRedirect != null) {
                    rule = new com.amazonaws.1.11.21.shade.services.s3.model.RedirectRule().withHostName(ruleRedirect.getHostName()).withProtocol(ruleRedirect.getprotocol()).withHttpRedirectCode(ruleRedirect.getHttpRedirectCode()).withReplaceKeyPrefixWith(ruleRedirect.getReplaceKeyPrefixWith()).withReplaceKeyWith(ruleRedirect.getReplaceKeyWith());
                }
                newRoutingRules.add(new com.amazonaws.1.11.21.shade.services.s3.model.RoutingRule().withCondition(ruleCondition).withRedirect(rule));
            }
            newConfiguration.setRoutingRules(newRoutingRules);
        }
        return newConfiguration;
    }

    public static BucketWebsiteConfiguration wrapBucketWebsiteConfiguration(com.amazonaws.1.11.21.shade.services.s3.model.BucketWebsiteConfiguration configuration) {
        BucketWebsiteConfiguration newConfiguration = new BucketWebsiteConfiguration();
        if (configuration != null) {
            List<com.amazonaws.1.11.21.shade.services.s3.model.RoutingRule> routingRules;
            newConfiguration.setIndexDocumentSuffix(configuration.getIndexDocumentSuffix());
            newConfiguration.setErrorDocument(configuration.getErrorDocument());
            com.amazonaws.1.11.21.shade.services.s3.model.RedirectRule redirectRule = configuration.getRedirectAllRequestsTo();
            if (redirectRule != null) {
                RedirectRule newRedirectRule = new RedirectRule().withHostName(redirectRule.getHostName()).withProtocol(redirectRule.getprotocol()).withReplaceKeyPrefixWith(redirectRule.getReplaceKeyPrefixWith()).withReplaceKeyWith(redirectRule.getReplaceKeyWith()).withHttpRedirectCode(redirectRule.getHttpRedirectCode());
                newConfiguration.setRedirectAllRequestsTo(newRedirectRule);
            }
            if ((routingRules = configuration.getRoutingRules()) != null) {
                ArrayList<RoutingRule> newRoutingRules = new ArrayList<RoutingRule>(routingRules.size());
                for (com.amazonaws.1.11.21.shade.services.s3.model.RoutingRule routingRule : routingRules) {
                    RoutingRuleCondition condition = routingRule.getCondition();
                    org.mule.module.s3.model.RoutingRuleCondition ruleCondition = null;
                    if (condition != null) {
                        ruleCondition = new org.mule.module.s3.model.RoutingRuleCondition().withHttpErrorCodeReturnedEquals(condition.getHttpErrorCodeReturnedEquals()).withKeyPrefixEquals(condition.getKeyPrefixEquals());
                    }
                    com.amazonaws.1.11.21.shade.services.s3.model.RedirectRule ruleRedirect = routingRule.getRedirect();
                    RedirectRule rule = null;
                    if (ruleRedirect != null) {
                        rule = new RedirectRule().withHostName(ruleRedirect.getHostName()).withProtocol(ruleRedirect.getprotocol()).withHttpRedirectCode(ruleRedirect.getHttpRedirectCode()).withReplaceKeyPrefixWith(ruleRedirect.getReplaceKeyPrefixWith()).withReplaceKeyWith(ruleRedirect.getReplaceKeyWith());
                    }
                    newRoutingRules.add(new RoutingRule().withCondition(ruleCondition).withRedirect(rule));
                }
                newConfiguration.setRoutingRules(newRoutingRules);
            }
        }
        return newConfiguration;
    }

    public static S3ObjectMetadata wrapS3ObjectMetadata(ObjectMetadata objectMetadata) {
        S3ObjectMetadata metadata = new S3ObjectMetadata();
        if (objectMetadata != null) {
            metadata.setCacheControl(objectMetadata.getCacheControl());
            metadata.setContentDisposition(objectMetadata.getContentDisposition());
            metadata.setContentEncoding(objectMetadata.getContentEncoding());
            metadata.setContentLength(objectMetadata.getContentLength());
            metadata.setContentMD5(objectMetadata.getContentMD5());
            metadata.setContentType(objectMetadata.getContentType());
            metadata.setExpirationTime(objectMetadata.getExpirationTime());
            metadata.setExpirationTimeRuleId(objectMetadata.getExpirationTimeRuleId());
            metadata.setHttpExpiresDate(objectMetadata.getHttpExpiresDate());
            metadata.setLastModified(objectMetadata.getLastModified());
            metadata.setOngoingRestore(objectMetadata.getOngoingRestore());
            metadata.setSSEAlgorithm(objectMetadata.getSSEAlgorithm());
            metadata.setSSECustomerAlgorithm(objectMetadata.getSSECustomerAlgorithm());
            metadata.setSSECustomerKeyMd5(objectMetadata.getSSECustomerKeyMd5());
            metadata.setUserMetadata(objectMetadata.getUserMetadata());
            metadata.setETag(objectMetadata.getETag());
            metadata.setVersionId(objectMetadata.getVersionId());
        }
        return metadata;
    }

    public static ObjectMetadata wrapObjectMetaData(S3ObjectMetadata objectMetadata) {
        if (objectMetadata != null) {
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setCacheControl(objectMetadata.getCacheControl());
            metadata.setContentDisposition(objectMetadata.getContentDisposition());
            metadata.setContentEncoding(objectMetadata.getContentEncoding());
            metadata.setContentLength(objectMetadata.getContentLength());
            metadata.setContentMD5(objectMetadata.getContentMD5());
            metadata.setContentType(objectMetadata.getContentType());
            metadata.setExpirationTime(objectMetadata.getExpirationTime());
            metadata.setExpirationTimeRuleId(objectMetadata.getExpirationTimeRuleId());
            metadata.setHttpExpiresDate(objectMetadata.getHttpExpiresDate());
            metadata.setLastModified(objectMetadata.getLastModified());
            if (objectMetadata.getOngoingRestore() != null) {
                metadata.setOngoingRestore(objectMetadata.getOngoingRestore());
            }
            metadata.setSSEAlgorithm(objectMetadata.getSSEAlgorithm());
            metadata.setSSECustomerAlgorithm(objectMetadata.getSSECustomerAlgorithm());
            metadata.setSSECustomerKeyMd5(objectMetadata.getSSECustomerKeyMd5());
            metadata.setUserMetadata(objectMetadata.getUserMetadata());
            return metadata;
        }
        return null;
    }

    public static S3Object wrapS3Object(com.amazonaws.1.11.21.shade.services.s3.model.S3Object object) {
        S3Object s3Object = new S3Object();
        if (object != null) {
            s3Object.setBucketName(object.getBucketName());
            s3Object.setKey(object.getKey());
            s3Object.setObjectContent(object.getObjectContent());
            if (object.getObjectMetadata() != null) {
                s3Object.setObjectMetadata(S3ModelFactory.wrapS3ObjectMetadata(object.getObjectMetadata()));
            }
            s3Object.setRedirectLocation(object.getRedirectLocation());
            s3Object.setRequesterCharged(object.isRequesterCharged());
        }
        return s3Object;
    }

    public static Map<String, org.mule.module.s3.model.TopicConfiguration> wrapBucketNotification(BucketNotificationConfiguration configuration) {
        HashMap<String, org.mule.module.s3.model.TopicConfiguration> configurationMap = new HashMap<String, org.mule.module.s3.model.TopicConfiguration>();
        if (configuration != null) {
            for (Map.Entry<String, NotificationConfiguration> entry : configuration.getConfigurations().entrySet()) {
                if (!(entry.getValue() instanceof TopicConfiguration)) continue;
                TopicConfiguration entryValue = (TopicConfiguration)entry.getValue();
                org.mule.module.s3.model.TopicConfiguration notification = new org.mule.module.s3.model.TopicConfiguration(entryValue.getTopicARN(), new String[0]);
                notification.setEvents(entryValue.getEvents());
                notification.setObjectPrefixes(entryValue.getObjectPrefixes());
                configurationMap.put(entry.getKey(), notification);
            }
        }
        return configurationMap;
    }

    public static BucketNotificationConfiguration unwrapBucketNotification(@NotNull Map<String, org.mule.module.s3.model.TopicConfiguration> notificationConfigurations) {
        BucketNotificationConfiguration bucketConfiguration = new BucketNotificationConfiguration();
        HashMap<String, NotificationConfiguration> configurations = new HashMap<String, NotificationConfiguration>();
        for (Map.Entry<String, org.mule.module.s3.model.TopicConfiguration> entry : notificationConfigurations.entrySet()) {
            TopicConfiguration topicConfiguration = new TopicConfiguration(entry.getValue().getTopicARN(), new String[0]);
            topicConfiguration.setEvents(entry.getValue().getEvents());
            topicConfiguration.setObjectPrefixes(entry.getValue().getObjectPrefixes());
            configurations.put(entry.getKey(), topicConfiguration);
        }
        return bucketConfiguration.withNotificationConfiguration(configurations);
    }

    public static org.mule.module.s3.model.UploadPartResult wrapUploadPartResult(UploadPartResult partResult) {
        org.mule.module.s3.model.UploadPartResult result = new org.mule.module.s3.model.UploadPartResult();
        if (partResult != null) {
            result.setETag(partResult.getETag());
            result.setPartNumber(partResult.getPartNumber());
        }
        return result;
    }

    public static org.mule.module.s3.model.CopyPartResult wrapCopyPartResult(CopyPartResult partResult) {
        org.mule.module.s3.model.CopyPartResult result = new org.mule.module.s3.model.CopyPartResult();
        if (partResult != null) {
            result.setETag(partResult.getETag());
            result.setLastModifiedDate(partResult.getLastModifiedDate());
            result.setPartNumber(partResult.getPartNumber());
            result.setVersionId(partResult.getVersionId());
        }
        return result;
    }

    public static CompleteMultipartUploadResult wrapCompleteMultipartUploadResult(com.amazonaws.1.11.21.shade.services.s3.model.CompleteMultipartUploadResult uploadResult) {
        CompleteMultipartUploadResult result = new CompleteMultipartUploadResult();
        if (uploadResult != null) {
            result.setBucketName(uploadResult.getBucketName());
            result.setETag(uploadResult.getETag());
            result.setExpirationTime(uploadResult.getExpirationTime());
            result.setExpirationTimeRuleId(uploadResult.getExpirationTimeRuleId());
            result.setKey(uploadResult.getKey());
            result.setLocation(uploadResult.getLocation());
            result.setVersionId(uploadResult.getVersionId());
        }
        return result;
    }

    public static MultipartUploadListing wrapMultipartUploadListing(com.amazonaws.1.11.21.shade.services.s3.model.MultipartUploadListing multipartListing) {
        MultipartUploadListing result = new MultipartUploadListing();
        if (multipartListing != null) {
            result.setBucketName(multipartListing.getBucketName());
            result.setCommonPrefixes(multipartListing.getCommonPrefixes());
            result.setDelimiter(multipartListing.getDelimiter());
            result.setEncodingType(multipartListing.getEncodingType());
            result.setKeyMarker(multipartListing.getKeyMarker());
            result.setMaxUploads(multipartListing.getMaxUploads());
            result.setNextKeyMarker(multipartListing.getNextKeyMarker());
            result.setNextUploadIdMarker(multipartListing.getNextUploadIdMarker());
            result.setPrefix(multipartListing.getPrefix());
            result.setTruncated(multipartListing.isTruncated());
            result.setUploadIdMarker(multipartListing.getUploadIdMarker());
            ArrayList<org.mule.module.s3.model.MultipartUpload> multipartUploadList = new ArrayList<org.mule.module.s3.model.MultipartUpload>(multipartListing.getMultipartUploads().size());
            for (MultipartUpload upload : multipartListing.getMultipartUploads()) {
                org.mule.module.s3.model.MultipartUpload partUpload = new org.mule.module.s3.model.MultipartUpload();
                partUpload.setInitiated(upload.getInitiated());
                if (upload.getInitiator() != null) {
                    partUpload.setInitiator(new Owner(upload.getInitiator().getId(), upload.getInitiator().getDisplayName()));
                }
                if (upload.getOwner() != null) {
                    partUpload.setOwner(new Owner(upload.getOwner().getId(), upload.getOwner().getDisplayName()));
                }
                partUpload.setKey(upload.getKey());
                partUpload.setStorageClass(upload.getStorageClass());
                partUpload.setUploadId(upload.getUploadId());
                multipartUploadList.add(partUpload);
            }
            result.setMultipartUploads(multipartUploadList);
        }
        return result;
    }

    public static PartListing wrapPartListing(com.amazonaws.1.11.21.shade.services.s3.model.PartListing partListing) {
        PartListing result = new PartListing();
        if (partListing != null) {
            result.setBucketName(partListing.getBucketName());
            result.setEncodingType(partListing.getEncodingType());
            if (partListing.getInitiator() != null) {
                result.setInitiator(new Owner(partListing.getInitiator().getId(), partListing.getInitiator().getDisplayName()));
            }
            result.setKey(partListing.getKey());
            result.setMaxParts(partListing.getMaxParts());
            result.setNextPartNumberMarker(partListing.getNextPartNumberMarker());
            if (partListing.getOwner() != null) {
                result.setOwner(new Owner(partListing.getOwner().getId(), partListing.getOwner().getDisplayName()));
            }
            result.setPartNumberMarker(partListing.getPartNumberMarker());
            result.setStorageClass(partListing.getStorageClass());
            result.setTruncated(partListing.isTruncated());
            result.setUploadId(partListing.getUploadId());
            ArrayList<org.mule.module.s3.model.PartSummary> partSummaries = new ArrayList<org.mule.module.s3.model.PartSummary>(partListing.getParts().size());
            for (PartSummary partSummary : partListing.getParts()) {
                org.mule.module.s3.model.PartSummary summary = new org.mule.module.s3.model.PartSummary();
                summary.setETag(partSummary.getETag());
                summary.setLastModified(partSummary.getLastModified());
                summary.setPartNumber(partSummary.getPartNumber());
                summary.setSize(partSummary.getSize());
                partSummaries.add(summary);
            }
            result.setParts(partSummaries);
        }
        return result;
    }

    public static org.mule.module.s3.model.ObjectListing wrapObjectListing(ObjectListing objectListing) {
        org.mule.module.s3.model.ObjectListing result = new org.mule.module.s3.model.ObjectListing();
        if (objectListing != null) {
            result.setBucketName(objectListing.getBucketName());
            result.setCommonPrefixes(objectListing.getCommonPrefixes());
            result.setDelimiter(objectListing.getDelimiter());
            result.setEncodingType(objectListing.getEncodingType());
            result.setMarker(objectListing.getMarker());
            result.setMaxKeys(objectListing.getMaxKeys());
            result.setNextMarker(objectListing.getNextMarker());
            result.setPrefix(objectListing.getPrefix());
            result.setTruncated(objectListing.isTruncated());
            ArrayList<S3ObjectSummary> objectSummaries = new ArrayList<S3ObjectSummary>(objectListing.getObjectSummaries().size());
            for (com.amazonaws.1.11.21.shade.services.s3.model.S3ObjectSummary objectSummary : objectListing.getObjectSummaries()) {
                S3ObjectSummary summary = new S3ObjectSummary();
                summary.setBucketName(objectSummary.getBucketName());
                summary.setETag(objectSummary.getETag());
                summary.setKey(objectSummary.getKey());
                summary.setLastModified(objectSummary.getLastModified());
                if (objectSummary.getOwner() != null) {
                    summary.setOwner(new Owner(objectSummary.getOwner().getId(), objectSummary.getOwner().getDisplayName()));
                }
                summary.setSize(objectSummary.getSize());
                summary.setStorageClass(objectSummary.getStorageClass());
                objectSummaries.add(summary);
            }
            result.setObjectSummaries(objectSummaries);
        }
        return result;
    }

    public static org.mule.module.s3.model.VersionListing wrapVersionListing(VersionListing versionListing) {
        org.mule.module.s3.model.VersionListing result = new org.mule.module.s3.model.VersionListing();
        if (versionListing != null) {
            result.setBucketName(versionListing.getBucketName());
            result.setCommonPrefixes(versionListing.getCommonPrefixes());
            result.setDelimiter(versionListing.getDelimiter());
            result.setEncodingType(versionListing.getEncodingType());
            result.setKeyMarker(versionListing.getKeyMarker());
            result.setMaxKeys(versionListing.getMaxKeys());
            result.setNextKeyMarker(versionListing.getNextKeyMarker());
            result.setNextVersionIdMarker(versionListing.getNextVersionIdMarker());
            result.setPrefix(versionListing.getPrefix());
            result.setTruncated(versionListing.isTruncated());
            result.setVersionIdMarker(versionListing.getVersionIdMarker());
            ArrayList<S3VersionSummary> versionSummaries = new ArrayList<S3VersionSummary>(versionListing.getVersionSummaries().size());
            for (com.amazonaws.1.11.21.shade.services.s3.model.S3VersionSummary versionSummary : versionListing.getVersionSummaries()) {
                S3VersionSummary summary = new S3VersionSummary();
                summary.setBucketName(versionSummary.getBucketName());
                summary.setETag(versionSummary.getETag());
                summary.setIsDeleteMarker(versionSummary.isDeleteMarker());
                summary.setIsLatest(versionSummary.isLatest());
                summary.setKey(versionSummary.getKey());
                summary.setLastModified(versionSummary.getLastModified());
                if (versionSummary.getOwner() != null) {
                    summary.setOwner(new Owner(versionSummary.getOwner().getId(), versionSummary.getOwner().getDisplayName()));
                }
                summary.setSize(versionSummary.getSize());
                summary.setStorageClass(versionSummary.getStorageClass());
                summary.setVersionId(versionSummary.getVersionId());
                versionSummaries.add(summary);
            }
            result.setVersionSummaries(versionSummaries);
        }
        return result;
    }

    public static ObjectListing unwrapObjectListing(@NotNull org.mule.module.s3.model.ObjectListing objectListing) {
        ObjectListing result = new ObjectListing();
        result.setBucketName(objectListing.getBucketName());
        result.setCommonPrefixes(objectListing.getCommonPrefixes());
        result.setDelimiter(objectListing.getDelimiter());
        result.setEncodingType(objectListing.getEncodingType());
        result.setMarker(objectListing.getMarker());
        result.setMaxKeys(objectListing.getMaxKeys());
        result.setNextMarker(objectListing.getNextMarker());
        result.setPrefix(objectListing.getPrefix());
        result.setTruncated(objectListing.isTruncated());
        return result;
    }

    public static VersionListing unwrapVersionListing(@NotNull org.mule.module.s3.model.VersionListing versionListing) {
        VersionListing result = new VersionListing();
        result.setBucketName(versionListing.getBucketName());
        result.setCommonPrefixes(versionListing.getCommonPrefixes());
        result.setDelimiter(versionListing.getDelimiter());
        result.setEncodingType(versionListing.getEncodingType());
        result.setKeyMarker(versionListing.getKeyMarker());
        result.setMaxKeys(versionListing.getMaxKeys());
        result.setNextKeyMarker(versionListing.getNextKeyMarker());
        result.setNextVersionIdMarker(versionListing.getNextVersionIdMarker());
        result.setPrefix(versionListing.getPrefix());
        result.setTruncated(versionListing.isTruncated());
        result.setVersionIdMarker(versionListing.getVersionIdMarker());
        return result;
    }
}

