/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.s3.model;

public enum StorageClass {
    STANDARD("STANDARD"),
    REDUCED_REDUNDANCY("REDUCED_REDUNDANCY"),
    GLACIER("GLACIER");

    private final String storageClassId;

    private StorageClass(String id) {
        this.storageClassId = id;
    }

    public static StorageClass fromValue(String s3StorageClassString) throws IllegalArgumentException {
        for (StorageClass storageClass : StorageClass.values()) {
            if (!storageClass.toString().equals(s3StorageClassString)) continue;
            return storageClass;
        }
        throw new IllegalArgumentException("Cannot create enum from " + s3StorageClassString + " value!");
    }

    public String toString() {
        return this.storageClassId;
    }
}

