/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.s3.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class S3ObjectMetadata
implements Serializable {
    private static final long serialVersionUID = 4883629980933290064L;
    private Map<String, String> userMetadata;
    private Map<String, Object> metadata;
    private Date httpExpiresDate;
    private Date expirationTime;
    private String expirationTimeRuleId;
    private Boolean ongoingRestore;
    private Date restoreExpirationTime;

    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    public void setUserMetadata(Map<String, String> userMetadata) {
        this.userMetadata = userMetadata;
    }

    public void setHeader(String key, Object value) {
        this.metadata.put(key, value);
    }

    public void addUserMetadata(String key, String value) {
        this.userMetadata.put(key, value);
    }

    public Map<String, Object> getRawMetadata() {
        return Collections.unmodifiableMap(new HashMap<String, Object>(this.metadata));
    }

    public Object getRawMetadataValue(String key) {
        return this.metadata.get(key);
    }

    public Date getLastModified() {
        return (Date)this.metadata.get("Last-Modified");
    }

    public void setLastModified(Date lastModified) {
        this.metadata.put("Last-Modified", lastModified);
    }

    public long getContentLength() {
        Long contentLength = (Long)this.metadata.get("Content-Length");
        return contentLength == null ? 0L : contentLength;
    }

    public long getInstanceLength() {
        int pos;
        String contentRange = (String)this.metadata.get("Content-Range");
        if (contentRange != null && (pos = contentRange.lastIndexOf("/")) >= 0) {
            return Long.parseLong(contentRange.substring(pos + 1));
        }
        return this.getContentLength();
    }

    public void setContentLength(long contentLength) {
        this.metadata.put("Content-Length", contentLength);
    }

    public String getContentType() {
        return (String)this.metadata.get("Content-Type");
    }

    public void setContentType(String contentType) {
        this.metadata.put("Content-Type", contentType);
    }

    public String getContentEncoding() {
        return (String)this.metadata.get("Content-Encoding");
    }

    public void setContentEncoding(String encoding) {
        this.metadata.put("Content-Encoding", encoding);
    }

    public String getCacheControl() {
        return (String)this.metadata.get("Cache-Control");
    }

    public void setCacheControl(String cacheControl) {
        this.metadata.put("Cache-Control", cacheControl);
    }

    public void setContentMD5(String md5Base64) {
        if (md5Base64 == null) {
            this.metadata.remove("Content-MD5");
        } else {
            this.metadata.put("Content-MD5", md5Base64);
        }
    }

    public String getContentMD5() {
        return (String)this.metadata.get("Content-MD5");
    }

    public void setContentDisposition(String disposition) {
        this.metadata.put("Content-Disposition", disposition);
    }

    public String getContentDisposition() {
        return (String)this.metadata.get("Content-Disposition");
    }

    public String getETag() {
        return (String)this.metadata.get("ETag");
    }

    public void setETag(String eTag) {
        this.metadata.put("ETag", eTag);
    }

    public String getVersionId() {
        return (String)this.metadata.get("x-amz-version-id");
    }

    public void setVersionId(String versionId) {
        this.metadata.put("x-amz-version-id", versionId);
    }

    public String getSSEAlgorithm() {
        return (String)this.metadata.get("x-amz-server-side-encryption");
    }

    public void setSSEAlgorithm(String algorithm) {
        this.metadata.put("x-amz-server-side-encryption", algorithm);
    }

    public String getSSECustomerAlgorithm() {
        return (String)this.metadata.get("x-amz-server-side-encryption-customer-algorithm");
    }

    public void setSSECustomerAlgorithm(String algorithm) {
        this.metadata.put("x-amz-server-side-encryption-customer-algorithm", algorithm);
    }

    public String getSSECustomerKeyMd5() {
        return (String)this.metadata.get("x-amz-server-side-encryption-customer-key-MD5");
    }

    public void setSSECustomerKeyMd5(String md5Digest) {
        this.metadata.put("x-amz-server-side-encryption-customer-key-MD5", md5Digest);
    }

    public Date getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(Date expirationTime) {
        this.expirationTime = expirationTime;
    }

    public String getExpirationTimeRuleId() {
        return this.expirationTimeRuleId;
    }

    public void setExpirationTimeRuleId(String expirationTimeRuleId) {
        this.expirationTimeRuleId = expirationTimeRuleId;
    }

    public Date getRestoreExpirationTime() {
        return this.restoreExpirationTime;
    }

    public void setRestoreExpirationTime(Date restoreExpirationTime) {
        this.restoreExpirationTime = restoreExpirationTime;
    }

    public void setOngoingRestore(Boolean ongoingRestore) {
        this.ongoingRestore = ongoingRestore;
    }

    public Boolean getOngoingRestore() {
        return this.ongoingRestore;
    }

    public void setHttpExpiresDate(Date httpExpiresDate) {
        this.httpExpiresDate = httpExpiresDate;
    }

    public Date getHttpExpiresDate() {
        return this.httpExpiresDate;
    }

    public String getUserMetaDataOf(String key) {
        return this.userMetadata == null ? null : this.userMetadata.get(key);
    }

    public S3ObjectMetadata() {
        this.userMetadata = new HashMap<String, String>();
        this.metadata = new HashMap<String, Object>();
    }

    private S3ObjectMetadata(S3ObjectMetadata from) {
        this.userMetadata = from.userMetadata == null ? null : new HashMap<String, String>(from.userMetadata);
        this.metadata = from.metadata == null ? null : new HashMap<String, Object>(from.metadata);
        this.expirationTime = from.expirationTime;
        this.expirationTimeRuleId = from.expirationTimeRuleId;
        this.httpExpiresDate = from.httpExpiresDate;
        this.ongoingRestore = from.ongoingRestore;
        this.restoreExpirationTime = from.restoreExpirationTime;
    }
}

